/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.gson.Gson;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.Resource;
import com.microsoft.azure.SubResource;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.AvailabilitySet;
import com.microsoft.azure.management.compute.AvailabilitySetSkuTypes;
import com.microsoft.azure.management.compute.BillingProfile;
import com.microsoft.azure.management.compute.BootDiagnostics;
import com.microsoft.azure.management.compute.CachingTypes;
import com.microsoft.azure.management.compute.DataDisk;
import com.microsoft.azure.management.compute.DiagnosticsProfile;
import com.microsoft.azure.management.compute.Disk;
import com.microsoft.azure.management.compute.DiskCreateOptionTypes;
import com.microsoft.azure.management.compute.DiskEncryptionSettings;
import com.microsoft.azure.management.compute.HardwareProfile;
import com.microsoft.azure.management.compute.ImageReference;
import com.microsoft.azure.management.compute.InstanceViewTypes;
import com.microsoft.azure.management.compute.KnownLinuxVirtualMachineImage;
import com.microsoft.azure.management.compute.KnownWindowsVirtualMachineImage;
import com.microsoft.azure.management.compute.LinuxConfiguration;
import com.microsoft.azure.management.compute.ManagedDiskParameters;
import com.microsoft.azure.management.compute.NetworkInterfaceReference;
import com.microsoft.azure.management.compute.OSDisk;
import com.microsoft.azure.management.compute.OSProfile;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.Plan;
import com.microsoft.azure.management.compute.PowerState;
import com.microsoft.azure.management.compute.ProximityPlacementGroup;
import com.microsoft.azure.management.compute.ProximityPlacementGroupType;
import com.microsoft.azure.management.compute.PurchasePlan;
import com.microsoft.azure.management.compute.ResourceIdentityType;
import com.microsoft.azure.management.compute.RunCommandInput;
import com.microsoft.azure.management.compute.RunCommandInputParameter;
import com.microsoft.azure.management.compute.RunCommandResult;
import com.microsoft.azure.management.compute.SshConfiguration;
import com.microsoft.azure.management.compute.StorageAccountTypes;
import com.microsoft.azure.management.compute.StorageProfile;
import com.microsoft.azure.management.compute.VirtualHardDisk;
import com.microsoft.azure.management.compute.VirtualMachine;
import com.microsoft.azure.management.compute.VirtualMachineCaptureParameters;
import com.microsoft.azure.management.compute.VirtualMachineDataDisk;
import com.microsoft.azure.management.compute.VirtualMachineEncryption;
import com.microsoft.azure.management.compute.VirtualMachineEvictionPolicyTypes;
import com.microsoft.azure.management.compute.VirtualMachineExtension;
import com.microsoft.azure.management.compute.VirtualMachineInstanceView;
import com.microsoft.azure.management.compute.VirtualMachinePriorityTypes;
import com.microsoft.azure.management.compute.VirtualMachineSize;
import com.microsoft.azure.management.compute.VirtualMachineSizeTypes;
import com.microsoft.azure.management.compute.VirtualMachineUnmanagedDataDisk;
import com.microsoft.azure.management.compute.VirtualMachineUpdate;
import com.microsoft.azure.management.compute.WinRMConfiguration;
import com.microsoft.azure.management.compute.WinRMListener;
import com.microsoft.azure.management.compute.WindowsConfiguration;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.ProximityPlacementGroupImpl;
import com.microsoft.azure.management.compute.implementation.ProximityPlacementGroupInner;
import com.microsoft.azure.management.compute.implementation.SshPublicKeyInner;
import com.microsoft.azure.management.compute.implementation.UnmanagedDataDiskImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineCaptureResultInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineDataDiskImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineEncryptionImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineExtensionImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineExtensionsImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineInstanceViewImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineMsiHandler;
import com.microsoft.azure.management.compute.implementation.VirtualMachineSizeImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineSizeInner;
import com.microsoft.azure.management.graphrbac.BuiltInRole;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.graphrbac.implementation.RoleAssignmentHelper;
import com.microsoft.azure.management.msi.Identity;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.NetworkInterface;
import com.microsoft.azure.management.network.PublicIPAddress;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.resources.fluentcore.arm.AvailabilityZoneId;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.resources.fluentcore.utils.ResourceNamer;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.azure.management.resources.implementation.PageImpl;
import com.microsoft.azure.management.storage.StorageAccount;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import rx.Completable;
import rx.Observable;
import rx.functions.Func0;
import rx.functions.Func1;

@LangDefinition
class VirtualMachineImpl
extends GroupableResourceImpl<VirtualMachine, VirtualMachineInner, VirtualMachineImpl, ComputeManager>
implements VirtualMachine,
VirtualMachine.DefinitionManagedOrUnmanaged,
VirtualMachine.DefinitionManaged,
VirtualMachine.DefinitionUnmanaged,
VirtualMachine.Update,
VirtualMachine.DefinitionStages.WithSystemAssignedIdentityBasedAccessOrCreate,
VirtualMachine.UpdateStages.WithSystemAssignedIdentityBasedAccessOrUpdate {
    private final StorageManager storageManager;
    private final NetworkManager networkManager;
    private final String vmName;
    private final ResourceNamer namer;
    private String creatableStorageAccountKey;
    private String creatableAvailabilitySetKey;
    private String creatablePrimaryNetworkInterfaceKey;
    private List<String> creatableSecondaryNetworkInterfaceKeys;
    private StorageAccount existingStorageAccountToAssociate;
    private AvailabilitySet existingAvailabilitySetToAssociate;
    private NetworkInterface existingPrimaryNetworkInterfaceToAssociate;
    private List<NetworkInterface> existingSecondaryNetworkInterfacesToAssociate;
    private VirtualMachineInstanceView virtualMachineInstanceView;
    private boolean isMarketplaceLinuxImage;
    private NetworkInterface.DefinitionStages.WithPrimaryPrivateIP nicDefinitionWithPrivateIp;
    private NetworkInterface.DefinitionStages.WithPrimaryNetworkSubnet nicDefinitionWithSubnet;
    private NetworkInterface.DefinitionStages.WithCreate nicDefinitionWithCreate;
    private final PagedListConverter<VirtualMachineSizeInner, VirtualMachineSize> virtualMachineSizeConverter;
    private VirtualMachineExtensionsImpl virtualMachineExtensions;
    private boolean isUnmanagedDiskSelected;
    private List<VirtualMachineUnmanagedDataDisk> unmanagedDataDisks;
    private final ManagedDataDiskCollection managedDataDisks;
    private final BootDiagnosticsHandler bootDiagnosticsHandler;
    private VirtualMachineMsiHandler virtualMachineMsiHandler;
    private PublicIPAddress.DefinitionStages.WithCreate implicitPipCreatable;
    private String newProximityPlacementGroupName;
    private ProximityPlacementGroupType newProximityPlacementGroupType;
    private boolean removeOsProfile;

    VirtualMachineImpl(String name, VirtualMachineInner innerModel, ComputeManager computeManager, StorageManager storageManager, NetworkManager networkManager, GraphRbacManager rbacManager) {
        super(name, (Resource)innerModel, (ManagerBase)computeManager);
        this.storageManager = storageManager;
        this.networkManager = networkManager;
        this.vmName = name;
        this.isMarketplaceLinuxImage = false;
        this.namer = SdkContext.getResourceNamerFactory().createResourceNamer(this.vmName);
        this.creatableSecondaryNetworkInterfaceKeys = new ArrayList<String>();
        this.existingSecondaryNetworkInterfacesToAssociate = new ArrayList<NetworkInterface>();
        this.virtualMachineSizeConverter = new PagedListConverter<VirtualMachineSizeInner, VirtualMachineSize>(){

            public Observable<VirtualMachineSize> typeConvertAsync(VirtualMachineSizeInner inner) {
                return Observable.just((Object)new VirtualMachineSizeImpl(inner));
            }
        };
        this.virtualMachineExtensions = new VirtualMachineExtensionsImpl(((ComputeManagementClientImpl)((Object)computeManager.inner())).virtualMachineExtensions(), this);
        this.managedDataDisks = new ManagedDataDiskCollection(this);
        this.initializeDataDisks();
        this.bootDiagnosticsHandler = new BootDiagnosticsHandler(this);
        this.virtualMachineMsiHandler = new VirtualMachineMsiHandler(rbacManager, this);
        this.newProximityPlacementGroupName = null;
        this.newProximityPlacementGroupType = null;
    }

    public Observable<VirtualMachine> refreshAsync() {
        return super.refreshAsync().map((Func1)new Func1<VirtualMachine, VirtualMachine>(){

            public VirtualMachine call(VirtualMachine virtualMachine) {
                VirtualMachineImpl.this.reset((VirtualMachineInner)((Object)virtualMachine.inner()));
                VirtualMachineImpl.this.virtualMachineExtensions.refresh();
                return virtualMachine;
            }
        });
    }

    protected Observable<VirtualMachineInner> getInnerAsync() {
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).virtualMachines().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public void deallocate() {
        this.deallocateAsync().await();
    }

    @Override
    public Completable deallocateAsync() {
        Observable<Void> o = ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).virtualMachines().deallocateAsync(this.resourceGroupName(), this.name());
        Observable<VirtualMachine> r = this.refreshAsync();
        return Observable.concat(o, r).toCompletable();
    }

    @Override
    public ServiceFuture<Void> deallocateAsync(ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.deallocateAsync(), callback);
    }

    @Override
    public void generalize() {
        this.generalizeAsync().await();
    }

    @Override
    public Completable generalizeAsync() {
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).virtualMachines().generalizeAsync(this.resourceGroupName(), this.name()).toCompletable();
    }

    @Override
    public ServiceFuture<Void> generalizeAsync(ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.generalizeAsync(), callback);
    }

    @Override
    public void powerOff() {
        this.powerOffAsync().await();
    }

    @Override
    public Completable powerOffAsync() {
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).virtualMachines().powerOffAsync(this.resourceGroupName(), this.name()).toCompletable();
    }

    @Override
    public ServiceFuture<Void> powerOffAsync(ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.powerOffAsync(), callback);
    }

    @Override
    public void restart() {
        ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).virtualMachines().restart(this.resourceGroupName(), this.name());
    }

    @Override
    public Completable restartAsync() {
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).virtualMachines().restartAsync(this.resourceGroupName(), this.name()).toCompletable();
    }

    @Override
    public ServiceFuture<Void> restartAsync(ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.restartAsync(), callback);
    }

    @Override
    public void start() {
        this.startAsync().await();
    }

    @Override
    public Completable startAsync() {
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).virtualMachines().startAsync(this.resourceGroupName(), this.name()).toCompletable();
    }

    @Override
    public ServiceFuture<Void> startAsync(ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.startAsync(), callback);
    }

    @Override
    public void redeploy() {
        this.redeployAsync().await();
    }

    @Override
    public Completable redeployAsync() {
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).virtualMachines().redeployAsync(this.resourceGroupName(), this.name()).toCompletable();
    }

    @Override
    public ServiceFuture<Void> redeployAsync(ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.redeployAsync(), callback);
    }

    @Override
    public void simulateEviction() {
        this.simulateEvictionAsync().await();
    }

    @Override
    public Completable simulateEvictionAsync() {
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).virtualMachines().simulateEvictionAsync(this.resourceGroupName(), this.name()).toCompletable();
    }

    @Override
    public ServiceFuture<Void> simulateEvictionAsync(ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.simulateEvictionAsync(), callback);
    }

    @Override
    public void convertToManaged() {
        ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).virtualMachines().convertToManagedDisks(this.resourceGroupName(), this.name());
        this.refresh();
    }

    @Override
    public Completable convertToManagedAsync() {
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).virtualMachines().convertToManagedDisksAsync(this.resourceGroupName(), this.name()).flatMap(new Func1<Void, Observable<?>>(){

            public Observable<?> call(Void theVoid) {
                return VirtualMachineImpl.this.refreshAsync();
            }
        }).toCompletable();
    }

    @Override
    public ServiceFuture<Void> convertToManagedAsync(ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.convertToManagedAsync(), callback);
    }

    @Override
    public VirtualMachineEncryption diskEncryption() {
        return new VirtualMachineEncryptionImpl(this);
    }

    @Override
    public PagedList<VirtualMachineSize> availableSizes() {
        PageImpl page = new PageImpl();
        page.setItems(((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).virtualMachines().listAvailableSizes(this.resourceGroupName(), this.name()));
        page.setNextPageLink(null);
        return this.virtualMachineSizeConverter.convert((PagedList)new PagedList<VirtualMachineSizeInner>((Page)page){

            public Page<VirtualMachineSizeInner> nextPage(String nextPageLink) {
                return null;
            }
        });
    }

    @Override
    public String capture(String containerName, String vhdPrefix, boolean overwriteVhd) {
        return (String)this.captureAsync(containerName, vhdPrefix, overwriteVhd).toBlocking().last();
    }

    @Override
    public Observable<String> captureAsync(String containerName, String vhdPrefix, boolean overwriteVhd) {
        VirtualMachineCaptureParameters parameters = new VirtualMachineCaptureParameters();
        parameters.withDestinationContainerName(containerName);
        parameters.withOverwriteVhds(overwriteVhd);
        parameters.withVhdPrefix(vhdPrefix);
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).virtualMachines().captureAsync(this.resourceGroupName(), this.name(), parameters).map((Func1)new Func1<VirtualMachineCaptureResultInner, String>(){

            public String call(VirtualMachineCaptureResultInner innerResult) {
                if (innerResult == null) {
                    return null;
                }
                return new Gson().toJson((Object)innerResult);
            }
        });
    }

    @Override
    public ServiceFuture<String> captureAsync(String containerName, String vhdPrefix, boolean overwriteVhd, ServiceCallback<String> callback) {
        return ServiceFuture.fromBody(this.captureAsync(containerName, vhdPrefix, overwriteVhd), callback);
    }

    @Override
    public VirtualMachineInstanceView refreshInstanceView() {
        return (VirtualMachineInstanceView)this.refreshInstanceViewAsync().toBlocking().last();
    }

    @Override
    public Observable<VirtualMachineInstanceView> refreshInstanceViewAsync() {
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).virtualMachines().getByResourceGroupAsync(this.resourceGroupName(), this.name(), InstanceViewTypes.INSTANCE_VIEW).map((Func1)new Func1<VirtualMachineInner, VirtualMachineInstanceView>(){

            public VirtualMachineInstanceView call(VirtualMachineInner virtualMachineInner) {
                if (virtualMachineInner != null) {
                    VirtualMachineImpl.this.virtualMachineInstanceView = new VirtualMachineInstanceViewImpl(virtualMachineInner.instanceView());
                } else {
                    VirtualMachineImpl.this.virtualMachineInstanceView = null;
                }
                return VirtualMachineImpl.this.virtualMachineInstanceView;
            }
        });
    }

    @Override
    public RunCommandResult runPowerShellScript(String groupName, String name, List<String> scriptLines, List<RunCommandInputParameter> scriptParameters) {
        return ((ComputeManager)this.manager()).virtualMachines().runPowerShellScript(this.resourceGroupName(), this.name(), scriptLines, scriptParameters);
    }

    @Override
    public Observable<RunCommandResult> runPowerShellScriptAsync(List<String> scriptLines, List<RunCommandInputParameter> scriptParameters) {
        return ((ComputeManager)this.manager()).virtualMachines().runPowerShellScriptAsync(this.resourceGroupName(), this.name(), scriptLines, scriptParameters);
    }

    @Override
    public RunCommandResult runShellScript(List<String> scriptLines, List<RunCommandInputParameter> scriptParameters) {
        return ((ComputeManager)this.manager()).virtualMachines().runShellScript(this.resourceGroupName(), this.name(), scriptLines, scriptParameters);
    }

    @Override
    public Observable<RunCommandResult> runShellScriptAsync(List<String> scriptLines, List<RunCommandInputParameter> scriptParameters) {
        return ((ComputeManager)this.manager()).virtualMachines().runShellScriptAsync(this.resourceGroupName(), this.name(), scriptLines, scriptParameters);
    }

    @Override
    public RunCommandResult runCommand(RunCommandInput inputCommand) {
        return ((ComputeManager)this.manager()).virtualMachines().runCommand(this.resourceGroupName(), this.name(), inputCommand);
    }

    @Override
    public Observable<RunCommandResult> runCommandAsync(RunCommandInput inputCommand) {
        return ((ComputeManager)this.manager()).virtualMachines().runCommandAsync(this.resourceGroupName(), this.name(), inputCommand);
    }

    @Override
    public VirtualMachineImpl withNewPrimaryNetwork(Creatable<Network> creatable) {
        this.nicDefinitionWithPrivateIp = this.preparePrimaryNetworkInterface(this.namer.randomName("nic", 20)).withNewPrimaryNetwork(creatable);
        return this;
    }

    @Override
    public VirtualMachineImpl withNewPrimaryNetwork(String addressSpace) {
        this.nicDefinitionWithPrivateIp = this.preparePrimaryNetworkInterface(this.namer.randomName("nic", 20)).withNewPrimaryNetwork(addressSpace);
        return this;
    }

    @Override
    public VirtualMachineImpl withExistingPrimaryNetwork(Network network) {
        this.nicDefinitionWithSubnet = this.preparePrimaryNetworkInterface(this.namer.randomName("nic", 20)).withExistingPrimaryNetwork(network);
        return this;
    }

    @Override
    public VirtualMachineImpl withSubnet(String name) {
        this.nicDefinitionWithPrivateIp = this.nicDefinitionWithSubnet.withSubnet(name);
        return this;
    }

    @Override
    public VirtualMachineImpl withPrimaryPrivateIPAddressDynamic() {
        this.nicDefinitionWithCreate = this.nicDefinitionWithPrivateIp.withPrimaryPrivateIPAddressDynamic();
        return this;
    }

    @Override
    public VirtualMachineImpl withPrimaryPrivateIPAddressStatic(String staticPrivateIPAddress) {
        this.nicDefinitionWithCreate = this.nicDefinitionWithPrivateIp.withPrimaryPrivateIPAddressStatic(staticPrivateIPAddress);
        return this;
    }

    @Override
    public VirtualMachineImpl withNewPrimaryPublicIPAddress(Creatable<PublicIPAddress> creatable) {
        NetworkInterface.DefinitionStages.WithCreate nicCreatable = this.nicDefinitionWithCreate.withNewPrimaryPublicIPAddress(creatable);
        this.creatablePrimaryNetworkInterfaceKey = this.addDependency((Creatable)nicCreatable);
        return this;
    }

    @Override
    public VirtualMachineImpl withNewPrimaryPublicIPAddress(String leafDnsLabel) {
        PublicIPAddress.DefinitionStages.WithGroup definitionWithGroup = (PublicIPAddress.DefinitionStages.WithGroup)((PublicIPAddress.DefinitionStages.Blank)this.networkManager.publicIPAddresses().define(this.namer.randomName("pip", 15))).withRegion(this.regionName());
        PublicIPAddress.DefinitionStages.WithCreate definitionAfterGroup = this.creatableGroup != null ? (PublicIPAddress.DefinitionStages.WithCreate)definitionWithGroup.withNewResourceGroup(this.creatableGroup) : (PublicIPAddress.DefinitionStages.WithCreate)definitionWithGroup.withExistingResourceGroup(this.resourceGroupName());
        this.implicitPipCreatable = definitionAfterGroup.withLeafDomainLabel(leafDnsLabel);
        NetworkInterface.DefinitionStages.WithCreate nicCreatable = this.nicDefinitionWithCreate.withNewPrimaryPublicIPAddress((Creatable)this.implicitPipCreatable);
        this.creatablePrimaryNetworkInterfaceKey = this.addDependency((Creatable)nicCreatable);
        return this;
    }

    @Override
    public VirtualMachineImpl withExistingPrimaryPublicIPAddress(PublicIPAddress publicIPAddress) {
        NetworkInterface.DefinitionStages.WithCreate nicCreatable = this.nicDefinitionWithCreate.withExistingPrimaryPublicIPAddress(publicIPAddress);
        this.creatablePrimaryNetworkInterfaceKey = this.addDependency((Creatable)nicCreatable);
        return this;
    }

    @Override
    public VirtualMachineImpl withoutPrimaryPublicIPAddress() {
        NetworkInterface.DefinitionStages.WithCreate nicCreatable = this.nicDefinitionWithCreate;
        this.creatablePrimaryNetworkInterfaceKey = this.addDependency((Creatable)nicCreatable);
        return this;
    }

    @Override
    public VirtualMachineImpl withNewPrimaryNetworkInterface(Creatable<NetworkInterface> creatable) {
        this.creatablePrimaryNetworkInterfaceKey = this.addDependency(creatable);
        return this;
    }

    public VirtualMachineImpl withNewPrimaryNetworkInterface(String name, String publicDnsNameLabel) {
        NetworkInterface.DefinitionStages.WithCreate definitionCreatable = this.prepareNetworkInterface(name).withNewPrimaryPublicIPAddress(publicDnsNameLabel);
        return this.withNewPrimaryNetworkInterface((Creatable)definitionCreatable);
    }

    @Override
    public VirtualMachineImpl withExistingPrimaryNetworkInterface(NetworkInterface networkInterface) {
        this.existingPrimaryNetworkInterfaceToAssociate = networkInterface;
        return this;
    }

    @Override
    public VirtualMachineImpl withStoredWindowsImage(String imageUrl) {
        VirtualHardDisk userImageVhd = new VirtualHardDisk();
        userImageVhd.withUri(imageUrl);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withImage(userImageVhd);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withOsType(OperatingSystemTypes.WINDOWS);
        ((VirtualMachineInner)((Object)this.inner())).osProfile().withWindowsConfiguration(new WindowsConfiguration());
        ((VirtualMachineInner)((Object)this.inner())).osProfile().windowsConfiguration().withProvisionVMAgent(true);
        ((VirtualMachineInner)((Object)this.inner())).osProfile().windowsConfiguration().withEnableAutomaticUpdates(true);
        return this;
    }

    @Override
    public VirtualMachineImpl withStoredLinuxImage(String imageUrl) {
        VirtualHardDisk userImageVhd = new VirtualHardDisk();
        userImageVhd.withUri(imageUrl);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withImage(userImageVhd);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withOsType(OperatingSystemTypes.LINUX);
        ((VirtualMachineInner)((Object)this.inner())).osProfile().withLinuxConfiguration(new LinuxConfiguration());
        return this;
    }

    @Override
    public VirtualMachineImpl withPopularWindowsImage(KnownWindowsVirtualMachineImage knownImage) {
        return this.withSpecificWindowsImageVersion(knownImage.imageReference());
    }

    @Override
    public VirtualMachineImpl withPopularLinuxImage(KnownLinuxVirtualMachineImage knownImage) {
        return this.withSpecificLinuxImageVersion(knownImage.imageReference());
    }

    @Override
    public VirtualMachineImpl withSpecificWindowsImageVersion(ImageReference imageReference) {
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().withImageReference(imageReference);
        ((VirtualMachineInner)((Object)this.inner())).osProfile().withWindowsConfiguration(new WindowsConfiguration());
        ((VirtualMachineInner)((Object)this.inner())).osProfile().windowsConfiguration().withProvisionVMAgent(true);
        ((VirtualMachineInner)((Object)this.inner())).osProfile().windowsConfiguration().withEnableAutomaticUpdates(true);
        return this;
    }

    @Override
    public VirtualMachineImpl withSpecificLinuxImageVersion(ImageReference imageReference) {
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().withImageReference(imageReference);
        ((VirtualMachineInner)((Object)this.inner())).osProfile().withLinuxConfiguration(new LinuxConfiguration());
        this.isMarketplaceLinuxImage = true;
        return this;
    }

    @Override
    public VirtualMachineImpl withLatestWindowsImage(String publisher, String offer, String sku) {
        ImageReference imageReference = new ImageReference();
        imageReference.withPublisher(publisher);
        imageReference.withOffer(offer);
        imageReference.withSku(sku);
        imageReference.withVersion("latest");
        return this.withSpecificWindowsImageVersion(imageReference);
    }

    @Override
    public VirtualMachineImpl withLatestLinuxImage(String publisher, String offer, String sku) {
        ImageReference imageReference = new ImageReference();
        imageReference.withPublisher(publisher);
        imageReference.withOffer(offer);
        imageReference.withSku(sku);
        imageReference.withVersion("latest");
        return this.withSpecificLinuxImageVersion(imageReference);
    }

    @Override
    public VirtualMachineImpl withWindowsCustomImage(String customImageId) {
        ImageReference imageReferenceInner = new ImageReference();
        imageReferenceInner.withId(customImageId);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().withImageReference(imageReferenceInner);
        ((VirtualMachineInner)((Object)this.inner())).osProfile().withWindowsConfiguration(new WindowsConfiguration());
        ((VirtualMachineInner)((Object)this.inner())).osProfile().windowsConfiguration().withProvisionVMAgent(true);
        ((VirtualMachineInner)((Object)this.inner())).osProfile().windowsConfiguration().withEnableAutomaticUpdates(true);
        return this;
    }

    @Override
    public VirtualMachineImpl withSpecializedWindowsCustomImage(String customImageId) {
        this.withWindowsCustomImage(customImageId);
        this.removeOsProfile = true;
        return this;
    }

    @Override
    public VirtualMachineImpl withWindowsGalleryImageVersion(String galleryImageVersionId) {
        return this.withWindowsCustomImage(galleryImageVersionId);
    }

    @Override
    public VirtualMachineImpl withSpecializedWindowsGalleryImageVersion(String galleryImageVersionId) {
        this.withWindowsCustomImage(galleryImageVersionId);
        this.removeOsProfile = true;
        return this;
    }

    @Override
    public VirtualMachineImpl withLinuxCustomImage(String customImageId) {
        ImageReference imageReferenceInner = new ImageReference();
        imageReferenceInner.withId(customImageId);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().withImageReference(imageReferenceInner);
        ((VirtualMachineInner)((Object)this.inner())).osProfile().withLinuxConfiguration(new LinuxConfiguration());
        this.isMarketplaceLinuxImage = true;
        return this;
    }

    @Override
    public VirtualMachineImpl withSpecializedLinuxCustomImage(String customImageId) {
        this.withLinuxCustomImage(customImageId);
        this.removeOsProfile = true;
        return this;
    }

    @Override
    public VirtualMachineImpl withLinuxGalleryImageVersion(String galleryImageVersionId) {
        return this.withLinuxCustomImage(galleryImageVersionId);
    }

    @Override
    public VirtualMachineImpl withSpecializedLinuxGalleryImageVersion(String galleryImageVersionId) {
        this.withLinuxCustomImage(galleryImageVersionId);
        this.removeOsProfile = true;
        return this;
    }

    @Override
    public VirtualMachineImpl withSpecializedOSUnmanagedDisk(String osDiskUrl, OperatingSystemTypes osType) {
        VirtualHardDisk osVhd = new VirtualHardDisk();
        osVhd.withUri(osDiskUrl);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.ATTACH);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withVhd(osVhd);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withOsType(osType);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withManagedDisk(null);
        return this;
    }

    @Override
    public VirtualMachineImpl withSpecializedOSDisk(Disk disk, OperatingSystemTypes osType) {
        ManagedDiskParameters diskParametersInner = new ManagedDiskParameters();
        diskParametersInner.withId(disk.id());
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.ATTACH);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withManagedDisk(diskParametersInner);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withOsType(osType);
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withVhd(null);
        return this;
    }

    @Override
    public VirtualMachineImpl withRootUsername(String rootUserName) {
        ((VirtualMachineInner)((Object)this.inner())).osProfile().withAdminUsername(rootUserName);
        return this;
    }

    @Override
    public VirtualMachineImpl withAdminUsername(String adminUserName) {
        ((VirtualMachineInner)((Object)this.inner())).osProfile().withAdminUsername(adminUserName);
        return this;
    }

    @Override
    public VirtualMachineImpl withSsh(String publicKeyData) {
        OSProfile osProfile = ((VirtualMachineInner)((Object)this.inner())).osProfile();
        if (osProfile.linuxConfiguration().ssh() == null) {
            SshConfiguration sshConfiguration = new SshConfiguration();
            sshConfiguration.withPublicKeys(new ArrayList<SshPublicKeyInner>());
            osProfile.linuxConfiguration().withSsh(sshConfiguration);
        }
        SshPublicKeyInner sshPublicKey = new SshPublicKeyInner();
        sshPublicKey.withKeyData(publicKeyData);
        sshPublicKey.withPath("/home/" + osProfile.adminUsername() + "/.ssh/authorized_keys");
        osProfile.linuxConfiguration().ssh().publicKeys().add(sshPublicKey);
        return this;
    }

    @Override
    public VirtualMachineImpl withoutVMAgent() {
        ((VirtualMachineInner)((Object)this.inner())).osProfile().windowsConfiguration().withProvisionVMAgent(false);
        return this;
    }

    @Override
    public VirtualMachineImpl withoutAutoUpdate() {
        ((VirtualMachineInner)((Object)this.inner())).osProfile().windowsConfiguration().withEnableAutomaticUpdates(false);
        return this;
    }

    @Override
    public VirtualMachineImpl withTimeZone(String timeZone) {
        ((VirtualMachineInner)((Object)this.inner())).osProfile().windowsConfiguration().withTimeZone(timeZone);
        return this;
    }

    @Override
    public VirtualMachineImpl withWinRM(WinRMListener listener) {
        if (((VirtualMachineInner)((Object)this.inner())).osProfile().windowsConfiguration().winRM() == null) {
            WinRMConfiguration winRMConfiguration = new WinRMConfiguration();
            ((VirtualMachineInner)((Object)this.inner())).osProfile().windowsConfiguration().withWinRM(winRMConfiguration);
        }
        ((VirtualMachineInner)((Object)this.inner())).osProfile().windowsConfiguration().winRM().listeners().add(listener);
        return this;
    }

    @Override
    public VirtualMachineImpl withRootPassword(String password) {
        ((VirtualMachineInner)((Object)this.inner())).osProfile().withAdminPassword(password);
        return this;
    }

    @Override
    public VirtualMachineImpl withAdminPassword(String password) {
        ((VirtualMachineInner)((Object)this.inner())).osProfile().withAdminPassword(password);
        return this;
    }

    @Override
    public VirtualMachineImpl withCustomData(String base64EncodedCustomData) {
        ((VirtualMachineInner)((Object)this.inner())).osProfile().withCustomData(base64EncodedCustomData);
        return this;
    }

    @Override
    public VirtualMachineImpl withComputerName(String computerName) {
        ((VirtualMachineInner)((Object)this.inner())).osProfile().withComputerName(computerName);
        return this;
    }

    @Override
    public VirtualMachineImpl withSize(String sizeName) {
        ((VirtualMachineInner)((Object)this.inner())).hardwareProfile().withVmSize(VirtualMachineSizeTypes.fromString(sizeName));
        return this;
    }

    @Override
    public VirtualMachineImpl withSize(VirtualMachineSizeTypes size) {
        ((VirtualMachineInner)((Object)this.inner())).hardwareProfile().withVmSize(size);
        return this;
    }

    @Override
    public VirtualMachineImpl withOSDiskCaching(CachingTypes cachingType) {
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withCaching(cachingType);
        return this;
    }

    @Override
    public VirtualMachineImpl withOSDiskVhdLocation(String containerName, String vhdName) {
        if (this.isManagedDiskEnabled()) {
            return this;
        }
        StorageProfile storageProfile = ((VirtualMachineInner)((Object)this.inner())).storageProfile();
        OSDisk osDisk = storageProfile.osDisk();
        if (!this.isOSDiskFromImage(osDisk)) {
            return this;
        }
        if (this.isOsDiskFromCustomImage(storageProfile)) {
            return this;
        }
        if (this.isOSDiskFromPlatformImage(storageProfile)) {
            VirtualHardDisk osVhd = new VirtualHardDisk();
            osVhd.withUri(this.temporaryBlobUrl(containerName, vhdName));
            ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withVhd(osVhd);
            return this;
        }
        if (this.isOSDiskFromStoredImage(storageProfile)) {
            VirtualHardDisk osVhd = new VirtualHardDisk();
            try {
                URL sourceCustomImageUrl = new URL(osDisk.image().uri());
                URL destinationVhdUrl = new URL(sourceCustomImageUrl.getProtocol(), sourceCustomImageUrl.getHost(), "/" + containerName + "/" + vhdName);
                osVhd.withUri(destinationVhdUrl.toString());
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
            ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withVhd(osVhd);
        }
        return this;
    }

    @Override
    public VirtualMachineImpl withOSDiskStorageAccountType(StorageAccountTypes accountType) {
        if (((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().managedDisk() == null) {
            ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withManagedDisk(new ManagedDiskParameters());
        }
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().managedDisk().withStorageAccountType(accountType);
        return this;
    }

    @Override
    public VirtualMachineImpl withDataDiskDefaultCachingType(CachingTypes cachingType) {
        this.managedDataDisks.setDefaultCachingType(cachingType);
        return this;
    }

    @Override
    public VirtualMachineImpl withDataDiskDefaultStorageAccountType(StorageAccountTypes storageAccountType) {
        this.managedDataDisks.setDefaultStorageAccountType(storageAccountType);
        return this;
    }

    @Override
    public VirtualMachineImpl withOSDiskEncryptionSettings(DiskEncryptionSettings settings) {
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withEncryptionSettings(settings);
        return this;
    }

    @Override
    public VirtualMachineImpl withOSDiskSizeInGB(Integer size) {
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withDiskSizeGB(size);
        return this;
    }

    @Override
    public VirtualMachineImpl withOSDiskSizeInGB(int size) {
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withDiskSizeGB(size);
        return this;
    }

    @Override
    public VirtualMachineImpl withOSDiskName(String name) {
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().withName(name);
        return this;
    }

    public UnmanagedDataDiskImpl defineUnmanagedDataDisk(String name) {
        this.throwIfManagedDiskEnabled("This virtual machine is based on managed disk(s), both un-managed and managed disk cannot exists together in a virtual machine");
        return UnmanagedDataDiskImpl.prepareDataDisk(name, this);
    }

    @Override
    public VirtualMachineImpl withNewUnmanagedDataDisk(Integer sizeInGB) {
        this.throwIfManagedDiskEnabled("This virtual machine is based on managed disk(s), both un-managed and managed disk cannot exists together in a virtual machine");
        return this.defineUnmanagedDataDisk(null).withNewVhd(sizeInGB).attach();
    }

    @Override
    public VirtualMachineImpl withExistingUnmanagedDataDisk(String storageAccountName, String containerName, String vhdName) {
        this.throwIfManagedDiskEnabled("This virtual machine is based on managed disk(s), both un-managed and managed disk cannot exists together in a virtual machine");
        return this.defineUnmanagedDataDisk(null).withExistingVhd(storageAccountName, containerName, vhdName).attach();
    }

    @Override
    public VirtualMachineImpl withoutUnmanagedDataDisk(String name) {
        int idx = -1;
        for (VirtualMachineUnmanagedDataDisk dataDisk : this.unmanagedDataDisks) {
            ++idx;
            if (!dataDisk.name().equalsIgnoreCase(name)) continue;
            this.unmanagedDataDisks.remove(idx);
            ((VirtualMachineInner)((Object)this.inner())).storageProfile().dataDisks().remove(idx);
            break;
        }
        return this;
    }

    @Override
    public VirtualMachineImpl withoutUnmanagedDataDisk(int lun) {
        int idx = -1;
        for (VirtualMachineUnmanagedDataDisk dataDisk : this.unmanagedDataDisks) {
            ++idx;
            if (dataDisk.lun() != lun) continue;
            this.unmanagedDataDisks.remove(idx);
            ((VirtualMachineInner)((Object)this.inner())).storageProfile().dataDisks().remove(idx);
            break;
        }
        return this;
    }

    @Override
    public UnmanagedDataDiskImpl updateUnmanagedDataDisk(String name) {
        this.throwIfManagedDiskEnabled("This virtual machine is based on managed disk(s) and there is no un-managed disk to update");
        for (VirtualMachineUnmanagedDataDisk dataDisk : this.unmanagedDataDisks) {
            if (!dataDisk.name().equalsIgnoreCase(name)) continue;
            return (UnmanagedDataDiskImpl)dataDisk;
        }
        throw new RuntimeException("A data disk with name  '" + name + "' not found");
    }

    @Override
    public VirtualMachineImpl withNewDataDisk(Creatable<Disk> creatable) {
        this.throwIfManagedDiskDisabled("This virtual machine is based on un-managed disks (s), both un-managed and managed disk cannot exists together in a virtual machine");
        this.managedDataDisks.newDisksToAttach.put(this.addDependency(creatable), new DataDisk().withLun(-1));
        return this;
    }

    @Override
    public VirtualMachineImpl withNewDataDisk(Creatable<Disk> creatable, int lun, CachingTypes cachingType) {
        this.throwIfManagedDiskDisabled("This virtual machine is based on un-managed disks (s), both un-managed and managed disk cannot exists together in a virtual machine");
        this.managedDataDisks.newDisksToAttach.put(this.addDependency(creatable), new DataDisk().withLun(lun).withCaching(cachingType));
        return this;
    }

    @Override
    public VirtualMachineImpl withNewDataDisk(int sizeInGB) {
        this.throwIfManagedDiskDisabled("This virtual machine is based on un-managed disks (s), both un-managed and managed disk cannot exists together in a virtual machine");
        this.managedDataDisks.implicitDisksToAssociate.add(new DataDisk().withLun(-1).withDiskSizeGB(sizeInGB));
        return this;
    }

    @Override
    public VirtualMachineImpl withNewDataDisk(int sizeInGB, int lun, CachingTypes cachingType) {
        this.throwIfManagedDiskDisabled("This virtual machine is based on un-managed disks (s), both un-managed and managed disk cannot exists together in a virtual machine");
        this.managedDataDisks.implicitDisksToAssociate.add(new DataDisk().withLun(lun).withDiskSizeGB(sizeInGB).withCaching(cachingType));
        return this;
    }

    @Override
    public VirtualMachineImpl withNewDataDisk(int sizeInGB, int lun, CachingTypes cachingType, StorageAccountTypes storageAccountType) {
        this.throwIfManagedDiskDisabled("This virtual machine is based on un-managed disks (s), both un-managed and managed disk cannot exists together in a virtual machine");
        ManagedDiskParameters managedDiskParameters = new ManagedDiskParameters();
        managedDiskParameters.withStorageAccountType(storageAccountType);
        this.managedDataDisks.implicitDisksToAssociate.add(new DataDisk().withLun(lun).withDiskSizeGB(sizeInGB).withCaching(cachingType).withManagedDisk(managedDiskParameters));
        return this;
    }

    @Override
    public VirtualMachineImpl withExistingDataDisk(Disk disk) {
        this.throwIfManagedDiskDisabled("This virtual machine is based on un-managed disks (s), both un-managed and managed disk cannot exists together in a virtual machine");
        ManagedDiskParameters managedDiskParameters = new ManagedDiskParameters();
        managedDiskParameters.withId(disk.id());
        this.managedDataDisks.existingDisksToAttach.add(new DataDisk().withLun(-1).withManagedDisk(managedDiskParameters));
        return this;
    }

    @Override
    public VirtualMachineImpl withExistingDataDisk(Disk disk, int lun, CachingTypes cachingType) {
        this.throwIfManagedDiskDisabled("This virtual machine is based on un-managed disks (s), both un-managed and managed disk cannot exists together in a virtual machine");
        ManagedDiskParameters managedDiskParameters = new ManagedDiskParameters();
        managedDiskParameters.withId(disk.id());
        this.managedDataDisks.existingDisksToAttach.add(new DataDisk().withLun(lun).withManagedDisk(managedDiskParameters).withCaching(cachingType));
        return this;
    }

    @Override
    public VirtualMachineImpl withExistingDataDisk(Disk disk, int newSizeInGB, int lun, CachingTypes cachingType) {
        this.throwIfManagedDiskDisabled("This virtual machine is based on un-managed disks (s), both un-managed and managed disk cannot exists together in a virtual machine");
        ManagedDiskParameters managedDiskParameters = new ManagedDiskParameters();
        managedDiskParameters.withId(disk.id());
        this.managedDataDisks.existingDisksToAttach.add(new DataDisk().withLun(lun).withDiskSizeGB(newSizeInGB).withManagedDisk(managedDiskParameters).withCaching(cachingType));
        return this;
    }

    @Override
    public VirtualMachineImpl withNewDataDiskFromImage(int imageLun) {
        this.managedDataDisks.newDisksFromImage.add(new DataDisk().withLun(imageLun));
        return this;
    }

    @Override
    public VirtualMachineImpl withNewDataDiskFromImage(int imageLun, int newSizeInGB, CachingTypes cachingType) {
        this.managedDataDisks.newDisksFromImage.add(new DataDisk().withLun(imageLun).withDiskSizeGB(newSizeInGB).withCaching(cachingType));
        return this;
    }

    @Override
    public VirtualMachineImpl withNewDataDiskFromImage(int imageLun, int newSizeInGB, CachingTypes cachingType, StorageAccountTypes storageAccountType) {
        ManagedDiskParameters managedDiskParameters = new ManagedDiskParameters();
        managedDiskParameters.withStorageAccountType(storageAccountType);
        this.managedDataDisks.newDisksFromImage.add(new DataDisk().withLun(imageLun).withDiskSizeGB(newSizeInGB).withManagedDisk(managedDiskParameters).withCaching(cachingType));
        return this;
    }

    @Override
    public VirtualMachineImpl withoutDataDisk(int lun) {
        if (!this.isManagedDiskEnabled()) {
            return this;
        }
        this.managedDataDisks.diskLunsToRemove.add(lun);
        return this;
    }

    @Override
    public VirtualMachineImpl withNewStorageAccount(Creatable<StorageAccount> creatable) {
        if (this.creatableStorageAccountKey == null) {
            this.creatableStorageAccountKey = this.addDependency(creatable);
        }
        return this;
    }

    @Override
    public VirtualMachineImpl withNewStorageAccount(String name) {
        StorageAccount.DefinitionStages.WithGroup definitionWithGroup = (StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.storageManager.storageAccounts().define(name)).withRegion(this.regionName());
        Creatable definitionAfterGroup = this.creatableGroup != null ? (Creatable)definitionWithGroup.withNewResourceGroup(this.creatableGroup) : (Creatable)definitionWithGroup.withExistingResourceGroup(this.resourceGroupName());
        return this.withNewStorageAccount(definitionAfterGroup);
    }

    @Override
    public VirtualMachineImpl withExistingStorageAccount(StorageAccount storageAccount) {
        this.existingStorageAccountToAssociate = storageAccount;
        return this;
    }

    @Override
    public VirtualMachineImpl withNewAvailabilitySet(Creatable<AvailabilitySet> creatable) {
        if (this.creatableAvailabilitySetKey == null) {
            this.creatableAvailabilitySetKey = this.addDependency(creatable);
        }
        return this;
    }

    @Override
    public VirtualMachineImpl withProximityPlacementGroup(String proximityPlacementGroupId) {
        ((VirtualMachineInner)((Object)this.inner())).withProximityPlacementGroup(new SubResource().withId(proximityPlacementGroupId));
        this.newProximityPlacementGroupName = null;
        return this;
    }

    @Override
    public VirtualMachineImpl withNewProximityPlacementGroup(String proximityPlacementGroupName, ProximityPlacementGroupType type) {
        this.newProximityPlacementGroupName = proximityPlacementGroupName;
        this.newProximityPlacementGroupType = type;
        ((VirtualMachineInner)((Object)this.inner())).withProximityPlacementGroup(null);
        return this;
    }

    @Override
    public VirtualMachineImpl withoutProximityPlacementGroup() {
        ((VirtualMachineInner)((Object)this.inner())).withProximityPlacementGroup(null);
        return this;
    }

    @Override
    public VirtualMachineImpl withNewAvailabilitySet(String name) {
        AvailabilitySet.DefinitionStages.WithGroup definitionWithGroup = (AvailabilitySet.DefinitionStages.WithGroup)((AvailabilitySet.DefinitionStages.Blank)((ComputeManager)this.myManager).availabilitySets().define(name)).withRegion(this.regionName());
        AvailabilitySet.DefinitionStages.WithSku definitionWithSku = this.creatableGroup != null ? (AvailabilitySet.DefinitionStages.WithSku)definitionWithGroup.withNewResourceGroup(this.creatableGroup) : (AvailabilitySet.DefinitionStages.WithSku)definitionWithGroup.withExistingResourceGroup(this.resourceGroupName());
        AvailabilitySet.DefinitionStages.WithCreate creatable = this.isManagedDiskEnabled() ? definitionWithSku.withSku(AvailabilitySetSkuTypes.ALIGNED) : definitionWithSku.withSku(AvailabilitySetSkuTypes.CLASSIC);
        return this.withNewAvailabilitySet(creatable);
    }

    @Override
    public VirtualMachineImpl withExistingAvailabilitySet(AvailabilitySet availabilitySet) {
        this.existingAvailabilitySetToAssociate = availabilitySet;
        return this;
    }

    @Override
    public VirtualMachineImpl withNewSecondaryNetworkInterface(Creatable<NetworkInterface> creatable) {
        this.creatableSecondaryNetworkInterfaceKeys.add(this.addDependency(creatable));
        return this;
    }

    @Override
    public VirtualMachineImpl withExistingSecondaryNetworkInterface(NetworkInterface networkInterface) {
        this.existingSecondaryNetworkInterfacesToAssociate.add(networkInterface);
        return this;
    }

    public VirtualMachineExtensionImpl defineNewExtension(String name) {
        return this.virtualMachineExtensions.define(name);
    }

    @Override
    public VirtualMachineImpl withoutSecondaryNetworkInterface(String name) {
        if (((VirtualMachineInner)((Object)this.inner())).networkProfile() != null && ((VirtualMachineInner)((Object)this.inner())).networkProfile().networkInterfaces() != null) {
            int idx = -1;
            for (NetworkInterfaceReference nicReference : ((VirtualMachineInner)((Object)this.inner())).networkProfile().networkInterfaces()) {
                ++idx;
                if (nicReference.primary().booleanValue() || !name.equalsIgnoreCase(ResourceUtils.nameFromResourceId((String)nicReference.id()))) continue;
                ((VirtualMachineInner)((Object)this.inner())).networkProfile().networkInterfaces().remove(idx);
                break;
            }
        }
        return this;
    }

    @Override
    public VirtualMachineExtensionImpl updateExtension(String name) {
        return this.virtualMachineExtensions.update(name);
    }

    @Override
    public VirtualMachineImpl withoutExtension(String name) {
        this.virtualMachineExtensions.remove(name);
        return this;
    }

    @Override
    public VirtualMachineImpl withPlan(PurchasePlan plan) {
        ((VirtualMachineInner)((Object)this.inner())).withPlan(new Plan());
        ((VirtualMachineInner)((Object)this.inner())).plan().withPublisher(plan.publisher()).withProduct(plan.product()).withName(plan.name());
        return this;
    }

    @Override
    public VirtualMachineImpl withPromotionalPlan(PurchasePlan plan, String promotionCode) {
        this.withPlan(plan);
        ((VirtualMachineInner)((Object)this.inner())).plan().withPromotionCode(promotionCode);
        return this;
    }

    @Override
    public VirtualMachineImpl withUnmanagedDisks() {
        this.isUnmanagedDiskSelected = true;
        return this;
    }

    @Override
    public VirtualMachineImpl withBootDiagnostics() {
        this.bootDiagnosticsHandler.withBootDiagnostics();
        return this;
    }

    @Override
    public VirtualMachineImpl withBootDiagnostics(Creatable<StorageAccount> creatable) {
        this.bootDiagnosticsHandler.withBootDiagnostics(creatable);
        return this;
    }

    @Override
    public VirtualMachineImpl withBootDiagnostics(String storageAccountBlobEndpointUri) {
        this.bootDiagnosticsHandler.withBootDiagnostics(storageAccountBlobEndpointUri);
        return this;
    }

    @Override
    public VirtualMachineImpl withBootDiagnostics(StorageAccount storageAccount) {
        this.bootDiagnosticsHandler.withBootDiagnostics(storageAccount);
        return this;
    }

    @Override
    public VirtualMachineImpl withoutBootDiagnostics() {
        this.bootDiagnosticsHandler.withoutBootDiagnostics();
        return this;
    }

    @Override
    public VirtualMachineImpl withPriority(VirtualMachinePriorityTypes priority) {
        ((VirtualMachineInner)((Object)this.inner())).withPriority(priority);
        return this;
    }

    @Override
    public VirtualMachineImpl withLowPriority() {
        this.withPriority(VirtualMachinePriorityTypes.LOW);
        return this;
    }

    @Override
    public VirtualMachineImpl withLowPriority(VirtualMachineEvictionPolicyTypes policy) {
        this.withLowPriority();
        ((VirtualMachineInner)((Object)this.inner())).withEvictionPolicy(policy);
        return this;
    }

    @Override
    public VirtualMachineImpl withSpotPriority() {
        this.withPriority(VirtualMachinePriorityTypes.SPOT);
        return this;
    }

    @Override
    public VirtualMachineImpl withSpotPriority(VirtualMachineEvictionPolicyTypes policy) {
        this.withSpotPriority();
        ((VirtualMachineInner)((Object)this.inner())).withEvictionPolicy(policy);
        return this;
    }

    @Override
    public VirtualMachineImpl withMaxPrice(Double maxPrice) {
        ((VirtualMachineInner)((Object)this.inner())).withBillingProfile(new BillingProfile().withMaxPrice(maxPrice));
        return this;
    }

    @Override
    public VirtualMachineImpl withSystemAssignedManagedServiceIdentity() {
        this.virtualMachineMsiHandler.withLocalManagedServiceIdentity();
        return this;
    }

    @Override
    public VirtualMachineImpl withoutSystemAssignedManagedServiceIdentity() {
        this.virtualMachineMsiHandler.withoutLocalManagedServiceIdentity();
        return this;
    }

    @Override
    public VirtualMachineImpl withSystemAssignedIdentityBasedAccessTo(String resourceId, BuiltInRole role) {
        this.virtualMachineMsiHandler.withAccessTo(resourceId, role);
        return this;
    }

    @Override
    public VirtualMachineImpl withSystemAssignedIdentityBasedAccessToCurrentResourceGroup(BuiltInRole role) {
        this.virtualMachineMsiHandler.withAccessToCurrentResourceGroup(role);
        return this;
    }

    @Override
    public VirtualMachineImpl withSystemAssignedIdentityBasedAccessTo(String resourceId, String roleDefinitionId) {
        this.virtualMachineMsiHandler.withAccessTo(resourceId, roleDefinitionId);
        return this;
    }

    @Override
    public VirtualMachineImpl withSystemAssignedIdentityBasedAccessToCurrentResourceGroup(String roleDefinitionId) {
        this.virtualMachineMsiHandler.withAccessToCurrentResourceGroup(roleDefinitionId);
        return this;
    }

    @Override
    public VirtualMachineImpl withNewUserAssignedManagedServiceIdentity(Creatable<Identity> creatableIdentity) {
        this.virtualMachineMsiHandler.withNewExternalManagedServiceIdentity(creatableIdentity);
        return this;
    }

    @Override
    public VirtualMachineImpl withExistingUserAssignedManagedServiceIdentity(Identity identity) {
        this.virtualMachineMsiHandler.withExistingExternalManagedServiceIdentity(identity);
        return this;
    }

    @Override
    public VirtualMachineImpl withoutUserAssignedManagedServiceIdentity(String identityId) {
        this.virtualMachineMsiHandler.withoutExternalManagedServiceIdentity(identityId);
        return this;
    }

    @Override
    public VirtualMachineImpl withLicenseType(String licenseType) {
        ((VirtualMachineInner)((Object)this.inner())).withLicenseType(licenseType);
        return this;
    }

    @Override
    public boolean isManagedDiskEnabled() {
        if (this.isOsDiskFromCustomImage(((VirtualMachineInner)((Object)this.inner())).storageProfile())) {
            return true;
        }
        if (this.isOSDiskAttachedManaged(((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk())) {
            return true;
        }
        if (this.isOSDiskFromStoredImage(((VirtualMachineInner)((Object)this.inner())).storageProfile())) {
            return false;
        }
        if (this.isOSDiskAttachedUnmanaged(((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk())) {
            return false;
        }
        if (this.isOSDiskFromPlatformImage(((VirtualMachineInner)((Object)this.inner())).storageProfile()) && this.isUnmanagedDiskSelected) {
            return false;
        }
        if (this.isInCreateMode()) {
            return true;
        }
        return ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().vhd() == null;
    }

    @Override
    public String computerName() {
        if (((VirtualMachineInner)((Object)this.inner())).osProfile() == null) {
            return null;
        }
        return ((VirtualMachineInner)((Object)this.inner())).osProfile().computerName();
    }

    @Override
    public VirtualMachineSizeTypes size() {
        return ((VirtualMachineInner)((Object)this.inner())).hardwareProfile().vmSize();
    }

    @Override
    public OperatingSystemTypes osType() {
        if (((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().osType() != null) {
            return ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().osType();
        }
        if (((VirtualMachineInner)((Object)this.inner())).osProfile() != null) {
            if (((VirtualMachineInner)((Object)this.inner())).osProfile().linuxConfiguration() != null) {
                return OperatingSystemTypes.LINUX;
            }
            if (((VirtualMachineInner)((Object)this.inner())).osProfile().windowsConfiguration() != null) {
                return OperatingSystemTypes.WINDOWS;
            }
        }
        return null;
    }

    @Override
    public String osUnmanagedDiskVhdUri() {
        if (this.isManagedDiskEnabled()) {
            return null;
        }
        return ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().vhd().uri();
    }

    @Override
    public CachingTypes osDiskCachingType() {
        return ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().caching();
    }

    @Override
    public int osDiskSize() {
        return Utils.toPrimitiveInt((Integer)((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().diskSizeGB());
    }

    @Override
    public StorageAccountTypes osDiskStorageAccountType() {
        if (!this.isManagedDiskEnabled() || this.storageProfile().osDisk().managedDisk() == null) {
            return null;
        }
        return this.storageProfile().osDisk().managedDisk().storageAccountType();
    }

    @Override
    public String osDiskId() {
        if (!this.isManagedDiskEnabled()) {
            return null;
        }
        return this.storageProfile().osDisk().managedDisk().id();
    }

    @Override
    public Map<Integer, VirtualMachineUnmanagedDataDisk> unmanagedDataDisks() {
        HashMap<Integer, VirtualMachineUnmanagedDataDisk> dataDisks = new HashMap<Integer, VirtualMachineUnmanagedDataDisk>();
        if (!this.isManagedDiskEnabled()) {
            for (VirtualMachineUnmanagedDataDisk dataDisk : this.unmanagedDataDisks) {
                dataDisks.put(dataDisk.lun(), dataDisk);
            }
        }
        return Collections.unmodifiableMap(dataDisks);
    }

    @Override
    public Map<Integer, VirtualMachineDataDisk> dataDisks() {
        List<DataDisk> innerDataDisks;
        HashMap<Integer, VirtualMachineDataDiskImpl> dataDisks = new HashMap<Integer, VirtualMachineDataDiskImpl>();
        if (this.isManagedDiskEnabled() && (innerDataDisks = ((VirtualMachineInner)((Object)this.inner())).storageProfile().dataDisks()) != null) {
            for (DataDisk innerDataDisk : innerDataDisks) {
                dataDisks.put(innerDataDisk.lun(), new VirtualMachineDataDiskImpl(innerDataDisk));
            }
        }
        return Collections.unmodifiableMap(dataDisks);
    }

    public NetworkInterface getPrimaryNetworkInterface() {
        return (NetworkInterface)this.networkManager.networkInterfaces().getById(this.primaryNetworkInterfaceId());
    }

    @Override
    public PublicIPAddress getPrimaryPublicIPAddress() {
        return this.getPrimaryNetworkInterface().primaryIPConfiguration().getPublicIPAddress();
    }

    @Override
    public String getPrimaryPublicIPAddressId() {
        return this.getPrimaryNetworkInterface().primaryIPConfiguration().publicIPAddressId();
    }

    public List<String> networkInterfaceIds() {
        ArrayList<String> nicIds = new ArrayList<String>();
        for (NetworkInterfaceReference nicRef : ((VirtualMachineInner)((Object)this.inner())).networkProfile().networkInterfaces()) {
            nicIds.add(nicRef.id());
        }
        return nicIds;
    }

    public String primaryNetworkInterfaceId() {
        List<NetworkInterfaceReference> nicRefs = ((VirtualMachineInner)((Object)this.inner())).networkProfile().networkInterfaces();
        String primaryNicRefId = null;
        if (nicRefs.size() == 1) {
            primaryNicRefId = nicRefs.get(0).id();
        } else if (nicRefs.size() == 0) {
            primaryNicRefId = null;
        } else {
            for (NetworkInterfaceReference nicRef : ((VirtualMachineInner)((Object)this.inner())).networkProfile().networkInterfaces()) {
                if (nicRef.primary() == null || !nicRef.primary().booleanValue()) continue;
                primaryNicRefId = nicRef.id();
                break;
            }
            if (primaryNicRefId == null) {
                primaryNicRefId = nicRefs.get(0).id();
            }
        }
        return primaryNicRefId;
    }

    @Override
    public String availabilitySetId() {
        if (((VirtualMachineInner)((Object)this.inner())).availabilitySet() != null) {
            return ((VirtualMachineInner)((Object)this.inner())).availabilitySet().id();
        }
        return null;
    }

    @Override
    public String provisioningState() {
        return ((VirtualMachineInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public String licenseType() {
        return ((VirtualMachineInner)((Object)this.inner())).licenseType();
    }

    @Override
    public ProximityPlacementGroup proximityPlacementGroup() {
        ResourceId id = ResourceId.fromString((String)((VirtualMachineInner)((Object)this.inner())).proximityPlacementGroup().id());
        ProximityPlacementGroupInner plgInner = ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).proximityPlacementGroups().getByResourceGroup(id.resourceGroupName(), id.name());
        if (plgInner == null) {
            return null;
        }
        return new ProximityPlacementGroupImpl(plgInner);
    }

    @Override
    public Observable<VirtualMachineExtension> listExtensionsAsync() {
        return this.virtualMachineExtensions.listAsync();
    }

    @Override
    public Map<String, VirtualMachineExtension> listExtensions() {
        return this.virtualMachineExtensions.asMap();
    }

    @Override
    public Plan plan() {
        return ((VirtualMachineInner)((Object)this.inner())).plan();
    }

    @Override
    public StorageProfile storageProfile() {
        return ((VirtualMachineInner)((Object)this.inner())).storageProfile();
    }

    @Override
    public OSProfile osProfile() {
        return ((VirtualMachineInner)((Object)this.inner())).osProfile();
    }

    @Override
    public DiagnosticsProfile diagnosticsProfile() {
        return ((VirtualMachineInner)((Object)this.inner())).diagnosticsProfile();
    }

    @Override
    public String vmId() {
        return ((VirtualMachineInner)((Object)this.inner())).vmId();
    }

    @Override
    public VirtualMachineInstanceView instanceView() {
        if (this.virtualMachineInstanceView == null) {
            this.refreshInstanceView();
        }
        return this.virtualMachineInstanceView;
    }

    @Override
    public Set<AvailabilityZoneId> availabilityZones() {
        HashSet<AvailabilityZoneId> zones = new HashSet<AvailabilityZoneId>();
        if (((VirtualMachineInner)((Object)this.inner())).zones() != null) {
            for (String zone : ((VirtualMachineInner)((Object)this.inner())).zones()) {
                zones.add(AvailabilityZoneId.fromString((String)zone));
            }
        }
        return Collections.unmodifiableSet(zones);
    }

    @Override
    public PowerState powerState() {
        return PowerState.fromInstanceView(this.instanceView());
    }

    @Override
    public boolean isBootDiagnosticsEnabled() {
        return this.bootDiagnosticsHandler.isBootDiagnosticsEnabled();
    }

    @Override
    public String bootDiagnosticsStorageUri() {
        return this.bootDiagnosticsHandler.bootDiagnosticsStorageUri();
    }

    @Override
    public boolean isManagedServiceIdentityEnabled() {
        ResourceIdentityType type = this.managedServiceIdentityType();
        return type != null && !type.equals((Object)ResourceIdentityType.NONE);
    }

    @Override
    public String systemAssignedManagedServiceIdentityTenantId() {
        if (((VirtualMachineInner)((Object)this.inner())).identity() != null) {
            return ((VirtualMachineInner)((Object)this.inner())).identity().tenantId();
        }
        return null;
    }

    @Override
    public String systemAssignedManagedServiceIdentityPrincipalId() {
        if (((VirtualMachineInner)((Object)this.inner())).identity() != null) {
            return ((VirtualMachineInner)((Object)this.inner())).identity().principalId();
        }
        return null;
    }

    @Override
    public ResourceIdentityType managedServiceIdentityType() {
        if (((VirtualMachineInner)((Object)this.inner())).identity() != null) {
            return ((VirtualMachineInner)((Object)this.inner())).identity().type();
        }
        return null;
    }

    @Override
    public Set<String> userAssignedManagedServiceIdentityIds() {
        if (((VirtualMachineInner)((Object)this.inner())).identity() != null && ((VirtualMachineInner)((Object)this.inner())).identity().userAssignedIdentities() != null) {
            return Collections.unmodifiableSet(new HashSet<String>(((VirtualMachineInner)((Object)this.inner())).identity().userAssignedIdentities().keySet()));
        }
        return Collections.unmodifiableSet(new HashSet());
    }

    @Override
    public BillingProfile billingProfile() {
        return ((VirtualMachineInner)((Object)this.inner())).billingProfile();
    }

    @Override
    public VirtualMachinePriorityTypes priority() {
        return ((VirtualMachineInner)((Object)this.inner())).priority();
    }

    @Override
    public VirtualMachineEvictionPolicyTypes evictionPolicy() {
        return ((VirtualMachineInner)((Object)this.inner())).evictionPolicy();
    }

    public void beforeGroupCreateOrUpdate() {
        if (this.creatableStorageAccountKey == null && this.existingStorageAccountToAssociate == null && (this.osDiskRequiresImplicitStorageAccountCreation() || this.dataDisksRequiresImplicitStorageAccountCreation())) {
            Creatable storageAccountCreatable = null;
            storageAccountCreatable = this.creatableGroup != null ? (Creatable)((StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.storageManager.storageAccounts().define(this.namer.randomName("stg", 24).replace("-", ""))).withRegion(this.regionName())).withNewResourceGroup(this.creatableGroup) : (Creatable)((StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.storageManager.storageAccounts().define(this.namer.randomName("stg", 24).replace("-", ""))).withRegion(this.regionName())).withExistingResourceGroup(this.resourceGroupName());
            this.creatableStorageAccountKey = this.addDependency(storageAccountCreatable);
        }
        this.bootDiagnosticsHandler.prepare();
    }

    public Observable<VirtualMachine> createResourceAsync() {
        this.setOSDiskDefaults();
        this.setOSProfileDefaults();
        this.setHardwareProfileDefaults();
        if (this.isManagedDiskEnabled()) {
            this.managedDataDisks.setDataDisksDefaults();
        } else {
            UnmanagedDataDiskImpl.setDataDisksDefaults(this.unmanagedDataDisks, this.vmName);
        }
        this.handleUnManagedOSAndDataDisksStorageSettings();
        this.bootDiagnosticsHandler.handleDiagnosticsSettings();
        this.handleNetworkSettings();
        this.createNewProximityPlacementGroup();
        this.handleAvailabilitySettings();
        this.virtualMachineMsiHandler.processCreatedExternalIdentities();
        this.virtualMachineMsiHandler.handleExternalIdentities();
        final VirtualMachineImpl self = this;
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).virtualMachines().createOrUpdateAsync(this.resourceGroupName(), this.vmName, (VirtualMachineInner)((Object)this.inner())).map((Func1)new Func1<VirtualMachineInner, VirtualMachine>(){

            public VirtualMachine call(VirtualMachineInner virtualMachineInner) {
                VirtualMachineImpl.this.reset(virtualMachineInner);
                return self;
            }
        });
    }

    public Observable<VirtualMachine> updateResourceAsync() {
        if (this.isManagedDiskEnabled()) {
            this.managedDataDisks.setDataDisksDefaults();
        } else {
            UnmanagedDataDiskImpl.setDataDisksDefaults(this.unmanagedDataDisks, this.vmName);
        }
        this.handleUnManagedOSAndDataDisksStorageSettings();
        this.bootDiagnosticsHandler.handleDiagnosticsSettings();
        this.handleNetworkSettings();
        this.handleAvailabilitySettings();
        this.virtualMachineMsiHandler.processCreatedExternalIdentities();
        VirtualMachineUpdate updateParameter = new VirtualMachineUpdate();
        updateParameter.withPlan(((VirtualMachineInner)((Object)this.inner())).plan());
        updateParameter.withHardwareProfile(((VirtualMachineInner)((Object)this.inner())).hardwareProfile());
        updateParameter.withStorageProfile(((VirtualMachineInner)((Object)this.inner())).storageProfile());
        updateParameter.withOsProfile(((VirtualMachineInner)((Object)this.inner())).osProfile());
        updateParameter.withNetworkProfile(((VirtualMachineInner)((Object)this.inner())).networkProfile());
        updateParameter.withDiagnosticsProfile(((VirtualMachineInner)((Object)this.inner())).diagnosticsProfile());
        updateParameter.withBillingProfile(((VirtualMachineInner)((Object)this.inner())).billingProfile());
        updateParameter.withAvailabilitySet(((VirtualMachineInner)((Object)this.inner())).availabilitySet());
        updateParameter.withLicenseType(((VirtualMachineInner)((Object)this.inner())).licenseType());
        updateParameter.withZones(((VirtualMachineInner)((Object)this.inner())).zones());
        updateParameter.withTags(((VirtualMachineInner)((Object)this.inner())).getTags());
        updateParameter.withProximityPlacementGroup(((VirtualMachineInner)((Object)this.inner())).proximityPlacementGroup());
        updateParameter.withPriority(((VirtualMachineInner)((Object)this.inner())).priority());
        this.virtualMachineMsiHandler.handleExternalIdentities(updateParameter);
        final VirtualMachineImpl self = this;
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).virtualMachines().updateAsync(this.resourceGroupName(), this.vmName, updateParameter).map((Func1)new Func1<VirtualMachineInner, VirtualMachine>(){

            public VirtualMachine call(VirtualMachineInner virtualMachineInner) {
                VirtualMachineImpl.this.reset(virtualMachineInner);
                return self;
            }
        });
    }

    public Completable afterPostRunAsync(boolean isGroupFaulted) {
        this.virtualMachineExtensions.clear();
        if (isGroupFaulted) {
            return Completable.complete();
        }
        return this.refreshAsync().toCompletable();
    }

    VirtualMachineImpl withExtension(VirtualMachineExtensionImpl extension) {
        this.virtualMachineExtensions.addExtension(extension);
        return this;
    }

    private void reset(VirtualMachineInner inner) {
        this.setInner((Object)inner);
        this.clearCachedRelatedResources();
        this.initializeDataDisks();
        this.virtualMachineMsiHandler.clear();
    }

    VirtualMachineImpl withUnmanagedDataDisk(UnmanagedDataDiskImpl dataDisk) {
        ((VirtualMachineInner)((Object)this.inner())).storageProfile().dataDisks().add((DataDisk)dataDisk.inner());
        this.unmanagedDataDisks.add(dataDisk);
        return this;
    }

    @Override
    public VirtualMachineImpl withAvailabilityZone(AvailabilityZoneId zoneId) {
        if (this.isInCreateMode()) {
            if (((VirtualMachineInner)((Object)this.inner())).zones() == null) {
                ((VirtualMachineInner)((Object)this.inner())).withZones(new ArrayList<String>());
            }
            ((VirtualMachineInner)((Object)this.inner())).zones().add(zoneId.toString());
            if (this.implicitPipCreatable != null) {
                this.implicitPipCreatable.withAvailabilityZone(zoneId);
            }
        }
        return this;
    }

    AzureEnvironment environment() {
        RestClient restClient = ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).restClient();
        AzureEnvironment environment = null;
        if (restClient.credentials() instanceof AzureTokenCredentials) {
            environment = ((AzureTokenCredentials)restClient.credentials()).environment();
        }
        String baseUrl = restClient.retrofit().baseUrl().toString();
        for (AzureEnvironment env : AzureEnvironment.knownEnvironments()) {
            if (!env.resourceManagerEndpoint().toLowerCase().contains(baseUrl.toLowerCase())) continue;
            environment = env;
            break;
        }
        if (environment != null) {
            return environment;
        }
        throw new IllegalArgumentException("Unknown environment");
    }

    private void setOSDiskDefaults() {
        if (this.isInUpdateMode()) {
            return;
        }
        StorageProfile storageProfile = ((VirtualMachineInner)((Object)this.inner())).storageProfile();
        OSDisk osDisk = storageProfile.osDisk();
        if (this.isOSDiskFromImage(osDisk)) {
            if (this.isManagedDiskEnabled()) {
                if (osDisk.managedDisk() == null) {
                    osDisk.withManagedDisk(new ManagedDiskParameters());
                }
                if (osDisk.managedDisk().storageAccountType() == null) {
                    osDisk.managedDisk().withStorageAccountType(StorageAccountTypes.STANDARD_LRS);
                }
                osDisk.withVhd(null);
            } else {
                if (this.isOSDiskFromPlatformImage(storageProfile) || this.isOSDiskFromStoredImage(storageProfile)) {
                    if (osDisk.vhd() == null) {
                        String osDiskVhdContainerName = "vhds";
                        String osDiskVhdName = this.vmName + "-os-disk-" + UUID.randomUUID().toString() + ".vhd";
                        this.withOSDiskVhdLocation(osDiskVhdContainerName, osDiskVhdName);
                    }
                    osDisk.withManagedDisk(null);
                }
                if (osDisk.name() == null) {
                    this.withOSDiskName(this.vmName + "-os-disk");
                }
            }
        } else if (this.isManagedDiskEnabled()) {
            if (osDisk.managedDisk() != null) {
                osDisk.managedDisk().withStorageAccountType(null);
            }
            osDisk.withVhd(null);
        } else {
            osDisk.withManagedDisk(null);
            if (osDisk.name() == null) {
                this.withOSDiskName(this.vmName + "-os-disk");
            }
        }
        if (osDisk.caching() == null) {
            this.withOSDiskCaching(CachingTypes.READ_WRITE);
        }
    }

    private void setOSProfileDefaults() {
        if (this.isInUpdateMode()) {
            return;
        }
        StorageProfile storageProfile = ((VirtualMachineInner)((Object)this.inner())).storageProfile();
        OSDisk osDisk = storageProfile.osDisk();
        if (!this.removeOsProfile && this.isOSDiskFromImage(osDisk)) {
            if (osDisk.osType() == OperatingSystemTypes.LINUX || this.isMarketplaceLinuxImage) {
                OSProfile osProfile = ((VirtualMachineInner)((Object)this.inner())).osProfile();
                if (osProfile.linuxConfiguration() == null) {
                    osProfile.withLinuxConfiguration(new LinuxConfiguration());
                }
                ((VirtualMachineInner)((Object)this.inner())).osProfile().linuxConfiguration().withDisablePasswordAuthentication(osProfile.adminPassword() == null);
            }
            if (((VirtualMachineInner)((Object)this.inner())).osProfile().computerName() == null) {
                if (this.vmName.matches("[0-9]+")) {
                    ((VirtualMachineInner)((Object)this.inner())).osProfile().withComputerName(SdkContext.randomResourceName((String)"vm", (int)15));
                } else if (this.vmName.length() <= 15) {
                    ((VirtualMachineInner)((Object)this.inner())).osProfile().withComputerName(this.vmName);
                } else {
                    ((VirtualMachineInner)((Object)this.inner())).osProfile().withComputerName(SdkContext.randomResourceName((String)"vm", (int)15));
                }
            }
        } else {
            ((VirtualMachineInner)((Object)this.inner())).withOsProfile(null);
        }
    }

    private void setHardwareProfileDefaults() {
        if (!this.isInCreateMode()) {
            return;
        }
        HardwareProfile hardwareProfile = ((VirtualMachineInner)((Object)this.inner())).hardwareProfile();
        if (hardwareProfile.vmSize() == null) {
            hardwareProfile.withVmSize(VirtualMachineSizeTypes.BASIC_A0);
        }
    }

    private void handleUnManagedOSAndDataDisksStorageSettings() {
        if (this.isManagedDiskEnabled()) {
            return;
        }
        StorageAccount storageAccount = null;
        if (this.creatableStorageAccountKey != null) {
            storageAccount = (StorageAccount)this.taskResult(this.creatableStorageAccountKey);
        } else if (this.existingStorageAccountToAssociate != null) {
            storageAccount = this.existingStorageAccountToAssociate;
        }
        if (this.isInCreateMode()) {
            if (storageAccount != null) {
                if (this.isOSDiskFromPlatformImage(((VirtualMachineInner)((Object)this.inner())).storageProfile())) {
                    String uri = ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().vhd().uri().replaceFirst("\\{storage-base-url}", storageAccount.endPoints().primary().blob());
                    ((VirtualMachineInner)((Object)this.inner())).storageProfile().osDisk().vhd().withUri(uri);
                }
                UnmanagedDataDiskImpl.ensureDisksVhdUri(this.unmanagedDataDisks, storageAccount, this.vmName);
            }
        } else if (storageAccount != null) {
            UnmanagedDataDiskImpl.ensureDisksVhdUri(this.unmanagedDataDisks, storageAccount, this.vmName);
        } else {
            UnmanagedDataDiskImpl.ensureDisksVhdUri(this.unmanagedDataDisks, this.vmName);
        }
    }

    private void createNewProximityPlacementGroup() {
        if (this.isInCreateMode() && this.newProximityPlacementGroupName != null && !this.newProximityPlacementGroupName.isEmpty()) {
            ProximityPlacementGroupInner plgInner = new ProximityPlacementGroupInner();
            plgInner.withProximityPlacementGroupType(this.newProximityPlacementGroupType);
            plgInner.withLocation(((VirtualMachineInner)((Object)this.inner())).location());
            plgInner = ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).proximityPlacementGroups().createOrUpdate(this.resourceGroupName(), this.newProximityPlacementGroupName, plgInner);
            ((VirtualMachineInner)((Object)this.inner())).withProximityPlacementGroup(new SubResource().withId(plgInner.id()));
        }
    }

    private void handleNetworkSettings() {
        if (this.isInCreateMode()) {
            NetworkInterface primaryNetworkInterface = null;
            if (this.creatablePrimaryNetworkInterfaceKey != null) {
                primaryNetworkInterface = (NetworkInterface)this.taskResult(this.creatablePrimaryNetworkInterfaceKey);
            } else if (this.existingPrimaryNetworkInterfaceToAssociate != null) {
                primaryNetworkInterface = this.existingPrimaryNetworkInterfaceToAssociate;
            }
            if (primaryNetworkInterface != null) {
                NetworkInterfaceReference nicReference = new NetworkInterfaceReference();
                nicReference.withPrimary(true);
                nicReference.withId(primaryNetworkInterface.id());
                ((VirtualMachineInner)((Object)this.inner())).networkProfile().networkInterfaces().add(nicReference);
            }
        }
        for (String creatableSecondaryNetworkInterfaceKey : this.creatableSecondaryNetworkInterfaceKeys) {
            NetworkInterface secondaryNetworkInterface = (NetworkInterface)this.taskResult(creatableSecondaryNetworkInterfaceKey);
            NetworkInterfaceReference nicReference = new NetworkInterfaceReference();
            nicReference.withPrimary(false);
            nicReference.withId(secondaryNetworkInterface.id());
            ((VirtualMachineInner)((Object)this.inner())).networkProfile().networkInterfaces().add(nicReference);
        }
        for (NetworkInterface secondaryNetworkInterface : this.existingSecondaryNetworkInterfacesToAssociate) {
            NetworkInterfaceReference nicReference = new NetworkInterfaceReference();
            nicReference.withPrimary(false);
            nicReference.withId(secondaryNetworkInterface.id());
            ((VirtualMachineInner)((Object)this.inner())).networkProfile().networkInterfaces().add(nicReference);
        }
    }

    private void handleAvailabilitySettings() {
        if (!this.isInCreateMode()) {
            return;
        }
        AvailabilitySet availabilitySet = null;
        if (this.creatableAvailabilitySetKey != null) {
            availabilitySet = (AvailabilitySet)this.taskResult(this.creatableAvailabilitySetKey);
        } else if (this.existingAvailabilitySetToAssociate != null) {
            availabilitySet = this.existingAvailabilitySetToAssociate;
        }
        if (availabilitySet != null) {
            if (((VirtualMachineInner)((Object)this.inner())).availabilitySet() == null) {
                ((VirtualMachineInner)((Object)this.inner())).withAvailabilitySet(new SubResource());
            }
            ((VirtualMachineInner)((Object)this.inner())).availabilitySet().withId(availabilitySet.id());
        }
    }

    private boolean osDiskRequiresImplicitStorageAccountCreation() {
        if (this.isManagedDiskEnabled()) {
            return false;
        }
        if (this.creatableStorageAccountKey != null || this.existingStorageAccountToAssociate != null || !this.isInCreateMode()) {
            return false;
        }
        return this.isOSDiskFromPlatformImage(((VirtualMachineInner)((Object)this.inner())).storageProfile());
    }

    private boolean dataDisksRequiresImplicitStorageAccountCreation() {
        if (this.isManagedDiskEnabled()) {
            return false;
        }
        if (this.creatableStorageAccountKey != null || this.existingStorageAccountToAssociate != null || this.unmanagedDataDisks.size() == 0) {
            return false;
        }
        boolean hasEmptyVhd = false;
        for (VirtualMachineUnmanagedDataDisk dataDisk : this.unmanagedDataDisks) {
            if (dataDisk.creationMethod() != DiskCreateOptionTypes.EMPTY && dataDisk.creationMethod() != DiskCreateOptionTypes.FROM_IMAGE || ((DataDisk)dataDisk.inner()).vhd() != null) continue;
            hasEmptyVhd = true;
            break;
        }
        if (this.isInCreateMode()) {
            return hasEmptyVhd;
        }
        if (hasEmptyVhd) {
            for (VirtualMachineUnmanagedDataDisk dataDisk : this.unmanagedDataDisks) {
                if (dataDisk.creationMethod() != DiskCreateOptionTypes.ATTACH || ((DataDisk)dataDisk.inner()).vhd() == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isOSDiskAttachedUnmanaged(OSDisk osDisk) {
        return osDisk.createOption() == DiskCreateOptionTypes.ATTACH && osDisk.vhd() != null && osDisk.vhd().uri() != null;
    }

    private boolean isOSDiskAttachedManaged(OSDisk osDisk) {
        return osDisk.createOption() == DiskCreateOptionTypes.ATTACH && osDisk.managedDisk() != null && osDisk.managedDisk().id() != null;
    }

    private boolean isOSDiskFromImage(OSDisk osDisk) {
        return osDisk.createOption() == DiskCreateOptionTypes.FROM_IMAGE;
    }

    private boolean isOSDiskFromPlatformImage(StorageProfile storageProfile) {
        ImageReference imageReference = storageProfile.imageReference();
        return this.isOSDiskFromImage(storageProfile.osDisk()) && imageReference != null && imageReference.publisher() != null && imageReference.offer() != null && imageReference.sku() != null && imageReference.version() != null;
    }

    private boolean isOsDiskFromCustomImage(StorageProfile storageProfile) {
        ImageReference imageReference = storageProfile.imageReference();
        return this.isOSDiskFromImage(storageProfile.osDisk()) && imageReference != null && imageReference.id() != null;
    }

    private boolean isOSDiskFromStoredImage(StorageProfile storageProfile) {
        OSDisk osDisk = storageProfile.osDisk();
        return this.isOSDiskFromImage(osDisk) && osDisk.image() != null && osDisk.image().uri() != null;
    }

    private String temporaryBlobUrl(String containerName, String blobName) {
        return "{storage-base-url}" + containerName + "/" + blobName;
    }

    private NetworkInterface.DefinitionStages.WithPrimaryPublicIPAddress prepareNetworkInterface(String name) {
        NetworkInterface.DefinitionStages.WithGroup definitionWithGroup = (NetworkInterface.DefinitionStages.WithGroup)((NetworkInterface.DefinitionStages.Blank)this.networkManager.networkInterfaces().define(name)).withRegion(this.regionName());
        NetworkInterface.DefinitionStages.WithPrimaryNetwork definitionWithNetwork = this.creatableGroup != null ? (NetworkInterface.DefinitionStages.WithPrimaryNetwork)definitionWithGroup.withNewResourceGroup(this.creatableGroup) : (NetworkInterface.DefinitionStages.WithPrimaryNetwork)definitionWithGroup.withExistingResourceGroup(this.resourceGroupName());
        return definitionWithNetwork.withNewPrimaryNetwork("vnet" + name).withPrimaryPrivateIPAddressDynamic();
    }

    private void initializeDataDisks() {
        if (((VirtualMachineInner)((Object)this.inner())).storageProfile().dataDisks() == null) {
            ((VirtualMachineInner)((Object)this.inner())).storageProfile().withDataDisks(new ArrayList<DataDisk>());
        }
        this.isUnmanagedDiskSelected = false;
        this.managedDataDisks.clear();
        this.unmanagedDataDisks = new ArrayList<VirtualMachineUnmanagedDataDisk>();
        if (!this.isManagedDiskEnabled()) {
            for (DataDisk dataDiskInner : this.storageProfile().dataDisks()) {
                this.unmanagedDataDisks.add(new UnmanagedDataDiskImpl(dataDiskInner, this));
            }
        }
    }

    private NetworkInterface.DefinitionStages.WithPrimaryNetwork preparePrimaryNetworkInterface(String name) {
        NetworkInterface.DefinitionStages.WithGroup definitionWithGroup = (NetworkInterface.DefinitionStages.WithGroup)((NetworkInterface.DefinitionStages.Blank)this.networkManager.networkInterfaces().define(name)).withRegion(this.regionName());
        NetworkInterface.DefinitionStages.WithPrimaryNetwork definitionAfterGroup = this.creatableGroup != null ? (NetworkInterface.DefinitionStages.WithPrimaryNetwork)definitionWithGroup.withNewResourceGroup(this.creatableGroup) : (NetworkInterface.DefinitionStages.WithPrimaryNetwork)definitionWithGroup.withExistingResourceGroup(this.resourceGroupName());
        return definitionAfterGroup;
    }

    private void clearCachedRelatedResources() {
        this.virtualMachineInstanceView = null;
    }

    private void throwIfManagedDiskEnabled(String message) {
        if (this.isManagedDiskEnabled()) {
            throw new UnsupportedOperationException(message);
        }
    }

    private void throwIfManagedDiskDisabled(String message) {
        if (!this.isManagedDiskEnabled()) {
            throw new UnsupportedOperationException(message);
        }
    }

    private boolean isInUpdateMode() {
        return !this.isInCreateMode();
    }

    RoleAssignmentHelper.IdProvider idProvider() {
        return new RoleAssignmentHelper.IdProvider(){

            public String principalId() {
                if (VirtualMachineImpl.this.inner() != null && ((VirtualMachineInner)((Object)VirtualMachineImpl.this.inner())).identity() != null) {
                    return ((VirtualMachineInner)((Object)VirtualMachineImpl.this.inner())).identity().principalId();
                }
                return null;
            }

            public String resourceId() {
                if (VirtualMachineImpl.this.inner() != null) {
                    return ((VirtualMachineInner)((Object)VirtualMachineImpl.this.inner())).id();
                }
                return null;
            }
        };
    }

    private class BootDiagnosticsHandler {
        private final VirtualMachineImpl vmImpl;
        private String creatableDiagnosticsStorageAccountKey;

        BootDiagnosticsHandler(VirtualMachineImpl vmImpl) {
            this.vmImpl = vmImpl;
        }

        public boolean isBootDiagnosticsEnabled() {
            if (this.vmInner().diagnosticsProfile() != null && this.vmInner().diagnosticsProfile().bootDiagnostics() != null && this.vmInner().diagnosticsProfile().bootDiagnostics().enabled() != null) {
                return this.vmInner().diagnosticsProfile().bootDiagnostics().enabled();
            }
            return false;
        }

        public String bootDiagnosticsStorageUri() {
            if (this.vmInner().diagnosticsProfile() != null && this.vmInner().diagnosticsProfile().bootDiagnostics() != null) {
                return this.vmInner().diagnosticsProfile().bootDiagnostics().storageUri();
            }
            return null;
        }

        BootDiagnosticsHandler withBootDiagnostics() {
            this.enableDisable(true);
            return this;
        }

        BootDiagnosticsHandler withBootDiagnostics(Creatable<StorageAccount> creatable) {
            this.enableDisable(true);
            this.creatableDiagnosticsStorageAccountKey = this.vmImpl.addDependency(creatable);
            return this;
        }

        BootDiagnosticsHandler withBootDiagnostics(String storageAccountBlobEndpointUri) {
            this.enableDisable(true);
            this.vmInner().diagnosticsProfile().bootDiagnostics().withStorageUri(storageAccountBlobEndpointUri);
            return this;
        }

        BootDiagnosticsHandler withBootDiagnostics(StorageAccount storageAccount) {
            return this.withBootDiagnostics(storageAccount.endPoints().primary().blob());
        }

        BootDiagnosticsHandler withoutBootDiagnostics() {
            this.enableDisable(false);
            return this;
        }

        void prepare() {
            DiagnosticsProfile diagnosticsProfile = this.vmInner().diagnosticsProfile();
            if (diagnosticsProfile == null || diagnosticsProfile.bootDiagnostics() == null || diagnosticsProfile.bootDiagnostics().storageUri() != null) {
                return;
            }
            boolean enableBD = Utils.toPrimitiveBoolean((Boolean)diagnosticsProfile.bootDiagnostics().enabled());
            if (!enableBD) {
                return;
            }
            if (this.creatableDiagnosticsStorageAccountKey != null || this.vmImpl.creatableStorageAccountKey != null || this.vmImpl.existingStorageAccountToAssociate != null) {
                return;
            }
            String accountName = this.vmImpl.namer.randomName("stg", 24).replace("-", "");
            Creatable storageAccountCreatable = this.vmImpl.creatableGroup != null ? (Creatable)((StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.vmImpl.storageManager.storageAccounts().define(accountName)).withRegion(this.vmImpl.regionName())).withNewResourceGroup(this.vmImpl.creatableGroup) : (Creatable)((StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.vmImpl.storageManager.storageAccounts().define(accountName)).withRegion(this.vmImpl.regionName())).withExistingResourceGroup(this.vmImpl.resourceGroupName());
            this.creatableDiagnosticsStorageAccountKey = this.vmImpl.addDependency(storageAccountCreatable);
        }

        void handleDiagnosticsSettings() {
            DiagnosticsProfile diagnosticsProfile = this.vmInner().diagnosticsProfile();
            if (diagnosticsProfile == null || diagnosticsProfile.bootDiagnostics() == null || diagnosticsProfile.bootDiagnostics().storageUri() != null) {
                return;
            }
            boolean enableBD = Utils.toPrimitiveBoolean((Boolean)diagnosticsProfile.bootDiagnostics().enabled());
            if (!enableBD) {
                return;
            }
            StorageAccount storageAccount = null;
            if (this.creatableDiagnosticsStorageAccountKey != null) {
                storageAccount = (StorageAccount)this.vmImpl.taskResult(this.creatableDiagnosticsStorageAccountKey);
            } else if (this.vmImpl.creatableStorageAccountKey != null) {
                storageAccount = (StorageAccount)this.vmImpl.taskResult(this.vmImpl.creatableStorageAccountKey);
            } else if (this.vmImpl.existingStorageAccountToAssociate != null) {
                storageAccount = this.vmImpl.existingStorageAccountToAssociate;
            }
            if (storageAccount == null) {
                throw new IllegalStateException("Unable to retrieve expected storageAccount instance for BootDiagnostics");
            }
            this.vmInner().diagnosticsProfile().bootDiagnostics().withStorageUri(storageAccount.endPoints().primary().blob());
        }

        private VirtualMachineInner vmInner() {
            return (VirtualMachineInner)((Object)this.vmImpl.inner());
        }

        private void enableDisable(boolean enable) {
            if (this.vmInner().diagnosticsProfile() == null) {
                this.vmInner().withDiagnosticsProfile(new DiagnosticsProfile());
            }
            if (this.vmInner().diagnosticsProfile().bootDiagnostics() == null) {
                this.vmInner().diagnosticsProfile().withBootDiagnostics(new BootDiagnostics());
            }
            if (enable) {
                this.vmInner().diagnosticsProfile().bootDiagnostics().withEnabled(true);
            } else {
                this.vmInner().diagnosticsProfile().bootDiagnostics().withEnabled(false);
                this.vmInner().diagnosticsProfile().bootDiagnostics().withStorageUri(null);
            }
        }
    }

    private class ManagedDataDiskCollection {
        private final Map<String, DataDisk> newDisksToAttach = new HashMap<String, DataDisk>();
        private final List<DataDisk> existingDisksToAttach = new ArrayList<DataDisk>();
        private final List<DataDisk> implicitDisksToAssociate = new ArrayList<DataDisk>();
        private final List<Integer> diskLunsToRemove = new ArrayList<Integer>();
        private final List<DataDisk> newDisksFromImage = new ArrayList<DataDisk>();
        private final VirtualMachineImpl vm;
        private CachingTypes defaultCachingType;
        private StorageAccountTypes defaultStorageAccountType;

        ManagedDataDiskCollection(VirtualMachineImpl vm) {
            this.vm = vm;
        }

        void setDefaultCachingType(CachingTypes cachingType) {
            this.defaultCachingType = cachingType;
        }

        void setDefaultStorageAccountType(StorageAccountTypes defaultStorageAccountType) {
            this.defaultStorageAccountType = defaultStorageAccountType;
        }

        void setDataDisksDefaults() {
            VirtualMachineInner vmInner = (VirtualMachineInner)((Object)this.vm.inner());
            if (this.isPending()) {
                if (vmInner.storageProfile().dataDisks() == null) {
                    vmInner.storageProfile().withDataDisks(new ArrayList<DataDisk>());
                }
                List<DataDisk> dataDisks = vmInner.storageProfile().dataDisks();
                final ArrayList<Integer> usedLuns = new ArrayList<Integer>();
                for (DataDisk dataDisk : dataDisks) {
                    if (dataDisk.lun() == -1) continue;
                    usedLuns.add(dataDisk.lun());
                }
                for (DataDisk dataDisk : this.newDisksToAttach.values()) {
                    if (dataDisk.lun() == -1) continue;
                    usedLuns.add(dataDisk.lun());
                }
                for (DataDisk dataDisk : this.existingDisksToAttach) {
                    if (dataDisk.lun() == -1) continue;
                    usedLuns.add(dataDisk.lun());
                }
                for (DataDisk dataDisk : this.implicitDisksToAssociate) {
                    if (dataDisk.lun() == -1) continue;
                    usedLuns.add(dataDisk.lun());
                }
                for (DataDisk dataDisk : this.newDisksFromImage) {
                    if (dataDisk.lun() == -1) continue;
                    usedLuns.add(dataDisk.lun());
                }
                Func0<Integer> nextLun = new Func0<Integer>(){

                    public Integer call() {
                        Integer lun = 0;
                        while (usedLuns.contains(lun)) {
                            Integer n = lun;
                            Integer n2 = lun = Integer.valueOf(lun + 1);
                        }
                        usedLuns.add(lun);
                        return lun;
                    }
                };
                this.setAttachableNewDataDisks(nextLun);
                this.setAttachableExistingDataDisks(nextLun);
                this.setImplicitDataDisks(nextLun);
                this.setImageBasedDataDisks();
                this.removeDataDisks();
            }
            if (vmInner.storageProfile().dataDisks() != null && vmInner.storageProfile().dataDisks().size() == 0 && this.vm.isInCreateMode()) {
                vmInner.storageProfile().withDataDisks(null);
            }
            this.clear();
        }

        private void clear() {
            this.newDisksToAttach.clear();
            this.existingDisksToAttach.clear();
            this.implicitDisksToAssociate.clear();
            this.diskLunsToRemove.clear();
            this.newDisksFromImage.clear();
        }

        private boolean isPending() {
            return this.newDisksToAttach.size() > 0 || this.existingDisksToAttach.size() > 0 || this.implicitDisksToAssociate.size() > 0 || this.diskLunsToRemove.size() > 0 || this.newDisksFromImage.size() > 0;
        }

        private void setAttachableNewDataDisks(Func0<Integer> nextLun) {
            List<DataDisk> dataDisks = ((VirtualMachineInner)((Object)this.vm.inner())).storageProfile().dataDisks();
            for (Map.Entry<String, DataDisk> entry : this.newDisksToAttach.entrySet()) {
                Disk managedDisk = (Disk)this.vm.taskResult(entry.getKey());
                DataDisk dataDisk = entry.getValue();
                dataDisk.withCreateOption(DiskCreateOptionTypes.ATTACH);
                if (dataDisk.lun() == -1) {
                    dataDisk.withLun((Integer)nextLun.call());
                }
                dataDisk.withManagedDisk(new ManagedDiskParameters());
                dataDisk.managedDisk().withId(managedDisk.id());
                if (dataDisk.caching() == null) {
                    dataDisk.withCaching(this.getDefaultCachingType());
                }
                dataDisk.withName(null);
                dataDisks.add(dataDisk);
            }
        }

        private void setAttachableExistingDataDisks(Func0<Integer> nextLun) {
            List<DataDisk> dataDisks = ((VirtualMachineInner)((Object)this.vm.inner())).storageProfile().dataDisks();
            for (DataDisk dataDisk : this.existingDisksToAttach) {
                dataDisk.withCreateOption(DiskCreateOptionTypes.ATTACH);
                if (dataDisk.lun() == -1) {
                    dataDisk.withLun((Integer)nextLun.call());
                }
                if (dataDisk.caching() == null) {
                    dataDisk.withCaching(this.getDefaultCachingType());
                }
                dataDisk.withName(null);
                dataDisks.add(dataDisk);
            }
        }

        private void setImplicitDataDisks(Func0<Integer> nextLun) {
            List<DataDisk> dataDisks = ((VirtualMachineInner)((Object)this.vm.inner())).storageProfile().dataDisks();
            for (DataDisk dataDisk : this.implicitDisksToAssociate) {
                dataDisk.withCreateOption(DiskCreateOptionTypes.EMPTY);
                if (dataDisk.lun() == -1) {
                    dataDisk.withLun((Integer)nextLun.call());
                }
                if (dataDisk.caching() == null) {
                    dataDisk.withCaching(this.getDefaultCachingType());
                }
                if (dataDisk.managedDisk() == null) {
                    dataDisk.withManagedDisk(new ManagedDiskParameters());
                }
                if (dataDisk.managedDisk().storageAccountType() == null) {
                    dataDisk.managedDisk().withStorageAccountType(this.getDefaultStorageAccountType());
                }
                dataDisk.withName(null);
                dataDisks.add(dataDisk);
            }
        }

        private void setImageBasedDataDisks() {
            List<DataDisk> dataDisks = ((VirtualMachineInner)((Object)this.vm.inner())).storageProfile().dataDisks();
            for (DataDisk dataDisk : this.newDisksFromImage) {
                dataDisk.withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
                dataDisk.withName(null);
                dataDisks.add(dataDisk);
            }
        }

        private void removeDataDisks() {
            List<DataDisk> dataDisks = ((VirtualMachineInner)((Object)this.vm.inner())).storageProfile().dataDisks();
            block0: for (Integer lun : this.diskLunsToRemove) {
                int indexToRemove = 0;
                for (DataDisk dataDisk : dataDisks) {
                    if (dataDisk.lun() == lun.intValue()) {
                        dataDisks.remove(indexToRemove);
                        continue block0;
                    }
                    ++indexToRemove;
                }
            }
        }

        private CachingTypes getDefaultCachingType() {
            if (this.defaultCachingType == null) {
                return CachingTypes.READ_WRITE;
            }
            return this.defaultCachingType;
        }

        private StorageAccountTypes getDefaultStorageAccountType() {
            if (this.defaultStorageAccountType == null) {
                return StorageAccountTypes.STANDARD_LRS;
            }
            return this.defaultStorageAccountType;
        }
    }
}

