/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.DiskInstanceView;
import com.microsoft.azure.management.compute.DiskVolumeEncryptionMonitor;
import com.microsoft.azure.management.compute.EncryptionStatus;
import com.microsoft.azure.management.compute.InstanceViewStatus;
import com.microsoft.azure.management.compute.InstanceViewTypes;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.VirtualMachineExtensionInstanceView;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.EncryptionExtensionIdentifier;
import com.microsoft.azure.management.compute.implementation.LinuxEncryptionExtensionUtil;
import com.microsoft.azure.management.compute.implementation.VirtualMachineInner;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import java.util.HashMap;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class LinuxDiskVolumeNoAADEncryptionMonitorImpl
implements DiskVolumeEncryptionMonitor {
    private final String rgName;
    private final String vmName;
    private final ComputeManager computeManager;
    private VirtualMachineInner virtualMachine;
    private VirtualMachineExtensionInstanceView extensionInstanceView;

    LinuxDiskVolumeNoAADEncryptionMonitorImpl(String virtualMachineId, ComputeManager computeManager) {
        this.rgName = ResourceUtils.groupFromResourceId((String)virtualMachineId);
        this.vmName = ResourceUtils.nameFromResourceId((String)virtualMachineId);
        this.computeManager = computeManager;
    }

    @Override
    public OperatingSystemTypes osType() {
        return OperatingSystemTypes.LINUX;
    }

    @Override
    public String progressMessage() {
        if (!this.hasEncryptionExtensionInstanceView()) {
            return null;
        }
        return LinuxEncryptionExtensionUtil.progressMessage(this.extensionInstanceView);
    }

    @Override
    public EncryptionStatus osDiskStatus() {
        if (!this.hasEncryptionExtensionInstanceView()) {
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        return LinuxEncryptionExtensionUtil.osDiskStatus(this.extensionInstanceView);
    }

    @Override
    public EncryptionStatus dataDiskStatus() {
        if (!this.hasEncryptionExtensionInstanceView()) {
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        return LinuxEncryptionExtensionUtil.dataDiskStatus(this.extensionInstanceView);
    }

    @Override
    public Map<String, InstanceViewStatus> diskInstanceViewEncryptionStatuses() {
        if (this.virtualMachine.instanceView() == null || this.virtualMachine.instanceView().disks() == null) {
            return new HashMap<String, InstanceViewStatus>();
        }
        HashMap<String, InstanceViewStatus> div = new HashMap<String, InstanceViewStatus>();
        block0: for (DiskInstanceView diskInstanceView : this.virtualMachine.instanceView().disks()) {
            for (InstanceViewStatus status : diskInstanceView.statuses()) {
                if (LinuxDiskVolumeNoAADEncryptionMonitorImpl.encryptionStatusFromCode(status.code()) == null) continue;
                div.put(diskInstanceView.name(), status);
                continue block0;
            }
        }
        return div;
    }

    public DiskVolumeEncryptionMonitor refresh() {
        return (DiskVolumeEncryptionMonitor)this.refreshAsync().toBlocking().last();
    }

    @Override
    public Observable<DiskVolumeEncryptionMonitor> refreshAsync() {
        final LinuxDiskVolumeNoAADEncryptionMonitorImpl self = this;
        return this.retrieveVirtualMachineAsync().flatMap((Func1)new Func1<VirtualMachineInner, Observable<DiskVolumeEncryptionMonitor>>(){

            public Observable<DiskVolumeEncryptionMonitor> call(VirtualMachineInner virtualMachine) {
                self.virtualMachine = virtualMachine;
                if (virtualMachine.instanceView() != null && virtualMachine.instanceView().extensions() != null) {
                    for (VirtualMachineExtensionInstanceView eiv : virtualMachine.instanceView().extensions()) {
                        if (eiv.type() == null || !eiv.type().toLowerCase().startsWith(EncryptionExtensionIdentifier.publisherName().toLowerCase()) || eiv.name() == null || !EncryptionExtensionIdentifier.isEncryptionTypeName(eiv.name(), LinuxDiskVolumeNoAADEncryptionMonitorImpl.this.osType())) continue;
                        self.extensionInstanceView = eiv;
                        break;
                    }
                }
                return Observable.just((Object)self);
            }
        });
    }

    private Observable<VirtualMachineInner> retrieveVirtualMachineAsync() {
        return ((ComputeManagementClientImpl)((Object)this.computeManager.inner())).virtualMachines().getByResourceGroupAsync(this.rgName, this.vmName, InstanceViewTypes.INSTANCE_VIEW).flatMap((Func1)new Func1<VirtualMachineInner, Observable<VirtualMachineInner>>(){

            public Observable<VirtualMachineInner> call(VirtualMachineInner virtualMachine) {
                if (virtualMachine == null) {
                    return Observable.error((Throwable)new Exception(String.format("VM with name '%s' not found (resource group '%s')", LinuxDiskVolumeNoAADEncryptionMonitorImpl.this.vmName, LinuxDiskVolumeNoAADEncryptionMonitorImpl.this.rgName)));
                }
                return Observable.just((Object)((Object)virtualMachine));
            }
        });
    }

    private boolean hasEncryptionExtensionInstanceView() {
        return this.extensionInstanceView != null;
    }

    private static EncryptionStatus encryptionStatusFromCode(String code) {
        if (code != null && code.toLowerCase().startsWith("encryptionstate")) {
            String[] parts = code.split("/", 2);
            if (parts.length != 2) {
                return EncryptionStatus.UNKNOWN;
            }
            return EncryptionStatus.fromString(parts[1]);
        }
        return null;
    }
}

