/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.compute.DedicatedHostUpdate;
import com.microsoft.azure.management.compute.InstanceViewTypes;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.DedicatedHostInner;
import com.microsoft.azure.management.compute.implementation.PageImpl1;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class DedicatedHostsInner {
    private DedicatedHostsService service;
    private ComputeManagementClientImpl client;

    public DedicatedHostsInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = (DedicatedHostsService)retrofit.create(DedicatedHostsService.class);
        this.client = client;
    }

    public DedicatedHostInner createOrUpdate(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostInner parameters) {
        return (DedicatedHostInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<DedicatedHostInner> createOrUpdateAsync(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostInner parameters, ServiceCallback<DedicatedHostInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, parameters), serviceCallback);
    }

    public Observable<DedicatedHostInner> createOrUpdateAsync(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, parameters).map((Func1)new Func1<ServiceResponse<DedicatedHostInner>, DedicatedHostInner>(){

            public DedicatedHostInner call(ServiceResponse<DedicatedHostInner> response) {
                return (DedicatedHostInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DedicatedHostInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Parameter hostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-12-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, hostGroupName, hostName, this.client.subscriptionId(), parameters, "2019-12-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DedicatedHostInner>(){}.getType());
    }

    public DedicatedHostInner beginCreateOrUpdate(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostInner parameters) {
        return (DedicatedHostInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<DedicatedHostInner> beginCreateOrUpdateAsync(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostInner parameters, ServiceCallback<DedicatedHostInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, parameters), serviceCallback);
    }

    public Observable<DedicatedHostInner> beginCreateOrUpdateAsync(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, parameters).map((Func1)new Func1<ServiceResponse<DedicatedHostInner>, DedicatedHostInner>(){

            public DedicatedHostInner call(ServiceResponse<DedicatedHostInner> response) {
                return (DedicatedHostInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DedicatedHostInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Parameter hostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-12-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, hostGroupName, hostName, this.client.subscriptionId(), parameters, "2019-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DedicatedHostInner>>>(){

            public Observable<ServiceResponse<DedicatedHostInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DedicatedHostsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DedicatedHostInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DedicatedHostInner>(){}.getType()).register(201, new TypeToken<DedicatedHostInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DedicatedHostInner update(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostUpdate parameters) {
        return (DedicatedHostInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<DedicatedHostInner> updateAsync(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostUpdate parameters, ServiceCallback<DedicatedHostInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, parameters), serviceCallback);
    }

    public Observable<DedicatedHostInner> updateAsync(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostUpdate parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, parameters).map((Func1)new Func1<ServiceResponse<DedicatedHostInner>, DedicatedHostInner>(){

            public DedicatedHostInner call(ServiceResponse<DedicatedHostInner> response) {
                return (DedicatedHostInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DedicatedHostInner>> updateWithServiceResponseAsync(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostUpdate parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Parameter hostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2019-12-01";
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, hostGroupName, hostName, this.client.subscriptionId(), parameters, "2019-12-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DedicatedHostInner>(){}.getType());
    }

    public DedicatedHostInner beginUpdate(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostUpdate parameters) {
        return (DedicatedHostInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<DedicatedHostInner> beginUpdateAsync(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostUpdate parameters, ServiceCallback<DedicatedHostInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, parameters), serviceCallback);
    }

    public Observable<DedicatedHostInner> beginUpdateAsync(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostUpdate parameters) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, parameters).map((Func1)new Func1<ServiceResponse<DedicatedHostInner>, DedicatedHostInner>(){

            public DedicatedHostInner call(ServiceResponse<DedicatedHostInner> response) {
                return (DedicatedHostInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DedicatedHostInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostUpdate parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Parameter hostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2019-12-01";
        return this.service.beginUpdate(resourceGroupName, hostGroupName, hostName, this.client.subscriptionId(), parameters, "2019-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DedicatedHostInner>>>(){

            public Observable<ServiceResponse<DedicatedHostInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DedicatedHostsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DedicatedHostInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DedicatedHostInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String hostGroupName, String hostName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String hostGroupName, String hostName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String hostGroupName, String hostName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String hostGroupName, String hostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Parameter hostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-12-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, hostGroupName, hostName, this.client.subscriptionId(), "2019-12-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String hostGroupName, String hostName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String hostGroupName, String hostName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String hostGroupName, String hostName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String hostGroupName, String hostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Parameter hostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-12-01";
        return this.service.beginDelete(resourceGroupName, hostGroupName, hostName, this.client.subscriptionId(), "2019-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DedicatedHostsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DedicatedHostInner get(String resourceGroupName, String hostGroupName, String hostName) {
        return (DedicatedHostInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName).toBlocking().single()).body());
    }

    public ServiceFuture<DedicatedHostInner> getAsync(String resourceGroupName, String hostGroupName, String hostName, ServiceCallback<DedicatedHostInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName), serviceCallback);
    }

    public Observable<DedicatedHostInner> getAsync(String resourceGroupName, String hostGroupName, String hostName) {
        return this.getWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName).map((Func1)new Func1<ServiceResponse<DedicatedHostInner>, DedicatedHostInner>(){

            public DedicatedHostInner call(ServiceResponse<DedicatedHostInner> response) {
                return (DedicatedHostInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DedicatedHostInner>> getWithServiceResponseAsync(String resourceGroupName, String hostGroupName, String hostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Parameter hostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-12-01";
        InstanceViewTypes expand = null;
        return this.service.get(resourceGroupName, hostGroupName, hostName, this.client.subscriptionId(), expand, "2019-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DedicatedHostInner>>>(){

            public Observable<ServiceResponse<DedicatedHostInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DedicatedHostsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public DedicatedHostInner get(String resourceGroupName, String hostGroupName, String hostName, InstanceViewTypes expand) {
        return (DedicatedHostInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, expand).toBlocking().single()).body());
    }

    public ServiceFuture<DedicatedHostInner> getAsync(String resourceGroupName, String hostGroupName, String hostName, InstanceViewTypes expand, ServiceCallback<DedicatedHostInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, expand), serviceCallback);
    }

    public Observable<DedicatedHostInner> getAsync(String resourceGroupName, String hostGroupName, String hostName, InstanceViewTypes expand) {
        return this.getWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, expand).map((Func1)new Func1<ServiceResponse<DedicatedHostInner>, DedicatedHostInner>(){

            public DedicatedHostInner call(ServiceResponse<DedicatedHostInner> response) {
                return (DedicatedHostInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DedicatedHostInner>> getWithServiceResponseAsync(String resourceGroupName, String hostGroupName, String hostName, InstanceViewTypes expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Parameter hostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-12-01";
        return this.service.get(resourceGroupName, hostGroupName, hostName, this.client.subscriptionId(), expand, "2019-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DedicatedHostInner>>>(){

            public Observable<ServiceResponse<DedicatedHostInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DedicatedHostsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DedicatedHostInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DedicatedHostInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DedicatedHostInner> listByHostGroup(String resourceGroupName, String hostGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByHostGroupSinglePageAsync(resourceGroupName, hostGroupName).toBlocking().single();
        return new PagedList<DedicatedHostInner>((Page)response.body()){

            public Page<DedicatedHostInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DedicatedHostsInner.this.listByHostGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DedicatedHostInner>> listByHostGroupAsync(String resourceGroupName, String hostGroupName, ListOperationCallback<DedicatedHostInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByHostGroupSinglePageAsync(resourceGroupName, hostGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<DedicatedHostInner>>>>(){

            public Observable<ServiceResponse<Page<DedicatedHostInner>>> call(String nextPageLink) {
                return DedicatedHostsInner.this.listByHostGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DedicatedHostInner>> listByHostGroupAsync(String resourceGroupName, String hostGroupName) {
        return this.listByHostGroupWithServiceResponseAsync(resourceGroupName, hostGroupName).map((Func1)new Func1<ServiceResponse<Page<DedicatedHostInner>>, Page<DedicatedHostInner>>(){

            public Page<DedicatedHostInner> call(ServiceResponse<Page<DedicatedHostInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DedicatedHostInner>>> listByHostGroupWithServiceResponseAsync(String resourceGroupName, String hostGroupName) {
        return this.listByHostGroupSinglePageAsync(resourceGroupName, hostGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<DedicatedHostInner>>, Observable<ServiceResponse<Page<DedicatedHostInner>>>>(){

            public Observable<ServiceResponse<Page<DedicatedHostInner>>> call(ServiceResponse<Page<DedicatedHostInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DedicatedHostsInner.this.listByHostGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DedicatedHostInner>>> listByHostGroupSinglePageAsync(String resourceGroupName, String hostGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-12-01";
        return this.service.listByHostGroup(resourceGroupName, hostGroupName, this.client.subscriptionId(), "2019-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DedicatedHostInner>>>>(){

            public Observable<ServiceResponse<Page<DedicatedHostInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DedicatedHostsInner.this.listByHostGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<DedicatedHostInner>> listByHostGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<DedicatedHostInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DedicatedHostInner> listByHostGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByHostGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DedicatedHostInner>((Page)response.body()){

            public Page<DedicatedHostInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DedicatedHostsInner.this.listByHostGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DedicatedHostInner>> listByHostGroupNextAsync(String nextPageLink, ServiceFuture<List<DedicatedHostInner>> serviceFuture, ListOperationCallback<DedicatedHostInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByHostGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DedicatedHostInner>>>>(){

            public Observable<ServiceResponse<Page<DedicatedHostInner>>> call(String nextPageLink) {
                return DedicatedHostsInner.this.listByHostGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DedicatedHostInner>> listByHostGroupNextAsync(String nextPageLink) {
        return this.listByHostGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DedicatedHostInner>>, Page<DedicatedHostInner>>(){

            public Page<DedicatedHostInner> call(ServiceResponse<Page<DedicatedHostInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DedicatedHostInner>>> listByHostGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByHostGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DedicatedHostInner>>, Observable<ServiceResponse<Page<DedicatedHostInner>>>>(){

            public Observable<ServiceResponse<Page<DedicatedHostInner>>> call(ServiceResponse<Page<DedicatedHostInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DedicatedHostsInner.this.listByHostGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DedicatedHostInner>>> listByHostGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByHostGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DedicatedHostInner>>>>(){

            public Observable<ServiceResponse<Page<DedicatedHostInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DedicatedHostsInner.this.listByHostGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<DedicatedHostInner>> listByHostGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<DedicatedHostInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface DedicatedHostsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHosts createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}/hosts/{hostName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="hostGroupName") String var2, @Path(value="hostName") String var3, @Path(value="subscriptionId") String var4, @Body DedicatedHostInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHosts beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}/hosts/{hostName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="hostGroupName") String var2, @Path(value="hostName") String var3, @Path(value="subscriptionId") String var4, @Body DedicatedHostInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHosts update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}/hosts/{hostName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="hostGroupName") String var2, @Path(value="hostName") String var3, @Path(value="subscriptionId") String var4, @Body DedicatedHostUpdate var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHosts beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}/hosts/{hostName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="hostGroupName") String var2, @Path(value="hostName") String var3, @Path(value="subscriptionId") String var4, @Body DedicatedHostUpdate var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHosts delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}/hosts/{hostName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="hostGroupName") String var2, @Path(value="hostName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHosts beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}/hosts/{hostName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="hostGroupName") String var2, @Path(value="hostName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHosts get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}/hosts/{hostName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="hostGroupName") String var2, @Path(value="hostName") String var3, @Path(value="subscriptionId") String var4, @Query(value="$expand") InstanceViewTypes var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHosts listByHostGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}/hosts")
        public Observable<Response<ResponseBody>> listByHostGroup(@Path(value="resourceGroupName") String var1, @Path(value="hostGroupName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHosts listByHostGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByHostGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

