/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.compute.DedicatedHostGroupUpdate;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.DedicatedHostGroupInner;
import com.microsoft.azure.management.compute.implementation.PageImpl1;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class DedicatedHostGroupsInner
implements InnerSupportsGet<DedicatedHostGroupInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<DedicatedHostGroupInner> {
    private DedicatedHostGroupsService service;
    private ComputeManagementClientImpl client;

    public DedicatedHostGroupsInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = (DedicatedHostGroupsService)retrofit.create(DedicatedHostGroupsService.class);
        this.client = client;
    }

    public DedicatedHostGroupInner createOrUpdate(String resourceGroupName, String hostGroupName, DedicatedHostGroupInner parameters) {
        return (DedicatedHostGroupInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, hostGroupName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<DedicatedHostGroupInner> createOrUpdateAsync(String resourceGroupName, String hostGroupName, DedicatedHostGroupInner parameters, ServiceCallback<DedicatedHostGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, hostGroupName, parameters), serviceCallback);
    }

    public Observable<DedicatedHostGroupInner> createOrUpdateAsync(String resourceGroupName, String hostGroupName, DedicatedHostGroupInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, hostGroupName, parameters).map((Func1)new Func1<ServiceResponse<DedicatedHostGroupInner>, DedicatedHostGroupInner>(){

            public DedicatedHostGroupInner call(ServiceResponse<DedicatedHostGroupInner> response) {
                return (DedicatedHostGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DedicatedHostGroupInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String hostGroupName, DedicatedHostGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-12-01";
        return this.service.createOrUpdate(resourceGroupName, hostGroupName, this.client.subscriptionId(), parameters, "2019-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DedicatedHostGroupInner>>>(){

            public Observable<ServiceResponse<DedicatedHostGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DedicatedHostGroupsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DedicatedHostGroupInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DedicatedHostGroupInner>(){}.getType()).register(201, new TypeToken<DedicatedHostGroupInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DedicatedHostGroupInner update(String resourceGroupName, String hostGroupName, DedicatedHostGroupUpdate parameters) {
        return (DedicatedHostGroupInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, hostGroupName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<DedicatedHostGroupInner> updateAsync(String resourceGroupName, String hostGroupName, DedicatedHostGroupUpdate parameters, ServiceCallback<DedicatedHostGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, hostGroupName, parameters), serviceCallback);
    }

    public Observable<DedicatedHostGroupInner> updateAsync(String resourceGroupName, String hostGroupName, DedicatedHostGroupUpdate parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, hostGroupName, parameters).map((Func1)new Func1<ServiceResponse<DedicatedHostGroupInner>, DedicatedHostGroupInner>(){

            public DedicatedHostGroupInner call(ServiceResponse<DedicatedHostGroupInner> response) {
                return (DedicatedHostGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DedicatedHostGroupInner>> updateWithServiceResponseAsync(String resourceGroupName, String hostGroupName, DedicatedHostGroupUpdate parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2019-12-01";
        return this.service.update(resourceGroupName, hostGroupName, this.client.subscriptionId(), parameters, "2019-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DedicatedHostGroupInner>>>(){

            public Observable<ServiceResponse<DedicatedHostGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DedicatedHostGroupsInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DedicatedHostGroupInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DedicatedHostGroupInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String hostGroupName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, hostGroupName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String hostGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, hostGroupName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String hostGroupName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, hostGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String hostGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-12-01";
        return this.service.delete(resourceGroupName, hostGroupName, this.client.subscriptionId(), "2019-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DedicatedHostGroupsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DedicatedHostGroupInner getByResourceGroup(String resourceGroupName, String hostGroupName) {
        return (DedicatedHostGroupInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, hostGroupName).toBlocking().single()).body());
    }

    public ServiceFuture<DedicatedHostGroupInner> getByResourceGroupAsync(String resourceGroupName, String hostGroupName, ServiceCallback<DedicatedHostGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, hostGroupName), serviceCallback);
    }

    public Observable<DedicatedHostGroupInner> getByResourceGroupAsync(String resourceGroupName, String hostGroupName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, hostGroupName).map((Func1)new Func1<ServiceResponse<DedicatedHostGroupInner>, DedicatedHostGroupInner>(){

            public DedicatedHostGroupInner call(ServiceResponse<DedicatedHostGroupInner> response) {
                return (DedicatedHostGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DedicatedHostGroupInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String hostGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-12-01";
        return this.service.getByResourceGroup(resourceGroupName, hostGroupName, this.client.subscriptionId(), "2019-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DedicatedHostGroupInner>>>(){

            public Observable<ServiceResponse<DedicatedHostGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DedicatedHostGroupsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DedicatedHostGroupInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DedicatedHostGroupInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DedicatedHostGroupInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<DedicatedHostGroupInner>((Page)response.body()){

            public Page<DedicatedHostGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DedicatedHostGroupsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DedicatedHostGroupInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<DedicatedHostGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<DedicatedHostGroupInner>>>>(){

            public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> call(String nextPageLink) {
                return DedicatedHostGroupsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DedicatedHostGroupInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<DedicatedHostGroupInner>>, Page<DedicatedHostGroupInner>>(){

            public Page<DedicatedHostGroupInner> call(ServiceResponse<Page<DedicatedHostGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<DedicatedHostGroupInner>>, Observable<ServiceResponse<Page<DedicatedHostGroupInner>>>>(){

            public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> call(ServiceResponse<Page<DedicatedHostGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DedicatedHostGroupsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-12-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2019-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DedicatedHostGroupInner>>>>(){

            public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DedicatedHostGroupsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<DedicatedHostGroupInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<DedicatedHostGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DedicatedHostGroupInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<DedicatedHostGroupInner>((Page)response.body()){

            public Page<DedicatedHostGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DedicatedHostGroupsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DedicatedHostGroupInner>> listAsync(ListOperationCallback<DedicatedHostGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<DedicatedHostGroupInner>>>>(){

            public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> call(String nextPageLink) {
                return DedicatedHostGroupsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DedicatedHostGroupInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<DedicatedHostGroupInner>>, Page<DedicatedHostGroupInner>>(){

            public Page<DedicatedHostGroupInner> call(ServiceResponse<Page<DedicatedHostGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<DedicatedHostGroupInner>>, Observable<ServiceResponse<Page<DedicatedHostGroupInner>>>>(){

            public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> call(ServiceResponse<Page<DedicatedHostGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DedicatedHostGroupsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-12-01";
        return this.service.list(this.client.subscriptionId(), "2019-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DedicatedHostGroupInner>>>>(){

            public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DedicatedHostGroupsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<DedicatedHostGroupInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<DedicatedHostGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DedicatedHostGroupInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DedicatedHostGroupInner>((Page)response.body()){

            public Page<DedicatedHostGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DedicatedHostGroupsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DedicatedHostGroupInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<DedicatedHostGroupInner>> serviceFuture, ListOperationCallback<DedicatedHostGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DedicatedHostGroupInner>>>>(){

            public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> call(String nextPageLink) {
                return DedicatedHostGroupsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DedicatedHostGroupInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DedicatedHostGroupInner>>, Page<DedicatedHostGroupInner>>(){

            public Page<DedicatedHostGroupInner> call(ServiceResponse<Page<DedicatedHostGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DedicatedHostGroupInner>>, Observable<ServiceResponse<Page<DedicatedHostGroupInner>>>>(){

            public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> call(ServiceResponse<Page<DedicatedHostGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DedicatedHostGroupsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DedicatedHostGroupInner>>>>(){

            public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DedicatedHostGroupsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<DedicatedHostGroupInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<DedicatedHostGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DedicatedHostGroupInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DedicatedHostGroupInner>((Page)response.body()){

            public Page<DedicatedHostGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DedicatedHostGroupsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DedicatedHostGroupInner>> listNextAsync(String nextPageLink, ServiceFuture<List<DedicatedHostGroupInner>> serviceFuture, ListOperationCallback<DedicatedHostGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DedicatedHostGroupInner>>>>(){

            public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> call(String nextPageLink) {
                return DedicatedHostGroupsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DedicatedHostGroupInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DedicatedHostGroupInner>>, Page<DedicatedHostGroupInner>>(){

            public Page<DedicatedHostGroupInner> call(ServiceResponse<Page<DedicatedHostGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DedicatedHostGroupInner>>, Observable<ServiceResponse<Page<DedicatedHostGroupInner>>>>(){

            public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> call(ServiceResponse<Page<DedicatedHostGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DedicatedHostGroupsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DedicatedHostGroupInner>>>>(){

            public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DedicatedHostGroupsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<DedicatedHostGroupInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<DedicatedHostGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface DedicatedHostGroupsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHostGroups createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="hostGroupName") String var2, @Path(value="subscriptionId") String var3, @Body DedicatedHostGroupInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHostGroups update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="hostGroupName") String var2, @Path(value="subscriptionId") String var3, @Body DedicatedHostGroupUpdate var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHostGroups delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="hostGroupName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHostGroups getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="hostGroupName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHostGroups listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHostGroups list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/hostGroups")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHostGroups listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHostGroups listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

