/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute;

import com.microsoft.azure.management.compute.InstanceViewStatus;
import com.microsoft.azure.management.compute.VirtualMachineInstanceView;
import com.microsoft.azure.management.resources.fluentcore.arm.ExpandableStringEnum;
import java.util.Collection;

public final class PowerState
extends ExpandableStringEnum<PowerState> {
    public static final PowerState RUNNING = PowerState.fromString("PowerState/running");
    public static final PowerState DEALLOCATING = PowerState.fromString("PowerState/deallocating");
    public static final PowerState DEALLOCATED = PowerState.fromString("PowerState/deallocated");
    public static final PowerState STARTING = PowerState.fromString("PowerState/starting");
    public static final PowerState STOPPED = PowerState.fromString("PowerState/stopped");
    public static final PowerState STOPPING = PowerState.fromString("PowerState/stopping");
    public static final PowerState UNKNOWN = PowerState.fromString("PowerState/unknown");

    public static PowerState fromInstanceView(VirtualMachineInstanceView virtualMachineInstanceView) {
        if (virtualMachineInstanceView != null && virtualMachineInstanceView.statuses() != null) {
            for (InstanceViewStatus status : virtualMachineInstanceView.statuses()) {
                if (status.code() == null || !status.code().toLowerCase().startsWith("powerstate")) continue;
                return PowerState.fromString(status.code());
            }
        }
        return null;
    }

    public static Collection<PowerState> values() {
        return PowerState.values(PowerState.class);
    }

    public static PowerState fromString(String name) {
        return (PowerState)PowerState.fromString((String)name, PowerState.class);
    }
}

