/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cdn.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.cdn.AfdErrorResponseException;
import com.microsoft.azure.management.cdn.RuleUpdateParameters;
import com.microsoft.azure.management.cdn.implementation.CdnManagementClientImpl;
import com.microsoft.azure.management.cdn.implementation.PageImpl;
import com.microsoft.azure.management.cdn.implementation.RuleInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class RulesInner {
    private RulesService service;
    private CdnManagementClientImpl client;

    public RulesInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = (RulesService)retrofit.create(RulesService.class);
        this.client = client;
    }

    public PagedList<RuleInner> listByRuleSet(String resourceGroupName, String profileName, String ruleSetName) {
        ServiceResponse response = (ServiceResponse)this.listByRuleSetSinglePageAsync(resourceGroupName, profileName, ruleSetName).toBlocking().single();
        return new PagedList<RuleInner>((Page)response.body()){

            public Page<RuleInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RulesInner.this.listByRuleSetNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RuleInner>> listByRuleSetAsync(String resourceGroupName, String profileName, String ruleSetName, ListOperationCallback<RuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByRuleSetSinglePageAsync(resourceGroupName, profileName, ruleSetName), (Func1)new Func1<String, Observable<ServiceResponse<Page<RuleInner>>>>(){

            public Observable<ServiceResponse<Page<RuleInner>>> call(String nextPageLink) {
                return RulesInner.this.listByRuleSetNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RuleInner>> listByRuleSetAsync(String resourceGroupName, String profileName, String ruleSetName) {
        return this.listByRuleSetWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName).map((Func1)new Func1<ServiceResponse<Page<RuleInner>>, Page<RuleInner>>(){

            public Page<RuleInner> call(ServiceResponse<Page<RuleInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RuleInner>>> listByRuleSetWithServiceResponseAsync(String resourceGroupName, String profileName, String ruleSetName) {
        return this.listByRuleSetSinglePageAsync(resourceGroupName, profileName, ruleSetName).concatMap((Func1)new Func1<ServiceResponse<Page<RuleInner>>, Observable<ServiceResponse<Page<RuleInner>>>>(){

            public Observable<ServiceResponse<Page<RuleInner>>> call(ServiceResponse<Page<RuleInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RulesInner.this.listByRuleSetNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RuleInner>>> listByRuleSetSinglePageAsync(String resourceGroupName, String profileName, String ruleSetName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (ruleSetName == null) {
            throw new IllegalArgumentException("Parameter ruleSetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByRuleSet(resourceGroupName, profileName, ruleSetName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RuleInner>>>>(){

            public Observable<ServiceResponse<Page<RuleInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RulesInner.this.listByRuleSetDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RuleInner>> listByRuleSetDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RuleInner>>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public RuleInner get(String resourceGroupName, String profileName, String ruleSetName, String ruleName) {
        return (RuleInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName).toBlocking().single()).body());
    }

    public ServiceFuture<RuleInner> getAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, ServiceCallback<RuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName), serviceCallback);
    }

    public Observable<RuleInner> getAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName) {
        return this.getWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName).map((Func1)new Func1<ServiceResponse<RuleInner>, RuleInner>(){

            public RuleInner call(ServiceResponse<RuleInner> response) {
                return (RuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RuleInner>> getWithServiceResponseAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (ruleSetName == null) {
            throw new IllegalArgumentException("Parameter ruleSetName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, profileName, ruleSetName, ruleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RuleInner>>>(){

            public Observable<ServiceResponse<RuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RulesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RuleInner> getDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RuleInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public RuleInner create(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleInner rule) {
        return (RuleInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName, rule).toBlocking().last()).body());
    }

    public ServiceFuture<RuleInner> createAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleInner rule, ServiceCallback<RuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName, rule), serviceCallback);
    }

    public Observable<RuleInner> createAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleInner rule) {
        return this.createWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName, rule).map((Func1)new Func1<ServiceResponse<RuleInner>, RuleInner>(){

            public RuleInner call(ServiceResponse<RuleInner> response) {
                return (RuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RuleInner>> createWithServiceResponseAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleInner rule) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (ruleSetName == null) {
            throw new IllegalArgumentException("Parameter ruleSetName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (rule == null) {
            throw new IllegalArgumentException("Parameter rule is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)rule));
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, profileName, ruleSetName, ruleName, this.client.subscriptionId(), rule, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<RuleInner>(){}.getType());
    }

    public RuleInner beginCreate(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleInner rule) {
        return (RuleInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName, rule).toBlocking().single()).body());
    }

    public ServiceFuture<RuleInner> beginCreateAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleInner rule, ServiceCallback<RuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName, rule), serviceCallback);
    }

    public Observable<RuleInner> beginCreateAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleInner rule) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName, rule).map((Func1)new Func1<ServiceResponse<RuleInner>, RuleInner>(){

            public RuleInner call(ServiceResponse<RuleInner> response) {
                return (RuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RuleInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleInner rule) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (ruleSetName == null) {
            throw new IllegalArgumentException("Parameter ruleSetName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (rule == null) {
            throw new IllegalArgumentException("Parameter rule is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)rule));
        return this.service.beginCreate(resourceGroupName, profileName, ruleSetName, ruleName, this.client.subscriptionId(), rule, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RuleInner>>>(){

            public Observable<ServiceResponse<RuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RulesInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RuleInner> beginCreateDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RuleInner>(){}.getType()).register(201, new TypeToken<RuleInner>(){}.getType()).register(202, new TypeToken<RuleInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public RuleInner update(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleUpdateParameters ruleUpdateProperties) {
        return (RuleInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName, ruleUpdateProperties).toBlocking().last()).body());
    }

    public ServiceFuture<RuleInner> updateAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleUpdateParameters ruleUpdateProperties, ServiceCallback<RuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName, ruleUpdateProperties), serviceCallback);
    }

    public Observable<RuleInner> updateAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleUpdateParameters ruleUpdateProperties) {
        return this.updateWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName, ruleUpdateProperties).map((Func1)new Func1<ServiceResponse<RuleInner>, RuleInner>(){

            public RuleInner call(ServiceResponse<RuleInner> response) {
                return (RuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RuleInner>> updateWithServiceResponseAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleUpdateParameters ruleUpdateProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (ruleSetName == null) {
            throw new IllegalArgumentException("Parameter ruleSetName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (ruleUpdateProperties == null) {
            throw new IllegalArgumentException("Parameter ruleUpdateProperties is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)ruleUpdateProperties);
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, profileName, ruleSetName, ruleName, this.client.subscriptionId(), ruleUpdateProperties, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<RuleInner>(){}.getType());
    }

    public RuleInner beginUpdate(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleUpdateParameters ruleUpdateProperties) {
        return (RuleInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName, ruleUpdateProperties).toBlocking().single()).body());
    }

    public ServiceFuture<RuleInner> beginUpdateAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleUpdateParameters ruleUpdateProperties, ServiceCallback<RuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName, ruleUpdateProperties), serviceCallback);
    }

    public Observable<RuleInner> beginUpdateAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleUpdateParameters ruleUpdateProperties) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName, ruleUpdateProperties).map((Func1)new Func1<ServiceResponse<RuleInner>, RuleInner>(){

            public RuleInner call(ServiceResponse<RuleInner> response) {
                return (RuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RuleInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleUpdateParameters ruleUpdateProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (ruleSetName == null) {
            throw new IllegalArgumentException("Parameter ruleSetName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (ruleUpdateProperties == null) {
            throw new IllegalArgumentException("Parameter ruleUpdateProperties is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)ruleUpdateProperties);
        return this.service.beginUpdate(resourceGroupName, profileName, ruleSetName, ruleName, this.client.subscriptionId(), ruleUpdateProperties, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RuleInner>>>(){

            public Observable<ServiceResponse<RuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RulesInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RuleInner> beginUpdateDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RuleInner>(){}.getType()).register(202, new TypeToken<RuleInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public void delete(String resourceGroupName, String profileName, String ruleSetName, String ruleName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (ruleSetName == null) {
            throw new IllegalArgumentException("Parameter ruleSetName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, profileName, ruleSetName, ruleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String profileName, String ruleSetName, String ruleName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (ruleSetName == null) {
            throw new IllegalArgumentException("Parameter ruleSetName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, profileName, ruleSetName, ruleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RulesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public PagedList<RuleInner> listByRuleSetNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByRuleSetNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RuleInner>((Page)response.body()){

            public Page<RuleInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RulesInner.this.listByRuleSetNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RuleInner>> listByRuleSetNextAsync(String nextPageLink, ServiceFuture<List<RuleInner>> serviceFuture, ListOperationCallback<RuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByRuleSetNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RuleInner>>>>(){

            public Observable<ServiceResponse<Page<RuleInner>>> call(String nextPageLink) {
                return RulesInner.this.listByRuleSetNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RuleInner>> listByRuleSetNextAsync(String nextPageLink) {
        return this.listByRuleSetNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RuleInner>>, Page<RuleInner>>(){

            public Page<RuleInner> call(ServiceResponse<Page<RuleInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RuleInner>>> listByRuleSetNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByRuleSetNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RuleInner>>, Observable<ServiceResponse<Page<RuleInner>>>>(){

            public Observable<ServiceResponse<Page<RuleInner>>> call(ServiceResponse<Page<RuleInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RulesInner.this.listByRuleSetNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RuleInner>>> listByRuleSetNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByRuleSetNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RuleInner>>>>(){

            public Observable<ServiceResponse<Page<RuleInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RulesInner.this.listByRuleSetNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RuleInner>> listByRuleSetNextDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RuleInner>>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    static interface RulesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Rules listByRuleSet"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets/{ruleSetName}/rules")
        public Observable<Response<ResponseBody>> listByRuleSet(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="ruleSetName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Rules get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets/{ruleSetName}/rules/{ruleName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="ruleSetName") String var3, @Path(value="ruleName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Rules create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets/{ruleSetName}/rules/{ruleName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="ruleSetName") String var3, @Path(value="ruleName") String var4, @Path(value="subscriptionId") String var5, @Body RuleInner var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Rules beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets/{ruleSetName}/rules/{ruleName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="ruleSetName") String var3, @Path(value="ruleName") String var4, @Path(value="subscriptionId") String var5, @Body RuleInner var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Rules update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets/{ruleSetName}/rules/{ruleName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="ruleSetName") String var3, @Path(value="ruleName") String var4, @Path(value="subscriptionId") String var5, @Body RuleUpdateParameters var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Rules beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets/{ruleSetName}/rules/{ruleName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="ruleSetName") String var3, @Path(value="ruleName") String var4, @Path(value="subscriptionId") String var5, @Body RuleUpdateParameters var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Rules delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets/{ruleSetName}/rules/{ruleName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="ruleSetName") String var3, @Path(value="ruleName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Rules beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets/{ruleSetName}/rules/{ruleName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="ruleSetName") String var3, @Path(value="ruleName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Rules listByRuleSetNext"})
        @GET
        public Observable<Response<ResponseBody>> listByRuleSetNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

