/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cdn.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.cdn.AfdErrorResponseException;
import com.microsoft.azure.management.cdn.RouteUpdateParameters;
import com.microsoft.azure.management.cdn.implementation.CdnManagementClientImpl;
import com.microsoft.azure.management.cdn.implementation.PageImpl;
import com.microsoft.azure.management.cdn.implementation.RouteInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class RoutesInner {
    private RoutesService service;
    private CdnManagementClientImpl client;

    public RoutesInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = (RoutesService)retrofit.create(RoutesService.class);
        this.client = client;
    }

    public PagedList<RouteInner> listByEndpoint(String resourceGroupName, String profileName, String endpointName) {
        ServiceResponse response = (ServiceResponse)this.listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName).toBlocking().single();
        return new PagedList<RouteInner>((Page)response.body()){

            public Page<RouteInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RoutesInner.this.listByEndpointNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RouteInner>> listByEndpointAsync(String resourceGroupName, String profileName, String endpointName, ListOperationCallback<RouteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName), (Func1)new Func1<String, Observable<ServiceResponse<Page<RouteInner>>>>(){

            public Observable<ServiceResponse<Page<RouteInner>>> call(String nextPageLink) {
                return RoutesInner.this.listByEndpointNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RouteInner>> listByEndpointAsync(String resourceGroupName, String profileName, String endpointName) {
        return this.listByEndpointWithServiceResponseAsync(resourceGroupName, profileName, endpointName).map((Func1)new Func1<ServiceResponse<Page<RouteInner>>, Page<RouteInner>>(){

            public Page<RouteInner> call(ServiceResponse<Page<RouteInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RouteInner>>> listByEndpointWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName) {
        return this.listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName).concatMap((Func1)new Func1<ServiceResponse<Page<RouteInner>>, Observable<ServiceResponse<Page<RouteInner>>>>(){

            public Observable<ServiceResponse<Page<RouteInner>>> call(ServiceResponse<Page<RouteInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RoutesInner.this.listByEndpointNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RouteInner>>> listByEndpointSinglePageAsync(String resourceGroupName, String profileName, String endpointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByEndpoint(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RouteInner>>>>(){

            public Observable<ServiceResponse<Page<RouteInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RoutesInner.this.listByEndpointDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RouteInner>> listByEndpointDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RouteInner>>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public RouteInner get(String resourceGroupName, String profileName, String endpointName, String routeName) {
        return (RouteInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName).toBlocking().single()).body());
    }

    public ServiceFuture<RouteInner> getAsync(String resourceGroupName, String profileName, String endpointName, String routeName, ServiceCallback<RouteInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName), serviceCallback);
    }

    public Observable<RouteInner> getAsync(String resourceGroupName, String profileName, String endpointName, String routeName) {
        return this.getWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName).map((Func1)new Func1<ServiceResponse<RouteInner>, RouteInner>(){

            public RouteInner call(ServiceResponse<RouteInner> response) {
                return (RouteInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RouteInner>> getWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String routeName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (routeName == null) {
            throw new IllegalArgumentException("Parameter routeName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, profileName, endpointName, routeName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RouteInner>>>(){

            public Observable<ServiceResponse<RouteInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RoutesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RouteInner> getDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RouteInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public RouteInner create(String resourceGroupName, String profileName, String endpointName, String routeName, RouteInner route) {
        return (RouteInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName, route).toBlocking().last()).body());
    }

    public ServiceFuture<RouteInner> createAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteInner route, ServiceCallback<RouteInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName, route), serviceCallback);
    }

    public Observable<RouteInner> createAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteInner route) {
        return this.createWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName, route).map((Func1)new Func1<ServiceResponse<RouteInner>, RouteInner>(){

            public RouteInner call(ServiceResponse<RouteInner> response) {
                return (RouteInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RouteInner>> createWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteInner route) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (routeName == null) {
            throw new IllegalArgumentException("Parameter routeName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (route == null) {
            throw new IllegalArgumentException("Parameter route is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)route));
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, profileName, endpointName, routeName, this.client.subscriptionId(), route, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<RouteInner>(){}.getType());
    }

    public RouteInner beginCreate(String resourceGroupName, String profileName, String endpointName, String routeName, RouteInner route) {
        return (RouteInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName, route).toBlocking().single()).body());
    }

    public ServiceFuture<RouteInner> beginCreateAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteInner route, ServiceCallback<RouteInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName, route), serviceCallback);
    }

    public Observable<RouteInner> beginCreateAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteInner route) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName, route).map((Func1)new Func1<ServiceResponse<RouteInner>, RouteInner>(){

            public RouteInner call(ServiceResponse<RouteInner> response) {
                return (RouteInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RouteInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteInner route) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (routeName == null) {
            throw new IllegalArgumentException("Parameter routeName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (route == null) {
            throw new IllegalArgumentException("Parameter route is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)route));
        return this.service.beginCreate(resourceGroupName, profileName, endpointName, routeName, this.client.subscriptionId(), route, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RouteInner>>>(){

            public Observable<ServiceResponse<RouteInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RoutesInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RouteInner> beginCreateDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RouteInner>(){}.getType()).register(201, new TypeToken<RouteInner>(){}.getType()).register(202, new TypeToken<RouteInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public RouteInner update(String resourceGroupName, String profileName, String endpointName, String routeName, RouteUpdateParameters routeUpdateProperties) {
        return (RouteInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName, routeUpdateProperties).toBlocking().last()).body());
    }

    public ServiceFuture<RouteInner> updateAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteUpdateParameters routeUpdateProperties, ServiceCallback<RouteInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName, routeUpdateProperties), serviceCallback);
    }

    public Observable<RouteInner> updateAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteUpdateParameters routeUpdateProperties) {
        return this.updateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName, routeUpdateProperties).map((Func1)new Func1<ServiceResponse<RouteInner>, RouteInner>(){

            public RouteInner call(ServiceResponse<RouteInner> response) {
                return (RouteInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RouteInner>> updateWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteUpdateParameters routeUpdateProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (routeName == null) {
            throw new IllegalArgumentException("Parameter routeName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (routeUpdateProperties == null) {
            throw new IllegalArgumentException("Parameter routeUpdateProperties is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)routeUpdateProperties);
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, profileName, endpointName, routeName, this.client.subscriptionId(), routeUpdateProperties, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<RouteInner>(){}.getType());
    }

    public RouteInner beginUpdate(String resourceGroupName, String profileName, String endpointName, String routeName, RouteUpdateParameters routeUpdateProperties) {
        return (RouteInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName, routeUpdateProperties).toBlocking().single()).body());
    }

    public ServiceFuture<RouteInner> beginUpdateAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteUpdateParameters routeUpdateProperties, ServiceCallback<RouteInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName, routeUpdateProperties), serviceCallback);
    }

    public Observable<RouteInner> beginUpdateAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteUpdateParameters routeUpdateProperties) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName, routeUpdateProperties).map((Func1)new Func1<ServiceResponse<RouteInner>, RouteInner>(){

            public RouteInner call(ServiceResponse<RouteInner> response) {
                return (RouteInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RouteInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteUpdateParameters routeUpdateProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (routeName == null) {
            throw new IllegalArgumentException("Parameter routeName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (routeUpdateProperties == null) {
            throw new IllegalArgumentException("Parameter routeUpdateProperties is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)routeUpdateProperties);
        return this.service.beginUpdate(resourceGroupName, profileName, endpointName, routeName, this.client.subscriptionId(), routeUpdateProperties, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RouteInner>>>(){

            public Observable<ServiceResponse<RouteInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RoutesInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RouteInner> beginUpdateDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RouteInner>(){}.getType()).register(202, new TypeToken<RouteInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public void delete(String resourceGroupName, String profileName, String endpointName, String routeName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String profileName, String endpointName, String routeName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String profileName, String endpointName, String routeName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String routeName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (routeName == null) {
            throw new IllegalArgumentException("Parameter routeName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, profileName, endpointName, routeName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String profileName, String endpointName, String routeName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String profileName, String endpointName, String routeName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String profileName, String endpointName, String routeName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String routeName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (routeName == null) {
            throw new IllegalArgumentException("Parameter routeName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, profileName, endpointName, routeName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RoutesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public PagedList<RouteInner> listByEndpointNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByEndpointNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RouteInner>((Page)response.body()){

            public Page<RouteInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RoutesInner.this.listByEndpointNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RouteInner>> listByEndpointNextAsync(String nextPageLink, ServiceFuture<List<RouteInner>> serviceFuture, ListOperationCallback<RouteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByEndpointNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RouteInner>>>>(){

            public Observable<ServiceResponse<Page<RouteInner>>> call(String nextPageLink) {
                return RoutesInner.this.listByEndpointNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RouteInner>> listByEndpointNextAsync(String nextPageLink) {
        return this.listByEndpointNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RouteInner>>, Page<RouteInner>>(){

            public Page<RouteInner> call(ServiceResponse<Page<RouteInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RouteInner>>> listByEndpointNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByEndpointNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RouteInner>>, Observable<ServiceResponse<Page<RouteInner>>>>(){

            public Observable<ServiceResponse<Page<RouteInner>>> call(ServiceResponse<Page<RouteInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RoutesInner.this.listByEndpointNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RouteInner>>> listByEndpointNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByEndpointNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RouteInner>>>>(){

            public Observable<ServiceResponse<Page<RouteInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RoutesInner.this.listByEndpointNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RouteInner>> listByEndpointNextDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RouteInner>>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    static interface RoutesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Routes listByEndpoint"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}/routes")
        public Observable<Response<ResponseBody>> listByEndpoint(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Routes get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}/routes/{routeName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="routeName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Routes create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}/routes/{routeName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="routeName") String var4, @Path(value="subscriptionId") String var5, @Body RouteInner var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Routes beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}/routes/{routeName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="routeName") String var4, @Path(value="subscriptionId") String var5, @Body RouteInner var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Routes update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}/routes/{routeName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="routeName") String var4, @Path(value="subscriptionId") String var5, @Body RouteUpdateParameters var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Routes beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}/routes/{routeName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="routeName") String var4, @Path(value="subscriptionId") String var5, @Body RouteUpdateParameters var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Routes delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}/routes/{routeName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="routeName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Routes beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}/routes/{routeName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="routeName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Routes listByEndpointNext"})
        @GET
        public Observable<Response<ResponseBody>> listByEndpointNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

