/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cdn.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.cdn.ErrorResponseException;
import com.microsoft.azure.management.cdn.implementation.CdnManagementClientImpl;
import com.microsoft.azure.management.cdn.implementation.ManagedRuleSetDefinitionInner;
import com.microsoft.azure.management.cdn.implementation.PageImpl;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ManagedRuleSetsInner {
    private ManagedRuleSetsService service;
    private CdnManagementClientImpl client;

    public ManagedRuleSetsInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = (ManagedRuleSetsService)retrofit.create(ManagedRuleSetsService.class);
        this.client = client;
    }

    public PagedList<ManagedRuleSetDefinitionInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ManagedRuleSetDefinitionInner>((Page)response.body()){

            public Page<ManagedRuleSetDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedRuleSetsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagedRuleSetDefinitionInner>> listAsync(ListOperationCallback<ManagedRuleSetDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagedRuleSetDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedRuleSetDefinitionInner>>> call(String nextPageLink) {
                return ManagedRuleSetsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagedRuleSetDefinitionInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ManagedRuleSetDefinitionInner>>, Page<ManagedRuleSetDefinitionInner>>(){

            public Page<ManagedRuleSetDefinitionInner> call(ServiceResponse<Page<ManagedRuleSetDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedRuleSetDefinitionInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ManagedRuleSetDefinitionInner>>, Observable<ServiceResponse<Page<ManagedRuleSetDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedRuleSetDefinitionInner>>> call(ServiceResponse<Page<ManagedRuleSetDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedRuleSetsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedRuleSetDefinitionInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedRuleSetDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedRuleSetDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedRuleSetsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ManagedRuleSetDefinitionInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ManagedRuleSetDefinitionInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<ManagedRuleSetDefinitionInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ManagedRuleSetDefinitionInner>((Page)response.body()){

            public Page<ManagedRuleSetDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedRuleSetsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagedRuleSetDefinitionInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ManagedRuleSetDefinitionInner>> serviceFuture, ListOperationCallback<ManagedRuleSetDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagedRuleSetDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedRuleSetDefinitionInner>>> call(String nextPageLink) {
                return ManagedRuleSetsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagedRuleSetDefinitionInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ManagedRuleSetDefinitionInner>>, Page<ManagedRuleSetDefinitionInner>>(){

            public Page<ManagedRuleSetDefinitionInner> call(ServiceResponse<Page<ManagedRuleSetDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedRuleSetDefinitionInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ManagedRuleSetDefinitionInner>>, Observable<ServiceResponse<Page<ManagedRuleSetDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedRuleSetDefinitionInner>>> call(ServiceResponse<Page<ManagedRuleSetDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedRuleSetsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedRuleSetDefinitionInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedRuleSetDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedRuleSetDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedRuleSetsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ManagedRuleSetDefinitionInner>> listNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ManagedRuleSetDefinitionInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface ManagedRuleSetsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.ManagedRuleSets list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Cdn/CdnWebApplicationFirewallManagedRuleSets")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.ManagedRuleSets listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

