/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cdn.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.management.cdn.AfdErrorResponseException;
import com.microsoft.azure.management.cdn.LogMetric;
import com.microsoft.azure.management.cdn.LogMetricsGranularity;
import com.microsoft.azure.management.cdn.LogMetricsGroupBy;
import com.microsoft.azure.management.cdn.LogRanking;
import com.microsoft.azure.management.cdn.LogRankingMetric;
import com.microsoft.azure.management.cdn.WafAction;
import com.microsoft.azure.management.cdn.WafGranularity;
import com.microsoft.azure.management.cdn.WafMetric;
import com.microsoft.azure.management.cdn.WafRankingGroupBy;
import com.microsoft.azure.management.cdn.WafRankingType;
import com.microsoft.azure.management.cdn.WafRuleType;
import com.microsoft.azure.management.cdn.implementation.CdnManagementClientImpl;
import com.microsoft.azure.management.cdn.implementation.ContinentsResponseInner;
import com.microsoft.azure.management.cdn.implementation.MetricsResponseInner;
import com.microsoft.azure.management.cdn.implementation.RankingsResponseInner;
import com.microsoft.azure.management.cdn.implementation.ResourcesResponseInner;
import com.microsoft.azure.management.cdn.implementation.WafMetricsResponseInner;
import com.microsoft.azure.management.cdn.implementation.WafRankingsResponseInner;
import com.microsoft.rest.CollectionFormat;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import org.joda.time.DateTime;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class LogAnalyticsInner {
    private LogAnalyticsService service;
    private CdnManagementClientImpl client;

    public LogAnalyticsInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = (LogAnalyticsService)retrofit.create(LogAnalyticsService.class);
        this.client = client;
    }

    public MetricsResponseInner getLogAnalyticsMetrics(String resourceGroupName, String profileName, List<LogMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, LogMetricsGranularity granularity, List<String> customDomains, List<String> protocols) {
        return (MetricsResponseInner)((ServiceResponse)this.getLogAnalyticsMetricsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, customDomains, protocols).toBlocking().single()).body();
    }

    public ServiceFuture<MetricsResponseInner> getLogAnalyticsMetricsAsync(String resourceGroupName, String profileName, List<LogMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, LogMetricsGranularity granularity, List<String> customDomains, List<String> protocols, ServiceCallback<MetricsResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getLogAnalyticsMetricsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, customDomains, protocols), serviceCallback);
    }

    public Observable<MetricsResponseInner> getLogAnalyticsMetricsAsync(String resourceGroupName, String profileName, List<LogMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, LogMetricsGranularity granularity, List<String> customDomains, List<String> protocols) {
        return this.getLogAnalyticsMetricsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, customDomains, protocols).map((Func1)new Func1<ServiceResponse<MetricsResponseInner>, MetricsResponseInner>(){

            public MetricsResponseInner call(ServiceResponse<MetricsResponseInner> response) {
                return (MetricsResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<MetricsResponseInner>> getLogAnalyticsMetricsWithServiceResponseAsync(String resourceGroupName, String profileName, List<LogMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, LogMetricsGranularity granularity, List<String> customDomains, List<String> protocols) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (metrics == null) {
            throw new IllegalArgumentException("Parameter metrics is required and cannot be null.");
        }
        if (dateTimeBegin == null) {
            throw new IllegalArgumentException("Parameter dateTimeBegin is required and cannot be null.");
        }
        if (dateTimeEnd == null) {
            throw new IllegalArgumentException("Parameter dateTimeEnd is required and cannot be null.");
        }
        if (granularity == null) {
            throw new IllegalArgumentException("Parameter granularity is required and cannot be null.");
        }
        if (customDomains == null) {
            throw new IllegalArgumentException("Parameter customDomains is required and cannot be null.");
        }
        if (protocols == null) {
            throw new IllegalArgumentException("Parameter protocols is required and cannot be null.");
        }
        Validator.validate(metrics);
        Validator.validate(customDomains);
        Validator.validate(protocols);
        List groupBy = null;
        List continents = null;
        List countryOrRegions = null;
        String metricsConverted = this.client.serializerAdapter().serializeList(metrics, CollectionFormat.MULTI);
        String groupByConverted = this.client.serializerAdapter().serializeList(groupBy, CollectionFormat.MULTI);
        String continentsConverted = this.client.serializerAdapter().serializeList(continents, CollectionFormat.MULTI);
        String countryOrRegionsConverted = this.client.serializerAdapter().serializeList(countryOrRegions, CollectionFormat.MULTI);
        String customDomainsConverted = this.client.serializerAdapter().serializeList(customDomains, CollectionFormat.MULTI);
        String protocolsConverted = this.client.serializerAdapter().serializeList(protocols, CollectionFormat.MULTI);
        return this.service.getLogAnalyticsMetrics(this.client.subscriptionId(), resourceGroupName, profileName, this.client.apiVersion(), metricsConverted, dateTimeBegin, dateTimeEnd, granularity, groupByConverted, continentsConverted, countryOrRegionsConverted, customDomainsConverted, protocolsConverted, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<MetricsResponseInner>>>(){

            public Observable<ServiceResponse<MetricsResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LogAnalyticsInner.this.getLogAnalyticsMetricsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public MetricsResponseInner getLogAnalyticsMetrics(String resourceGroupName, String profileName, List<LogMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, LogMetricsGranularity granularity, List<String> customDomains, List<String> protocols, List<LogMetricsGroupBy> groupBy, List<String> continents, List<String> countryOrRegions) {
        return (MetricsResponseInner)((ServiceResponse)this.getLogAnalyticsMetricsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, customDomains, protocols, groupBy, continents, countryOrRegions).toBlocking().single()).body();
    }

    public ServiceFuture<MetricsResponseInner> getLogAnalyticsMetricsAsync(String resourceGroupName, String profileName, List<LogMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, LogMetricsGranularity granularity, List<String> customDomains, List<String> protocols, List<LogMetricsGroupBy> groupBy, List<String> continents, List<String> countryOrRegions, ServiceCallback<MetricsResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getLogAnalyticsMetricsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, customDomains, protocols, groupBy, continents, countryOrRegions), serviceCallback);
    }

    public Observable<MetricsResponseInner> getLogAnalyticsMetricsAsync(String resourceGroupName, String profileName, List<LogMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, LogMetricsGranularity granularity, List<String> customDomains, List<String> protocols, List<LogMetricsGroupBy> groupBy, List<String> continents, List<String> countryOrRegions) {
        return this.getLogAnalyticsMetricsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, customDomains, protocols, groupBy, continents, countryOrRegions).map((Func1)new Func1<ServiceResponse<MetricsResponseInner>, MetricsResponseInner>(){

            public MetricsResponseInner call(ServiceResponse<MetricsResponseInner> response) {
                return (MetricsResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<MetricsResponseInner>> getLogAnalyticsMetricsWithServiceResponseAsync(String resourceGroupName, String profileName, List<LogMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, LogMetricsGranularity granularity, List<String> customDomains, List<String> protocols, List<LogMetricsGroupBy> groupBy, List<String> continents, List<String> countryOrRegions) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (metrics == null) {
            throw new IllegalArgumentException("Parameter metrics is required and cannot be null.");
        }
        if (dateTimeBegin == null) {
            throw new IllegalArgumentException("Parameter dateTimeBegin is required and cannot be null.");
        }
        if (dateTimeEnd == null) {
            throw new IllegalArgumentException("Parameter dateTimeEnd is required and cannot be null.");
        }
        if (granularity == null) {
            throw new IllegalArgumentException("Parameter granularity is required and cannot be null.");
        }
        if (customDomains == null) {
            throw new IllegalArgumentException("Parameter customDomains is required and cannot be null.");
        }
        if (protocols == null) {
            throw new IllegalArgumentException("Parameter protocols is required and cannot be null.");
        }
        Validator.validate(metrics);
        Validator.validate(groupBy);
        Validator.validate(continents);
        Validator.validate(countryOrRegions);
        Validator.validate(customDomains);
        Validator.validate(protocols);
        String metricsConverted = this.client.serializerAdapter().serializeList(metrics, CollectionFormat.MULTI);
        String groupByConverted = this.client.serializerAdapter().serializeList(groupBy, CollectionFormat.MULTI);
        String continentsConverted = this.client.serializerAdapter().serializeList(continents, CollectionFormat.MULTI);
        String countryOrRegionsConverted = this.client.serializerAdapter().serializeList(countryOrRegions, CollectionFormat.MULTI);
        String customDomainsConverted = this.client.serializerAdapter().serializeList(customDomains, CollectionFormat.MULTI);
        String protocolsConverted = this.client.serializerAdapter().serializeList(protocols, CollectionFormat.MULTI);
        return this.service.getLogAnalyticsMetrics(this.client.subscriptionId(), resourceGroupName, profileName, this.client.apiVersion(), metricsConverted, dateTimeBegin, dateTimeEnd, granularity, groupByConverted, continentsConverted, countryOrRegionsConverted, customDomainsConverted, protocolsConverted, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<MetricsResponseInner>>>(){

            public Observable<ServiceResponse<MetricsResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LogAnalyticsInner.this.getLogAnalyticsMetricsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<MetricsResponseInner> getLogAnalyticsMetricsDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<MetricsResponseInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public RankingsResponseInner getLogAnalyticsRankings(String resourceGroupName, String profileName, List<LogRanking> rankings, List<LogRankingMetric> metrics, int maxRanking, DateTime dateTimeBegin, DateTime dateTimeEnd) {
        return (RankingsResponseInner)((ServiceResponse)this.getLogAnalyticsRankingsWithServiceResponseAsync(resourceGroupName, profileName, rankings, metrics, maxRanking, dateTimeBegin, dateTimeEnd).toBlocking().single()).body();
    }

    public ServiceFuture<RankingsResponseInner> getLogAnalyticsRankingsAsync(String resourceGroupName, String profileName, List<LogRanking> rankings, List<LogRankingMetric> metrics, int maxRanking, DateTime dateTimeBegin, DateTime dateTimeEnd, ServiceCallback<RankingsResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getLogAnalyticsRankingsWithServiceResponseAsync(resourceGroupName, profileName, rankings, metrics, maxRanking, dateTimeBegin, dateTimeEnd), serviceCallback);
    }

    public Observable<RankingsResponseInner> getLogAnalyticsRankingsAsync(String resourceGroupName, String profileName, List<LogRanking> rankings, List<LogRankingMetric> metrics, int maxRanking, DateTime dateTimeBegin, DateTime dateTimeEnd) {
        return this.getLogAnalyticsRankingsWithServiceResponseAsync(resourceGroupName, profileName, rankings, metrics, maxRanking, dateTimeBegin, dateTimeEnd).map((Func1)new Func1<ServiceResponse<RankingsResponseInner>, RankingsResponseInner>(){

            public RankingsResponseInner call(ServiceResponse<RankingsResponseInner> response) {
                return (RankingsResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RankingsResponseInner>> getLogAnalyticsRankingsWithServiceResponseAsync(String resourceGroupName, String profileName, List<LogRanking> rankings, List<LogRankingMetric> metrics, int maxRanking, DateTime dateTimeBegin, DateTime dateTimeEnd) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (rankings == null) {
            throw new IllegalArgumentException("Parameter rankings is required and cannot be null.");
        }
        if (metrics == null) {
            throw new IllegalArgumentException("Parameter metrics is required and cannot be null.");
        }
        if (dateTimeBegin == null) {
            throw new IllegalArgumentException("Parameter dateTimeBegin is required and cannot be null.");
        }
        if (dateTimeEnd == null) {
            throw new IllegalArgumentException("Parameter dateTimeEnd is required and cannot be null.");
        }
        Validator.validate(rankings);
        Validator.validate(metrics);
        List customDomains = null;
        String rankingsConverted = this.client.serializerAdapter().serializeList(rankings, CollectionFormat.MULTI);
        String metricsConverted = this.client.serializerAdapter().serializeList(metrics, CollectionFormat.MULTI);
        String customDomainsConverted = this.client.serializerAdapter().serializeList(customDomains, CollectionFormat.MULTI);
        return this.service.getLogAnalyticsRankings(this.client.subscriptionId(), resourceGroupName, profileName, this.client.apiVersion(), rankingsConverted, metricsConverted, maxRanking, dateTimeBegin, dateTimeEnd, customDomainsConverted, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RankingsResponseInner>>>(){

            public Observable<ServiceResponse<RankingsResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LogAnalyticsInner.this.getLogAnalyticsRankingsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public RankingsResponseInner getLogAnalyticsRankings(String resourceGroupName, String profileName, List<LogRanking> rankings, List<LogRankingMetric> metrics, int maxRanking, DateTime dateTimeBegin, DateTime dateTimeEnd, List<String> customDomains) {
        return (RankingsResponseInner)((ServiceResponse)this.getLogAnalyticsRankingsWithServiceResponseAsync(resourceGroupName, profileName, rankings, metrics, maxRanking, dateTimeBegin, dateTimeEnd, customDomains).toBlocking().single()).body();
    }

    public ServiceFuture<RankingsResponseInner> getLogAnalyticsRankingsAsync(String resourceGroupName, String profileName, List<LogRanking> rankings, List<LogRankingMetric> metrics, int maxRanking, DateTime dateTimeBegin, DateTime dateTimeEnd, List<String> customDomains, ServiceCallback<RankingsResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getLogAnalyticsRankingsWithServiceResponseAsync(resourceGroupName, profileName, rankings, metrics, maxRanking, dateTimeBegin, dateTimeEnd, customDomains), serviceCallback);
    }

    public Observable<RankingsResponseInner> getLogAnalyticsRankingsAsync(String resourceGroupName, String profileName, List<LogRanking> rankings, List<LogRankingMetric> metrics, int maxRanking, DateTime dateTimeBegin, DateTime dateTimeEnd, List<String> customDomains) {
        return this.getLogAnalyticsRankingsWithServiceResponseAsync(resourceGroupName, profileName, rankings, metrics, maxRanking, dateTimeBegin, dateTimeEnd, customDomains).map((Func1)new Func1<ServiceResponse<RankingsResponseInner>, RankingsResponseInner>(){

            public RankingsResponseInner call(ServiceResponse<RankingsResponseInner> response) {
                return (RankingsResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RankingsResponseInner>> getLogAnalyticsRankingsWithServiceResponseAsync(String resourceGroupName, String profileName, List<LogRanking> rankings, List<LogRankingMetric> metrics, int maxRanking, DateTime dateTimeBegin, DateTime dateTimeEnd, List<String> customDomains) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (rankings == null) {
            throw new IllegalArgumentException("Parameter rankings is required and cannot be null.");
        }
        if (metrics == null) {
            throw new IllegalArgumentException("Parameter metrics is required and cannot be null.");
        }
        if (dateTimeBegin == null) {
            throw new IllegalArgumentException("Parameter dateTimeBegin is required and cannot be null.");
        }
        if (dateTimeEnd == null) {
            throw new IllegalArgumentException("Parameter dateTimeEnd is required and cannot be null.");
        }
        Validator.validate(rankings);
        Validator.validate(metrics);
        Validator.validate(customDomains);
        String rankingsConverted = this.client.serializerAdapter().serializeList(rankings, CollectionFormat.MULTI);
        String metricsConverted = this.client.serializerAdapter().serializeList(metrics, CollectionFormat.MULTI);
        String customDomainsConverted = this.client.serializerAdapter().serializeList(customDomains, CollectionFormat.MULTI);
        return this.service.getLogAnalyticsRankings(this.client.subscriptionId(), resourceGroupName, profileName, this.client.apiVersion(), rankingsConverted, metricsConverted, maxRanking, dateTimeBegin, dateTimeEnd, customDomainsConverted, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RankingsResponseInner>>>(){

            public Observable<ServiceResponse<RankingsResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LogAnalyticsInner.this.getLogAnalyticsRankingsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RankingsResponseInner> getLogAnalyticsRankingsDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RankingsResponseInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public ContinentsResponseInner getLogAnalyticsLocations(String resourceGroupName, String profileName) {
        return (ContinentsResponseInner)((ServiceResponse)this.getLogAnalyticsLocationsWithServiceResponseAsync(resourceGroupName, profileName).toBlocking().single()).body();
    }

    public ServiceFuture<ContinentsResponseInner> getLogAnalyticsLocationsAsync(String resourceGroupName, String profileName, ServiceCallback<ContinentsResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getLogAnalyticsLocationsWithServiceResponseAsync(resourceGroupName, profileName), serviceCallback);
    }

    public Observable<ContinentsResponseInner> getLogAnalyticsLocationsAsync(String resourceGroupName, String profileName) {
        return this.getLogAnalyticsLocationsWithServiceResponseAsync(resourceGroupName, profileName).map((Func1)new Func1<ServiceResponse<ContinentsResponseInner>, ContinentsResponseInner>(){

            public ContinentsResponseInner call(ServiceResponse<ContinentsResponseInner> response) {
                return (ContinentsResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ContinentsResponseInner>> getLogAnalyticsLocationsWithServiceResponseAsync(String resourceGroupName, String profileName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getLogAnalyticsLocations(this.client.subscriptionId(), resourceGroupName, profileName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ContinentsResponseInner>>>(){

            public Observable<ServiceResponse<ContinentsResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LogAnalyticsInner.this.getLogAnalyticsLocationsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ContinentsResponseInner> getLogAnalyticsLocationsDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ContinentsResponseInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public ResourcesResponseInner getLogAnalyticsResources(String resourceGroupName, String profileName) {
        return (ResourcesResponseInner)((ServiceResponse)this.getLogAnalyticsResourcesWithServiceResponseAsync(resourceGroupName, profileName).toBlocking().single()).body();
    }

    public ServiceFuture<ResourcesResponseInner> getLogAnalyticsResourcesAsync(String resourceGroupName, String profileName, ServiceCallback<ResourcesResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getLogAnalyticsResourcesWithServiceResponseAsync(resourceGroupName, profileName), serviceCallback);
    }

    public Observable<ResourcesResponseInner> getLogAnalyticsResourcesAsync(String resourceGroupName, String profileName) {
        return this.getLogAnalyticsResourcesWithServiceResponseAsync(resourceGroupName, profileName).map((Func1)new Func1<ServiceResponse<ResourcesResponseInner>, ResourcesResponseInner>(){

            public ResourcesResponseInner call(ServiceResponse<ResourcesResponseInner> response) {
                return (ResourcesResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ResourcesResponseInner>> getLogAnalyticsResourcesWithServiceResponseAsync(String resourceGroupName, String profileName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getLogAnalyticsResources(this.client.subscriptionId(), resourceGroupName, profileName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourcesResponseInner>>>(){

            public Observable<ServiceResponse<ResourcesResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LogAnalyticsInner.this.getLogAnalyticsResourcesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ResourcesResponseInner> getLogAnalyticsResourcesDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ResourcesResponseInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public WafMetricsResponseInner getWafLogAnalyticsMetrics(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, WafGranularity granularity) {
        return (WafMetricsResponseInner)((ServiceResponse)this.getWafLogAnalyticsMetricsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity).toBlocking().single()).body();
    }

    public ServiceFuture<WafMetricsResponseInner> getWafLogAnalyticsMetricsAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, WafGranularity granularity, ServiceCallback<WafMetricsResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWafLogAnalyticsMetricsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity), serviceCallback);
    }

    public Observable<WafMetricsResponseInner> getWafLogAnalyticsMetricsAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, WafGranularity granularity) {
        return this.getWafLogAnalyticsMetricsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity).map((Func1)new Func1<ServiceResponse<WafMetricsResponseInner>, WafMetricsResponseInner>(){

            public WafMetricsResponseInner call(ServiceResponse<WafMetricsResponseInner> response) {
                return (WafMetricsResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<WafMetricsResponseInner>> getWafLogAnalyticsMetricsWithServiceResponseAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, WafGranularity granularity) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (metrics == null) {
            throw new IllegalArgumentException("Parameter metrics is required and cannot be null.");
        }
        if (dateTimeBegin == null) {
            throw new IllegalArgumentException("Parameter dateTimeBegin is required and cannot be null.");
        }
        if (dateTimeEnd == null) {
            throw new IllegalArgumentException("Parameter dateTimeEnd is required and cannot be null.");
        }
        if (granularity == null) {
            throw new IllegalArgumentException("Parameter granularity is required and cannot be null.");
        }
        Validator.validate(metrics);
        List actions = null;
        List groupBy = null;
        List ruleTypes = null;
        String metricsConverted = this.client.serializerAdapter().serializeList(metrics, CollectionFormat.MULTI);
        String actionsConverted = this.client.serializerAdapter().serializeList(actions, CollectionFormat.MULTI);
        String groupByConverted = this.client.serializerAdapter().serializeList(groupBy, CollectionFormat.MULTI);
        String ruleTypesConverted = this.client.serializerAdapter().serializeList(ruleTypes, CollectionFormat.MULTI);
        return this.service.getWafLogAnalyticsMetrics(this.client.subscriptionId(), resourceGroupName, profileName, this.client.apiVersion(), metricsConverted, dateTimeBegin, dateTimeEnd, granularity, actionsConverted, groupByConverted, ruleTypesConverted, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<WafMetricsResponseInner>>>(){

            public Observable<ServiceResponse<WafMetricsResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LogAnalyticsInner.this.getWafLogAnalyticsMetricsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public WafMetricsResponseInner getWafLogAnalyticsMetrics(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, WafGranularity granularity, List<WafAction> actions, List<WafRankingGroupBy> groupBy, List<WafRuleType> ruleTypes) {
        return (WafMetricsResponseInner)((ServiceResponse)this.getWafLogAnalyticsMetricsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, actions, groupBy, ruleTypes).toBlocking().single()).body();
    }

    public ServiceFuture<WafMetricsResponseInner> getWafLogAnalyticsMetricsAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, WafGranularity granularity, List<WafAction> actions, List<WafRankingGroupBy> groupBy, List<WafRuleType> ruleTypes, ServiceCallback<WafMetricsResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWafLogAnalyticsMetricsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, actions, groupBy, ruleTypes), serviceCallback);
    }

    public Observable<WafMetricsResponseInner> getWafLogAnalyticsMetricsAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, WafGranularity granularity, List<WafAction> actions, List<WafRankingGroupBy> groupBy, List<WafRuleType> ruleTypes) {
        return this.getWafLogAnalyticsMetricsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, actions, groupBy, ruleTypes).map((Func1)new Func1<ServiceResponse<WafMetricsResponseInner>, WafMetricsResponseInner>(){

            public WafMetricsResponseInner call(ServiceResponse<WafMetricsResponseInner> response) {
                return (WafMetricsResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<WafMetricsResponseInner>> getWafLogAnalyticsMetricsWithServiceResponseAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, WafGranularity granularity, List<WafAction> actions, List<WafRankingGroupBy> groupBy, List<WafRuleType> ruleTypes) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (metrics == null) {
            throw new IllegalArgumentException("Parameter metrics is required and cannot be null.");
        }
        if (dateTimeBegin == null) {
            throw new IllegalArgumentException("Parameter dateTimeBegin is required and cannot be null.");
        }
        if (dateTimeEnd == null) {
            throw new IllegalArgumentException("Parameter dateTimeEnd is required and cannot be null.");
        }
        if (granularity == null) {
            throw new IllegalArgumentException("Parameter granularity is required and cannot be null.");
        }
        Validator.validate(metrics);
        Validator.validate(actions);
        Validator.validate(groupBy);
        Validator.validate(ruleTypes);
        String metricsConverted = this.client.serializerAdapter().serializeList(metrics, CollectionFormat.MULTI);
        String actionsConverted = this.client.serializerAdapter().serializeList(actions, CollectionFormat.MULTI);
        String groupByConverted = this.client.serializerAdapter().serializeList(groupBy, CollectionFormat.MULTI);
        String ruleTypesConverted = this.client.serializerAdapter().serializeList(ruleTypes, CollectionFormat.MULTI);
        return this.service.getWafLogAnalyticsMetrics(this.client.subscriptionId(), resourceGroupName, profileName, this.client.apiVersion(), metricsConverted, dateTimeBegin, dateTimeEnd, granularity, actionsConverted, groupByConverted, ruleTypesConverted, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<WafMetricsResponseInner>>>(){

            public Observable<ServiceResponse<WafMetricsResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LogAnalyticsInner.this.getWafLogAnalyticsMetricsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<WafMetricsResponseInner> getWafLogAnalyticsMetricsDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<WafMetricsResponseInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public WafRankingsResponseInner getWafLogAnalyticsRankings(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, int maxRanking, List<WafRankingType> rankings) {
        return (WafRankingsResponseInner)((ServiceResponse)this.getWafLogAnalyticsRankingsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, maxRanking, rankings).toBlocking().single()).body();
    }

    public ServiceFuture<WafRankingsResponseInner> getWafLogAnalyticsRankingsAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, int maxRanking, List<WafRankingType> rankings, ServiceCallback<WafRankingsResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWafLogAnalyticsRankingsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, maxRanking, rankings), serviceCallback);
    }

    public Observable<WafRankingsResponseInner> getWafLogAnalyticsRankingsAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, int maxRanking, List<WafRankingType> rankings) {
        return this.getWafLogAnalyticsRankingsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, maxRanking, rankings).map((Func1)new Func1<ServiceResponse<WafRankingsResponseInner>, WafRankingsResponseInner>(){

            public WafRankingsResponseInner call(ServiceResponse<WafRankingsResponseInner> response) {
                return (WafRankingsResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<WafRankingsResponseInner>> getWafLogAnalyticsRankingsWithServiceResponseAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, int maxRanking, List<WafRankingType> rankings) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (metrics == null) {
            throw new IllegalArgumentException("Parameter metrics is required and cannot be null.");
        }
        if (dateTimeBegin == null) {
            throw new IllegalArgumentException("Parameter dateTimeBegin is required and cannot be null.");
        }
        if (dateTimeEnd == null) {
            throw new IllegalArgumentException("Parameter dateTimeEnd is required and cannot be null.");
        }
        if (rankings == null) {
            throw new IllegalArgumentException("Parameter rankings is required and cannot be null.");
        }
        Validator.validate(metrics);
        Validator.validate(rankings);
        List actions = null;
        List ruleTypes = null;
        String metricsConverted = this.client.serializerAdapter().serializeList(metrics, CollectionFormat.MULTI);
        String rankingsConverted = this.client.serializerAdapter().serializeList(rankings, CollectionFormat.MULTI);
        String actionsConverted = this.client.serializerAdapter().serializeList(actions, CollectionFormat.MULTI);
        String ruleTypesConverted = this.client.serializerAdapter().serializeList(ruleTypes, CollectionFormat.MULTI);
        return this.service.getWafLogAnalyticsRankings(this.client.subscriptionId(), resourceGroupName, profileName, this.client.apiVersion(), metricsConverted, dateTimeBegin, dateTimeEnd, maxRanking, rankingsConverted, actionsConverted, ruleTypesConverted, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<WafRankingsResponseInner>>>(){

            public Observable<ServiceResponse<WafRankingsResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LogAnalyticsInner.this.getWafLogAnalyticsRankingsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public WafRankingsResponseInner getWafLogAnalyticsRankings(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, int maxRanking, List<WafRankingType> rankings, List<WafAction> actions, List<WafRuleType> ruleTypes) {
        return (WafRankingsResponseInner)((ServiceResponse)this.getWafLogAnalyticsRankingsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, maxRanking, rankings, actions, ruleTypes).toBlocking().single()).body();
    }

    public ServiceFuture<WafRankingsResponseInner> getWafLogAnalyticsRankingsAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, int maxRanking, List<WafRankingType> rankings, List<WafAction> actions, List<WafRuleType> ruleTypes, ServiceCallback<WafRankingsResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWafLogAnalyticsRankingsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, maxRanking, rankings, actions, ruleTypes), serviceCallback);
    }

    public Observable<WafRankingsResponseInner> getWafLogAnalyticsRankingsAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, int maxRanking, List<WafRankingType> rankings, List<WafAction> actions, List<WafRuleType> ruleTypes) {
        return this.getWafLogAnalyticsRankingsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, maxRanking, rankings, actions, ruleTypes).map((Func1)new Func1<ServiceResponse<WafRankingsResponseInner>, WafRankingsResponseInner>(){

            public WafRankingsResponseInner call(ServiceResponse<WafRankingsResponseInner> response) {
                return (WafRankingsResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<WafRankingsResponseInner>> getWafLogAnalyticsRankingsWithServiceResponseAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, int maxRanking, List<WafRankingType> rankings, List<WafAction> actions, List<WafRuleType> ruleTypes) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (metrics == null) {
            throw new IllegalArgumentException("Parameter metrics is required and cannot be null.");
        }
        if (dateTimeBegin == null) {
            throw new IllegalArgumentException("Parameter dateTimeBegin is required and cannot be null.");
        }
        if (dateTimeEnd == null) {
            throw new IllegalArgumentException("Parameter dateTimeEnd is required and cannot be null.");
        }
        if (rankings == null) {
            throw new IllegalArgumentException("Parameter rankings is required and cannot be null.");
        }
        Validator.validate(metrics);
        Validator.validate(rankings);
        Validator.validate(actions);
        Validator.validate(ruleTypes);
        String metricsConverted = this.client.serializerAdapter().serializeList(metrics, CollectionFormat.MULTI);
        String rankingsConverted = this.client.serializerAdapter().serializeList(rankings, CollectionFormat.MULTI);
        String actionsConverted = this.client.serializerAdapter().serializeList(actions, CollectionFormat.MULTI);
        String ruleTypesConverted = this.client.serializerAdapter().serializeList(ruleTypes, CollectionFormat.MULTI);
        return this.service.getWafLogAnalyticsRankings(this.client.subscriptionId(), resourceGroupName, profileName, this.client.apiVersion(), metricsConverted, dateTimeBegin, dateTimeEnd, maxRanking, rankingsConverted, actionsConverted, ruleTypesConverted, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<WafRankingsResponseInner>>>(){

            public Observable<ServiceResponse<WafRankingsResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LogAnalyticsInner.this.getWafLogAnalyticsRankingsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<WafRankingsResponseInner> getWafLogAnalyticsRankingsDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<WafRankingsResponseInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    static interface LogAnalyticsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.LogAnalytics getLogAnalyticsMetrics"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsMetrics")
        public Observable<Response<ResponseBody>> getLogAnalyticsMetrics(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="profileName") String var3, @Query(value="api-version") String var4, @Query(value="metrics") String var5, @Query(value="dateTimeBegin") DateTime var6, @Query(value="dateTimeEnd") DateTime var7, @Query(value="granularity") LogMetricsGranularity var8, @Query(value="groupBy") String var9, @Query(value="continents") String var10, @Query(value="countryOrRegions") String var11, @Query(value="customDomains") String var12, @Query(value="protocols") String var13, @Header(value="accept-language") String var14, @Header(value="User-Agent") String var15);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.LogAnalytics getLogAnalyticsRankings"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsRankings")
        public Observable<Response<ResponseBody>> getLogAnalyticsRankings(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="profileName") String var3, @Query(value="api-version") String var4, @Query(value="rankings") String var5, @Query(value="metrics") String var6, @Query(value="maxRanking") int var7, @Query(value="dateTimeBegin") DateTime var8, @Query(value="dateTimeEnd") DateTime var9, @Query(value="customDomains") String var10, @Header(value="accept-language") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.LogAnalytics getLogAnalyticsLocations"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsLocations")
        public Observable<Response<ResponseBody>> getLogAnalyticsLocations(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="profileName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.LogAnalytics getLogAnalyticsResources"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsResources")
        public Observable<Response<ResponseBody>> getLogAnalyticsResources(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="profileName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.LogAnalytics getWafLogAnalyticsMetrics"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getWafLogAnalyticsMetrics")
        public Observable<Response<ResponseBody>> getWafLogAnalyticsMetrics(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="profileName") String var3, @Query(value="api-version") String var4, @Query(value="metrics") String var5, @Query(value="dateTimeBegin") DateTime var6, @Query(value="dateTimeEnd") DateTime var7, @Query(value="granularity") WafGranularity var8, @Query(value="actions") String var9, @Query(value="groupBy") String var10, @Query(value="ruleTypes") String var11, @Header(value="accept-language") String var12, @Header(value="User-Agent") String var13);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.LogAnalytics getWafLogAnalyticsRankings"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getWafLogAnalyticsRankings")
        public Observable<Response<ResponseBody>> getWafLogAnalyticsRankings(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="profileName") String var3, @Query(value="api-version") String var4, @Query(value="metrics") String var5, @Query(value="dateTimeBegin") DateTime var6, @Query(value="dateTimeEnd") DateTime var7, @Query(value="maxRanking") int var8, @Query(value="rankings") String var9, @Query(value="actions") String var10, @Query(value="ruleTypes") String var11, @Header(value="accept-language") String var12, @Header(value="User-Agent") String var13);
    }
}

