/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cdn.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.cdn.AfdErrorResponseException;
import com.microsoft.azure.management.cdn.ValidateCustomDomainInput;
import com.microsoft.azure.management.cdn.implementation.CdnManagementClientImpl;
import com.microsoft.azure.management.cdn.implementation.PageImpl;
import com.microsoft.azure.management.cdn.implementation.UsageInner;
import com.microsoft.azure.management.cdn.implementation.ValidateCustomDomainOutputInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class AFDProfilesInner {
    private AFDProfilesService service;
    private CdnManagementClientImpl client;

    public AFDProfilesInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = (AFDProfilesService)retrofit.create(AFDProfilesService.class);
        this.client = client;
    }

    public PagedList<UsageInner> listResourceUsage(String resourceGroupName, String profileName) {
        ServiceResponse response = (ServiceResponse)this.listResourceUsageSinglePageAsync(resourceGroupName, profileName).toBlocking().single();
        return new PagedList<UsageInner>((Page)response.body()){

            public Page<UsageInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AFDProfilesInner.this.listResourceUsageNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<UsageInner>> listResourceUsageAsync(String resourceGroupName, String profileName, ListOperationCallback<UsageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listResourceUsageSinglePageAsync(resourceGroupName, profileName), (Func1)new Func1<String, Observable<ServiceResponse<Page<UsageInner>>>>(){

            public Observable<ServiceResponse<Page<UsageInner>>> call(String nextPageLink) {
                return AFDProfilesInner.this.listResourceUsageNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<UsageInner>> listResourceUsageAsync(String resourceGroupName, String profileName) {
        return this.listResourceUsageWithServiceResponseAsync(resourceGroupName, profileName).map((Func1)new Func1<ServiceResponse<Page<UsageInner>>, Page<UsageInner>>(){

            public Page<UsageInner> call(ServiceResponse<Page<UsageInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<UsageInner>>> listResourceUsageWithServiceResponseAsync(String resourceGroupName, String profileName) {
        return this.listResourceUsageSinglePageAsync(resourceGroupName, profileName).concatMap((Func1)new Func1<ServiceResponse<Page<UsageInner>>, Observable<ServiceResponse<Page<UsageInner>>>>(){

            public Observable<ServiceResponse<Page<UsageInner>>> call(ServiceResponse<Page<UsageInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AFDProfilesInner.this.listResourceUsageNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<UsageInner>>> listResourceUsageSinglePageAsync(String resourceGroupName, String profileName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listResourceUsage(resourceGroupName, profileName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<UsageInner>>>>(){

            public Observable<ServiceResponse<Page<UsageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AFDProfilesInner.this.listResourceUsageDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<UsageInner>> listResourceUsageDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<UsageInner>>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public ValidateCustomDomainOutputInner checkHostNameAvailability(String resourceGroupName, String profileName, String hostName) {
        return (ValidateCustomDomainOutputInner)((ServiceResponse)this.checkHostNameAvailabilityWithServiceResponseAsync(resourceGroupName, profileName, hostName).toBlocking().single()).body();
    }

    public ServiceFuture<ValidateCustomDomainOutputInner> checkHostNameAvailabilityAsync(String resourceGroupName, String profileName, String hostName, ServiceCallback<ValidateCustomDomainOutputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkHostNameAvailabilityWithServiceResponseAsync(resourceGroupName, profileName, hostName), serviceCallback);
    }

    public Observable<ValidateCustomDomainOutputInner> checkHostNameAvailabilityAsync(String resourceGroupName, String profileName, String hostName) {
        return this.checkHostNameAvailabilityWithServiceResponseAsync(resourceGroupName, profileName, hostName).map((Func1)new Func1<ServiceResponse<ValidateCustomDomainOutputInner>, ValidateCustomDomainOutputInner>(){

            public ValidateCustomDomainOutputInner call(ServiceResponse<ValidateCustomDomainOutputInner> response) {
                return (ValidateCustomDomainOutputInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ValidateCustomDomainOutputInner>> checkHostNameAvailabilityWithServiceResponseAsync(String resourceGroupName, String profileName, String hostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Parameter hostName is required and cannot be null.");
        }
        ValidateCustomDomainInput checkHostNameAvailabilityInput = new ValidateCustomDomainInput();
        checkHostNameAvailabilityInput.withHostName(hostName);
        return this.service.checkHostNameAvailability(resourceGroupName, profileName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), checkHostNameAvailabilityInput, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ValidateCustomDomainOutputInner>>>(){

            public Observable<ServiceResponse<ValidateCustomDomainOutputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AFDProfilesInner.this.checkHostNameAvailabilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ValidateCustomDomainOutputInner> checkHostNameAvailabilityDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ValidateCustomDomainOutputInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public PagedList<UsageInner> listResourceUsageNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listResourceUsageNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<UsageInner>((Page)response.body()){

            public Page<UsageInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AFDProfilesInner.this.listResourceUsageNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<UsageInner>> listResourceUsageNextAsync(String nextPageLink, ServiceFuture<List<UsageInner>> serviceFuture, ListOperationCallback<UsageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listResourceUsageNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<UsageInner>>>>(){

            public Observable<ServiceResponse<Page<UsageInner>>> call(String nextPageLink) {
                return AFDProfilesInner.this.listResourceUsageNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<UsageInner>> listResourceUsageNextAsync(String nextPageLink) {
        return this.listResourceUsageNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<UsageInner>>, Page<UsageInner>>(){

            public Page<UsageInner> call(ServiceResponse<Page<UsageInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<UsageInner>>> listResourceUsageNextWithServiceResponseAsync(String nextPageLink) {
        return this.listResourceUsageNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<UsageInner>>, Observable<ServiceResponse<Page<UsageInner>>>>(){

            public Observable<ServiceResponse<Page<UsageInner>>> call(ServiceResponse<Page<UsageInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AFDProfilesInner.this.listResourceUsageNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<UsageInner>>> listResourceUsageNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listResourceUsageNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<UsageInner>>>>(){

            public Observable<ServiceResponse<Page<UsageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AFDProfilesInner.this.listResourceUsageNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<UsageInner>> listResourceUsageNextDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<UsageInner>>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    static interface AFDProfilesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDProfiles listResourceUsage"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/usages")
        public Observable<Response<ResponseBody>> listResourceUsage(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDProfiles checkHostNameAvailability"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/checkHostNameAvailability")
        public Observable<Response<ResponseBody>> checkHostNameAvailability(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body ValidateCustomDomainInput var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDProfiles listResourceUsageNext"})
        @GET
        public Observable<Response<ResponseBody>> listResourceUsageNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

