/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn.implementation;

import com.microsoft.azure.management.cdn.Sku;
import com.microsoft.azure.management.cdn.ProfileResourceState;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * CDN profile is a logical grouping of endpoints that share the same settings,
 * such as CDN provider and pricing tier.
 */
@JsonFlatten
public class ProfileInner extends TrackedResourceInner {
    /**
     * The pricing tier (defines a CDN provider, feature list and rate) of the
     * CDN profile.
     */
    @JsonProperty(value = "sku", required = true)
    private Sku sku;

    /**
     * Resource status of the profile. Possible values include: 'Creating',
     * 'Active', 'Deleting', 'Disabled'.
     */
    @JsonProperty(value = "properties.resourceState", access = JsonProperty.Access.WRITE_ONLY)
    private ProfileResourceState resourceState;

    /**
     * Provisioning status of the profile.
     */
    @JsonProperty(value = "properties.provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;

    /**
     * Get the sku value.
     *
     * @return the sku value
     */
    public Sku sku() {
        return this.sku;
    }

    /**
     * Set the sku value.
     *
     * @param sku the sku value to set
     * @return the ProfileInner object itself.
     */
    public ProfileInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the resourceState value.
     *
     * @return the resourceState value
     */
    public ProfileResourceState resourceState() {
        return this.resourceState;
    }

    /**
     * Get the provisioningState value.
     *
     * @return the provisioningState value
     */
    public String provisioningState() {
        return this.provisioningState;
    }

}
