/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * CDN Ip address group.
 */
public class IpAddressGroup {
    /**
     * The delivery region of the ip address group.
     */
    @JsonProperty(value = "deliveryRegion")
    private String deliveryRegion;

    /**
     * The list of ip v4 addresses.
     */
    @JsonProperty(value = "ipv4Addresses")
    private List<CidrIpAddress> ipv4Addresses;

    /**
     * The list of ip v6 addresses.
     */
    @JsonProperty(value = "ipv6Addresses")
    private List<CidrIpAddress> ipv6Addresses;

    /**
     * Get the deliveryRegion value.
     *
     * @return the deliveryRegion value
     */
    public String deliveryRegion() {
        return this.deliveryRegion;
    }

    /**
     * Set the deliveryRegion value.
     *
     * @param deliveryRegion the deliveryRegion value to set
     * @return the IpAddressGroup object itself.
     */
    public IpAddressGroup withDeliveryRegion(String deliveryRegion) {
        this.deliveryRegion = deliveryRegion;
        return this;
    }

    /**
     * Get the ipv4Addresses value.
     *
     * @return the ipv4Addresses value
     */
    public List<CidrIpAddress> ipv4Addresses() {
        return this.ipv4Addresses;
    }

    /**
     * Set the ipv4Addresses value.
     *
     * @param ipv4Addresses the ipv4Addresses value to set
     * @return the IpAddressGroup object itself.
     */
    public IpAddressGroup withIpv4Addresses(List<CidrIpAddress> ipv4Addresses) {
        this.ipv4Addresses = ipv4Addresses;
        return this;
    }

    /**
     * Get the ipv6Addresses value.
     *
     * @return the ipv6Addresses value
     */
    public List<CidrIpAddress> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    /**
     * Set the ipv6Addresses value.
     *
     * @param ipv6Addresses the ipv6Addresses value to set
     * @return the IpAddressGroup object itself.
     */
    public IpAddressGroup withIpv6Addresses(List<CidrIpAddress> ipv6Addresses) {
        this.ipv6Addresses = ipv6Addresses;
        return this;
    }

}
