/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for CustomDomainResourceState.
 */
public final class CustomDomainResourceState extends ExpandableStringEnum<CustomDomainResourceState> {
    /** Static value Creating for CustomDomainResourceState. */
    public static final CustomDomainResourceState CREATING = fromString("Creating");

    /** Static value Active for CustomDomainResourceState. */
    public static final CustomDomainResourceState ACTIVE = fromString("Active");

    /** Static value Deleting for CustomDomainResourceState. */
    public static final CustomDomainResourceState DELETING = fromString("Deleting");

    /**
     * Creates or finds a CustomDomainResourceState from its string representation.
     * @param name a name to look for
     * @return the corresponding CustomDomainResourceState
     */
    @JsonCreator
    public static CustomDomainResourceState fromString(String name) {
        return fromString(name, CustomDomainResourceState.class);
    }

    /**
     * @return known CustomDomainResourceState values
     */
    public static Collection<CustomDomainResourceState> values() {
        return values(CustomDomainResourceState.class);
    }
}
