/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Defines the parameters for the cache expiration action.
 */
public class CacheExpirationActionParameters {
    /**
     * The odatatype property.
     */
    @JsonProperty(value = "@odata\\.type", required = true)
    private String odatatype;

    /**
     * Caching behavior for the requests that include query strings. Possible
     * values include: 'BypassCache', 'Override', 'SetIfMissing'.
     */
    @JsonProperty(value = "cacheBehavior", required = true)
    private String cacheBehavior;

    /**
     * The level at which the content needs to be cached.
     */
    @JsonProperty(value = "cacheType", required = true)
    private String cacheType;

    /**
     * The duration for which the the content needs to be cached. Allowed
     * format is [d.]hh:mm:ss.
     */
    @JsonProperty(value = "cacheDuration")
    private String cacheDuration;

    /**
     * Creates an instance of CacheExpirationActionParameters class.
     */
    public CacheExpirationActionParameters() {
        odatatype = "Microsoft.Azure.Cdn.Models.DeliveryRuleCacheExpirationActionParameters";
        cacheType = "All";
    }

    /**
     * Get the odatatype value.
     *
     * @return the odatatype value
     */
    public String odatatype() {
        return this.odatatype;
    }

    /**
     * Set the odatatype value.
     *
     * @param odatatype the odatatype value to set
     * @return the CacheExpirationActionParameters object itself.
     */
    public CacheExpirationActionParameters withOdatatype(String odatatype) {
        this.odatatype = odatatype;
        return this;
    }

    /**
     * Get the cacheBehavior value.
     *
     * @return the cacheBehavior value
     */
    public String cacheBehavior() {
        return this.cacheBehavior;
    }

    /**
     * Set the cacheBehavior value.
     *
     * @param cacheBehavior the cacheBehavior value to set
     * @return the CacheExpirationActionParameters object itself.
     */
    public CacheExpirationActionParameters withCacheBehavior(String cacheBehavior) {
        this.cacheBehavior = cacheBehavior;
        return this;
    }

    /**
     * Get the cacheType value.
     *
     * @return the cacheType value
     */
    public String cacheType() {
        return this.cacheType;
    }

    /**
     * Set the cacheType value.
     *
     * @param cacheType the cacheType value to set
     * @return the CacheExpirationActionParameters object itself.
     */
    public CacheExpirationActionParameters withCacheType(String cacheType) {
        this.cacheType = cacheType;
        return this;
    }

    /**
     * Get the cacheDuration value.
     *
     * @return the cacheDuration value
     */
    public String cacheDuration() {
        return this.cacheDuration;
    }

    /**
     * Set the cacheDuration value.
     *
     * @param cacheDuration the cacheDuration value to set
     * @return the CacheExpirationActionParameters object itself.
     */
    public CacheExpirationActionParameters withCacheDuration(String cacheDuration) {
        this.cacheDuration = cacheDuration;
        return this;
    }

}
