/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The pricing tier (defines a CDN provider, feature list and rate) of the CDN
 * profile.
 */
public class Sku {
    /**
     * Name of the pricing tier. Possible values include: 'Standard_Verizon',
     * 'Premium_Verizon', 'Custom_Verizon', 'Standard_Akamai',
     * 'Standard_ChinaCdn'.
     */
    @JsonProperty(value = "name")
    private SkuName name;

    /**
     * Get the name value.
     *
     * @return the name value
     */
    public SkuName name() {
        return this.name;
    }

    /**
     * Set the name value.
     *
     * @param name the name value to set
     * @return the Sku object itself.
     */
    public Sku withName(SkuName name) {
        this.name = name;
        return this;
    }

}
