/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.batchai.BatchAIJob;
import com.microsoft.azure.management.batchai.CNTKsettings;
import com.microsoft.azure.management.batchai.ToolTypeSettings;
import com.microsoft.azure.management.batchai.implementation.BatchAIJobImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableWrapperImpl;

@LangDefinition
class CognitiveToolkitImpl
extends IndexableWrapperImpl<CNTKsettings>
implements ToolTypeSettings.CognitiveToolkit,
ToolTypeSettings.CognitiveToolkit.Definition<BatchAIJob.DefinitionStages.WithCreate> {
    private static final String BRAIN_SCRIPT = "BrainScript";
    private static final String PYTHON = "Python";
    private BatchAIJobImpl parent;

    CognitiveToolkitImpl(CNTKsettings inner, BatchAIJobImpl parent) {
        super((Object)inner);
        this.parent = parent;
    }

    public BatchAIJob parent() {
        return this.parent;
    }

    public BatchAIJob.DefinitionStages.WithCreate attach() {
        this.parent.attachCntkSettings(this);
        return this.parent;
    }

    public CognitiveToolkitImpl withBrainScript(String configFilePath) {
        ((CNTKsettings)this.inner()).withLanguageType(BRAIN_SCRIPT);
        ((CNTKsettings)this.inner()).withConfigFilePath(configFilePath);
        return this;
    }

    public CognitiveToolkitImpl withPythonScriptFile(String pythonScriptFilePath) {
        ((CNTKsettings)this.inner()).withLanguageType(PYTHON);
        ((CNTKsettings)this.inner()).withPythonScriptFilePath(pythonScriptFilePath);
        return this;
    }

    @Override
    public CognitiveToolkitImpl withCommandLineArgs(String commandLineArgs) {
        ((CNTKsettings)this.inner()).withCommandLineArgs(commandLineArgs);
        return this;
    }

    @Override
    public CognitiveToolkitImpl withProcessCount(int processCount) {
        ((CNTKsettings)this.inner()).withProcessCount(processCount);
        return this;
    }

    @Override
    public CognitiveToolkitImpl withPythonInterpreterPath(String path) {
        ((CNTKsettings)this.inner()).withPythonInterpreterPath(path);
        return this;
    }
}

