/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

class Utils {
    Utils() {
    }

    static String smartCompletionPrivateRegistryImage(String imageAndTag, String serverUrl) {
        try {
            URL url = new URL(serverUrl);
            String registryServer = url.getAuthority();
            String path = url.getPath();
            if (!registryServer.isEmpty() && !imageAndTag.trim().startsWith(registryServer)) {
                String segment;
                String[] segments = imageAndTag.split(Pattern.quote("/"));
                if (segments.length == 1) {
                    imageAndTag = Utils.completePrivateRegistryImage(imageAndTag, registryServer, path);
                }
                if (!(segments.length <= 1 || (segment = segments[0]).isEmpty() || segment.contains(".") || segment.contains(":") || segment.equals(registryServer))) {
                    imageAndTag = Utils.completePrivateRegistryImage(imageAndTag, registryServer, path);
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return imageAndTag;
    }

    private static String completePrivateRegistryImage(String imageAndTag, String registryServer, String path) {
        imageAndTag = (path = StringUtils.strip((String)path, (String)"/")).isEmpty() ? String.format("%s/%s", registryServer, imageAndTag.trim()) : String.format("%s/%s/%s", registryServer, path, imageAndTag.trim());
        return imageAndTag;
    }
}

