/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import org.joda.time.DateTime;
import com.microsoft.azure.management.appservice.ComputeModeOptions;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.management.appservice.ProxyOnlyResource;

/**
 * Usage of the quota resource.
 */
@JsonFlatten
public class UsageInner extends ProxyOnlyResource {
    /**
     * Friendly name shown in the UI.
     */
    @JsonProperty(value = "properties.displayName", access = JsonProperty.Access.WRITE_ONLY)
    private String displayName;

    /**
     * Name of the quota resource.
     */
    @JsonProperty(value = "properties.resourceName", access = JsonProperty.Access.WRITE_ONLY)
    private String resourceName;

    /**
     * Units of measurement for the quota resource.
     */
    @JsonProperty(value = "properties.unit", access = JsonProperty.Access.WRITE_ONLY)
    private String unit;

    /**
     * The current value of the resource counter.
     */
    @JsonProperty(value = "properties.currentValue", access = JsonProperty.Access.WRITE_ONLY)
    private Long currentValue;

    /**
     * The resource limit.
     */
    @JsonProperty(value = "properties.limit", access = JsonProperty.Access.WRITE_ONLY)
    private Long limit;

    /**
     * Next reset time for the resource counter.
     */
    @JsonProperty(value = "properties.nextResetTime", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime nextResetTime;

    /**
     * Compute mode used for this usage. Possible values include: 'Shared',
     * 'Dedicated', 'Dynamic'.
     */
    @JsonProperty(value = "properties.computeMode", access = JsonProperty.Access.WRITE_ONLY)
    private ComputeModeOptions computeMode;

    /**
     * Site mode used for this usage.
     */
    @JsonProperty(value = "properties.siteMode", access = JsonProperty.Access.WRITE_ONLY)
    private String siteMode;

    /**
     * Get friendly name shown in the UI.
     *
     * @return the displayName value
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Get name of the quota resource.
     *
     * @return the resourceName value
     */
    public String resourceName() {
        return this.resourceName;
    }

    /**
     * Get units of measurement for the quota resource.
     *
     * @return the unit value
     */
    public String unit() {
        return this.unit;
    }

    /**
     * Get the current value of the resource counter.
     *
     * @return the currentValue value
     */
    public Long currentValue() {
        return this.currentValue;
    }

    /**
     * Get the resource limit.
     *
     * @return the limit value
     */
    public Long limit() {
        return this.limit;
    }

    /**
     * Get next reset time for the resource counter.
     *
     * @return the nextResetTime value
     */
    public DateTime nextResetTime() {
        return this.nextResetTime;
    }

    /**
     * Get compute mode used for this usage. Possible values include: 'Shared', 'Dedicated', 'Dynamic'.
     *
     * @return the computeMode value
     */
    public ComputeModeOptions computeMode() {
        return this.computeMode;
    }

    /**
     * Get site mode used for this usage.
     *
     * @return the siteMode value
     */
    public String siteMode() {
        return this.siteMode;
    }

}
