/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import org.joda.time.DateTime;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.management.appservice.ProxyOnlyResource;

/**
 * The source control OAuth token.
 */
@JsonFlatten
public class SourceControlInner extends ProxyOnlyResource {
    /**
     * OAuth access token.
     */
    @JsonProperty(value = "properties.token")
    private String token;

    /**
     * OAuth access token secret.
     */
    @JsonProperty(value = "properties.tokenSecret")
    private String tokenSecret;

    /**
     * OAuth refresh token.
     */
    @JsonProperty(value = "properties.refreshToken")
    private String refreshToken;

    /**
     * OAuth token expiration.
     */
    @JsonProperty(value = "properties.expirationTime")
    private DateTime expirationTime;

    /**
     * Get oAuth access token.
     *
     * @return the token value
     */
    public String token() {
        return this.token;
    }

    /**
     * Set oAuth access token.
     *
     * @param token the token value to set
     * @return the SourceControlInner object itself.
     */
    public SourceControlInner withToken(String token) {
        this.token = token;
        return this;
    }

    /**
     * Get oAuth access token secret.
     *
     * @return the tokenSecret value
     */
    public String tokenSecret() {
        return this.tokenSecret;
    }

    /**
     * Set oAuth access token secret.
     *
     * @param tokenSecret the tokenSecret value to set
     * @return the SourceControlInner object itself.
     */
    public SourceControlInner withTokenSecret(String tokenSecret) {
        this.tokenSecret = tokenSecret;
        return this;
    }

    /**
     * Get oAuth refresh token.
     *
     * @return the refreshToken value
     */
    public String refreshToken() {
        return this.refreshToken;
    }

    /**
     * Set oAuth refresh token.
     *
     * @param refreshToken the refreshToken value to set
     * @return the SourceControlInner object itself.
     */
    public SourceControlInner withRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    /**
     * Get oAuth token expiration.
     *
     * @return the expirationTime value
     */
    public DateTime expirationTime() {
        return this.expirationTime;
    }

    /**
     * Set oAuth token expiration.
     *
     * @param expirationTime the expirationTime value to set
     * @return the SourceControlInner object itself.
     */
    public SourceControlInner withExpirationTime(DateTime expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

}
