/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.management.appservice.MSDeployProvisioningState;
import org.joda.time.DateTime;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.management.appservice.ProxyOnlyResource;

/**
 * MSDeploy ARM response.
 */
@JsonFlatten
public class MSDeployStatusInner extends ProxyOnlyResource {
    /**
     * Username of deployer.
     */
    @JsonProperty(value = "properties.deployer", access = JsonProperty.Access.WRITE_ONLY)
    private String deployer;

    /**
     * Provisioning state. Possible values include: 'accepted', 'running',
     * 'succeeded', 'failed', 'canceled'.
     */
    @JsonProperty(value = "properties.provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private MSDeployProvisioningState provisioningState;

    /**
     * Start time of deploy operation.
     */
    @JsonProperty(value = "properties.startTime", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime startTime;

    /**
     * End time of deploy operation.
     */
    @JsonProperty(value = "properties.endTime", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime endTime;

    /**
     * Whether the deployment operation has completed.
     */
    @JsonProperty(value = "properties.complete", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean complete;

    /**
     * Get username of deployer.
     *
     * @return the deployer value
     */
    public String deployer() {
        return this.deployer;
    }

    /**
     * Get provisioning state. Possible values include: 'accepted', 'running', 'succeeded', 'failed', 'canceled'.
     *
     * @return the provisioningState value
     */
    public MSDeployProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get start time of deploy operation.
     *
     * @return the startTime value
     */
    public DateTime startTime() {
        return this.startTime;
    }

    /**
     * Get end time of deploy operation.
     *
     * @return the endTime value
     */
    public DateTime endTime() {
        return this.endTime;
    }

    /**
     * Get whether the deployment operation has completed.
     *
     * @return the complete value
     */
    public Boolean complete() {
        return this.complete;
    }

}
