/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.management.appservice.ResolveStatus;
import com.microsoft.azure.management.appservice.ManagedServiceIdentityType;
import com.microsoft.azure.management.appservice.ConfigReferenceSource;
import com.microsoft.azure.management.appservice.ConfigReferenceLocation;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.management.appservice.ProxyOnlyResource;

/**
 * Web app key vault reference and status ARM resource.
 */
@JsonFlatten
public class KeyVaultReferenceResourceInner extends ProxyOnlyResource {
    /**
     * The reference property.
     */
    @JsonProperty(value = "properties.reference")
    private String reference;

    /**
     * Possible values include: 'Initialized', 'Resolved', 'InvalidSyntax',
     * 'MSINotEnabled', 'VaultNotFound', 'SecretNotFound',
     * 'SecretVersionNotFound', 'AccessToKeyVaultDenied', 'OtherReasons'.
     */
    @JsonProperty(value = "properties.status")
    private ResolveStatus status;

    /**
     * The vaultName property.
     */
    @JsonProperty(value = "properties.vaultName")
    private String vaultName;

    /**
     * The secretName property.
     */
    @JsonProperty(value = "properties.secretName")
    private String secretName;

    /**
     * The secretVersion property.
     */
    @JsonProperty(value = "properties.secretVersion")
    private String secretVersion;

    /**
     * Possible values include: 'None', 'SystemAssigned', 'UserAssigned'.
     */
    @JsonProperty(value = "properties.identityType")
    private ManagedServiceIdentityType identityType;

    /**
     * The details property.
     */
    @JsonProperty(value = "properties.details")
    private String details;

    /**
     * Possible values include: 'KeyVault'.
     */
    @JsonProperty(value = "properties.source")
    private ConfigReferenceSource source;

    /**
     * Possible values include: 'ApplicationSetting'.
     */
    @JsonProperty(value = "properties.location")
    private ConfigReferenceLocation location;

    /**
     * Get the reference value.
     *
     * @return the reference value
     */
    public String reference() {
        return this.reference;
    }

    /**
     * Set the reference value.
     *
     * @param reference the reference value to set
     * @return the KeyVaultReferenceResourceInner object itself.
     */
    public KeyVaultReferenceResourceInner withReference(String reference) {
        this.reference = reference;
        return this;
    }

    /**
     * Get possible values include: 'Initialized', 'Resolved', 'InvalidSyntax', 'MSINotEnabled', 'VaultNotFound', 'SecretNotFound', 'SecretVersionNotFound', 'AccessToKeyVaultDenied', 'OtherReasons'.
     *
     * @return the status value
     */
    public ResolveStatus status() {
        return this.status;
    }

    /**
     * Set possible values include: 'Initialized', 'Resolved', 'InvalidSyntax', 'MSINotEnabled', 'VaultNotFound', 'SecretNotFound', 'SecretVersionNotFound', 'AccessToKeyVaultDenied', 'OtherReasons'.
     *
     * @param status the status value to set
     * @return the KeyVaultReferenceResourceInner object itself.
     */
    public KeyVaultReferenceResourceInner withStatus(ResolveStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the vaultName value.
     *
     * @return the vaultName value
     */
    public String vaultName() {
        return this.vaultName;
    }

    /**
     * Set the vaultName value.
     *
     * @param vaultName the vaultName value to set
     * @return the KeyVaultReferenceResourceInner object itself.
     */
    public KeyVaultReferenceResourceInner withVaultName(String vaultName) {
        this.vaultName = vaultName;
        return this;
    }

    /**
     * Get the secretName value.
     *
     * @return the secretName value
     */
    public String secretName() {
        return this.secretName;
    }

    /**
     * Set the secretName value.
     *
     * @param secretName the secretName value to set
     * @return the KeyVaultReferenceResourceInner object itself.
     */
    public KeyVaultReferenceResourceInner withSecretName(String secretName) {
        this.secretName = secretName;
        return this;
    }

    /**
     * Get the secretVersion value.
     *
     * @return the secretVersion value
     */
    public String secretVersion() {
        return this.secretVersion;
    }

    /**
     * Set the secretVersion value.
     *
     * @param secretVersion the secretVersion value to set
     * @return the KeyVaultReferenceResourceInner object itself.
     */
    public KeyVaultReferenceResourceInner withSecretVersion(String secretVersion) {
        this.secretVersion = secretVersion;
        return this;
    }

    /**
     * Get possible values include: 'None', 'SystemAssigned', 'UserAssigned'.
     *
     * @return the identityType value
     */
    public ManagedServiceIdentityType identityType() {
        return this.identityType;
    }

    /**
     * Set possible values include: 'None', 'SystemAssigned', 'UserAssigned'.
     *
     * @param identityType the identityType value to set
     * @return the KeyVaultReferenceResourceInner object itself.
     */
    public KeyVaultReferenceResourceInner withIdentityType(ManagedServiceIdentityType identityType) {
        this.identityType = identityType;
        return this;
    }

    /**
     * Get the details value.
     *
     * @return the details value
     */
    public String details() {
        return this.details;
    }

    /**
     * Set the details value.
     *
     * @param details the details value to set
     * @return the KeyVaultReferenceResourceInner object itself.
     */
    public KeyVaultReferenceResourceInner withDetails(String details) {
        this.details = details;
        return this;
    }

    /**
     * Get possible values include: 'KeyVault'.
     *
     * @return the source value
     */
    public ConfigReferenceSource source() {
        return this.source;
    }

    /**
     * Set possible values include: 'KeyVault'.
     *
     * @param source the source value to set
     * @return the KeyVaultReferenceResourceInner object itself.
     */
    public KeyVaultReferenceResourceInner withSource(ConfigReferenceSource source) {
        this.source = source;
        return this;
    }

    /**
     * Get possible values include: 'ApplicationSetting'.
     *
     * @return the location value
     */
    public ConfigReferenceLocation location() {
        return this.location;
    }

    /**
     * Set possible values include: 'ApplicationSetting'.
     *
     * @param location the location value to set
     * @return the KeyVaultReferenceResourceInner object itself.
     */
    public KeyVaultReferenceResourceInner withLocation(ConfigReferenceLocation location) {
        this.location = location;
        return this;
    }

}
