/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import java.util.Map;
import com.microsoft.azure.management.appservice.AzureStorageInfoValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.azure.management.appservice.ProxyOnlyResource;

/**
 * AzureStorageInfo dictionary resource.
 */
public class AzureStoragePropertyDictionaryResourceInner extends ProxyOnlyResource {
    /**
     * Azure storage accounts.
     */
    @JsonProperty(value = "properties")
    private Map<String, AzureStorageInfoValue> properties;

    /**
     * Get azure storage accounts.
     *
     * @return the properties value
     */
    public Map<String, AzureStorageInfoValue> properties() {
        return this.properties;
    }

    /**
     * Set azure storage accounts.
     *
     * @param properties the properties value to set
     * @return the AzureStoragePropertyDictionaryResourceInner object itself.
     */
    public AzureStoragePropertyDictionaryResourceInner withProperties(Map<String, AzureStorageInfoValue> properties) {
        this.properties = properties;
        return this;
    }

}
