/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * The required set of inputs to validate a VNET.
 */
@JsonFlatten
public class VnetParameters extends ProxyOnlyResource {
    /**
     * The Resource Group of the VNET to be validated.
     */
    @JsonProperty(value = "properties.vnetResourceGroup")
    private String vnetResourceGroup;

    /**
     * The name of the VNET to be validated.
     */
    @JsonProperty(value = "properties.vnetName")
    private String vnetName;

    /**
     * The subnet name to be validated.
     */
    @JsonProperty(value = "properties.vnetSubnetName")
    private String vnetSubnetName;

    /**
     * Get the Resource Group of the VNET to be validated.
     *
     * @return the vnetResourceGroup value
     */
    public String vnetResourceGroup() {
        return this.vnetResourceGroup;
    }

    /**
     * Set the Resource Group of the VNET to be validated.
     *
     * @param vnetResourceGroup the vnetResourceGroup value to set
     * @return the VnetParameters object itself.
     */
    public VnetParameters withVnetResourceGroup(String vnetResourceGroup) {
        this.vnetResourceGroup = vnetResourceGroup;
        return this;
    }

    /**
     * Get the name of the VNET to be validated.
     *
     * @return the vnetName value
     */
    public String vnetName() {
        return this.vnetName;
    }

    /**
     * Set the name of the VNET to be validated.
     *
     * @param vnetName the vnetName value to set
     * @return the VnetParameters object itself.
     */
    public VnetParameters withVnetName(String vnetName) {
        this.vnetName = vnetName;
        return this;
    }

    /**
     * Get the subnet name to be validated.
     *
     * @return the vnetSubnetName value
     */
    public String vnetSubnetName() {
        return this.vnetSubnetName;
    }

    /**
     * Set the subnet name to be validated.
     *
     * @param vnetSubnetName the vnetSubnetName value to set
     * @return the VnetParameters object itself.
     */
    public VnetParameters withVnetSubnetName(String vnetSubnetName) {
        this.vnetSubnetName = vnetSubnetName;
        return this;
    }

}
