/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Site seal request.
 */
public class SiteSealRequest {
    /**
     * If &lt;code&gt;true&lt;/code&gt; use the light color theme for site
     * seal; otherwise, use the default color theme.
     */
    @JsonProperty(value = "lightTheme")
    private Boolean lightTheme;

    /**
     * Locale of site seal.
     */
    @JsonProperty(value = "locale")
    private String locale;

    /**
     * Get if &lt;code&gt;true&lt;/code&gt; use the light color theme for site seal; otherwise, use the default color theme.
     *
     * @return the lightTheme value
     */
    public Boolean lightTheme() {
        return this.lightTheme;
    }

    /**
     * Set if &lt;code&gt;true&lt;/code&gt; use the light color theme for site seal; otherwise, use the default color theme.
     *
     * @param lightTheme the lightTheme value to set
     * @return the SiteSealRequest object itself.
     */
    public SiteSealRequest withLightTheme(Boolean lightTheme) {
        this.lightTheme = lightTheme;
        return this;
    }

    /**
     * Get locale of site seal.
     *
     * @return the locale value
     */
    public String locale() {
        return this.locale;
    }

    /**
     * Set locale of site seal.
     *
     * @param locale the locale value to set
     * @return the SiteSealRequest object itself.
     */
    public SiteSealRequest withLocale(String locale) {
        this.locale = locale;
        return this;
    }

}
