/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * ARM resource for a PremierAddOn.
 */
@JsonFlatten
public class PremierAddOnPatchResource extends ProxyOnlyResource {
    /**
     * Premier add on SKU.
     */
    @JsonProperty(value = "properties.sku")
    private String sku;

    /**
     * Premier add on Product.
     */
    @JsonProperty(value = "properties.product")
    private String product;

    /**
     * Premier add on Vendor.
     */
    @JsonProperty(value = "properties.vendor")
    private String vendor;

    /**
     * Premier add on Marketplace publisher.
     */
    @JsonProperty(value = "properties.marketplacePublisher")
    private String marketplacePublisher;

    /**
     * Premier add on Marketplace offer.
     */
    @JsonProperty(value = "properties.marketplaceOffer")
    private String marketplaceOffer;

    /**
     * Get premier add on SKU.
     *
     * @return the sku value
     */
    public String sku() {
        return this.sku;
    }

    /**
     * Set premier add on SKU.
     *
     * @param sku the sku value to set
     * @return the PremierAddOnPatchResource object itself.
     */
    public PremierAddOnPatchResource withSku(String sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get premier add on Product.
     *
     * @return the product value
     */
    public String product() {
        return this.product;
    }

    /**
     * Set premier add on Product.
     *
     * @param product the product value to set
     * @return the PremierAddOnPatchResource object itself.
     */
    public PremierAddOnPatchResource withProduct(String product) {
        this.product = product;
        return this;
    }

    /**
     * Get premier add on Vendor.
     *
     * @return the vendor value
     */
    public String vendor() {
        return this.vendor;
    }

    /**
     * Set premier add on Vendor.
     *
     * @param vendor the vendor value to set
     * @return the PremierAddOnPatchResource object itself.
     */
    public PremierAddOnPatchResource withVendor(String vendor) {
        this.vendor = vendor;
        return this;
    }

    /**
     * Get premier add on Marketplace publisher.
     *
     * @return the marketplacePublisher value
     */
    public String marketplacePublisher() {
        return this.marketplacePublisher;
    }

    /**
     * Set premier add on Marketplace publisher.
     *
     * @param marketplacePublisher the marketplacePublisher value to set
     * @return the PremierAddOnPatchResource object itself.
     */
    public PremierAddOnPatchResource withMarketplacePublisher(String marketplacePublisher) {
        this.marketplacePublisher = marketplacePublisher;
        return this;
    }

    /**
     * Get premier add on Marketplace offer.
     *
     * @return the marketplaceOffer value
     */
    public String marketplaceOffer() {
        return this.marketplaceOffer;
    }

    /**
     * Set premier add on Marketplace offer.
     *
     * @param marketplaceOffer the marketplaceOffer value to set
     * @return the PremierAddOnPatchResource object itself.
     */
    public PremierAddOnPatchResource withMarketplaceOffer(String marketplaceOffer) {
        this.marketplaceOffer = marketplaceOffer;
        return this;
    }

}
