/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Details of a hostname derived from a domain.
 */
public class HostName {
    /**
     * Name of the hostname.
     */
    @JsonProperty(value = "name")
    private String name;

    /**
     * List of apps the hostname is assigned to. This list will have more than
     * one app only if the hostname is pointing to a Traffic Manager.
     */
    @JsonProperty(value = "siteNames")
    private List<String> siteNames;

    /**
     * Name of the Azure resource the hostname is assigned to. If it is
     * assigned to a Traffic Manager then it will be the Traffic Manager name
     * otherwise it will be the app name.
     */
    @JsonProperty(value = "azureResourceName")
    private String azureResourceName;

    /**
     * Type of the Azure resource the hostname is assigned to. Possible values
     * include: 'Website', 'TrafficManager'.
     */
    @JsonProperty(value = "azureResourceType")
    private AzureResourceType azureResourceType;

    /**
     * Type of the DNS record. Possible values include: 'CName', 'A'.
     */
    @JsonProperty(value = "customHostNameDnsRecordType")
    private CustomHostNameDnsRecordType customHostNameDnsRecordType;

    /**
     * Type of the hostname. Possible values include: 'Verified', 'Managed'.
     */
    @JsonProperty(value = "hostNameType")
    private HostNameType hostNameType;

    /**
     * Get name of the hostname.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set name of the hostname.
     *
     * @param name the name value to set
     * @return the HostName object itself.
     */
    public HostName withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get list of apps the hostname is assigned to. This list will have more than one app only if the hostname is pointing to a Traffic Manager.
     *
     * @return the siteNames value
     */
    public List<String> siteNames() {
        return this.siteNames;
    }

    /**
     * Set list of apps the hostname is assigned to. This list will have more than one app only if the hostname is pointing to a Traffic Manager.
     *
     * @param siteNames the siteNames value to set
     * @return the HostName object itself.
     */
    public HostName withSiteNames(List<String> siteNames) {
        this.siteNames = siteNames;
        return this;
    }

    /**
     * Get name of the Azure resource the hostname is assigned to. If it is assigned to a Traffic Manager then it will be the Traffic Manager name otherwise it will be the app name.
     *
     * @return the azureResourceName value
     */
    public String azureResourceName() {
        return this.azureResourceName;
    }

    /**
     * Set name of the Azure resource the hostname is assigned to. If it is assigned to a Traffic Manager then it will be the Traffic Manager name otherwise it will be the app name.
     *
     * @param azureResourceName the azureResourceName value to set
     * @return the HostName object itself.
     */
    public HostName withAzureResourceName(String azureResourceName) {
        this.azureResourceName = azureResourceName;
        return this;
    }

    /**
     * Get type of the Azure resource the hostname is assigned to. Possible values include: 'Website', 'TrafficManager'.
     *
     * @return the azureResourceType value
     */
    public AzureResourceType azureResourceType() {
        return this.azureResourceType;
    }

    /**
     * Set type of the Azure resource the hostname is assigned to. Possible values include: 'Website', 'TrafficManager'.
     *
     * @param azureResourceType the azureResourceType value to set
     * @return the HostName object itself.
     */
    public HostName withAzureResourceType(AzureResourceType azureResourceType) {
        this.azureResourceType = azureResourceType;
        return this;
    }

    /**
     * Get type of the DNS record. Possible values include: 'CName', 'A'.
     *
     * @return the customHostNameDnsRecordType value
     */
    public CustomHostNameDnsRecordType customHostNameDnsRecordType() {
        return this.customHostNameDnsRecordType;
    }

    /**
     * Set type of the DNS record. Possible values include: 'CName', 'A'.
     *
     * @param customHostNameDnsRecordType the customHostNameDnsRecordType value to set
     * @return the HostName object itself.
     */
    public HostName withCustomHostNameDnsRecordType(CustomHostNameDnsRecordType customHostNameDnsRecordType) {
        this.customHostNameDnsRecordType = customHostNameDnsRecordType;
        return this;
    }

    /**
     * Get type of the hostname. Possible values include: 'Verified', 'Managed'.
     *
     * @return the hostNameType value
     */
    public HostNameType hostNameType() {
        return this.hostNameType;
    }

    /**
     * Set type of the hostname. Possible values include: 'Verified', 'Managed'.
     *
     * @param hostNameType the hostNameType value to set
     * @return the HostName object itself.
     */
    public HostName withHostNameType(HostNameType hostNameType) {
        this.hostNameType = hostNameType;
        return this;
    }

}
