/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Http logs to file system configuration.
 */
public class FileSystemHttpLogsConfig {
    /**
     * Maximum size in megabytes that http log files can use.
     * When reached old log files will be removed to make space for new ones.
     * Value can range between 25 and 100.
     */
    @JsonProperty(value = "retentionInMb")
    private Integer retentionInMb;

    /**
     * Retention in days.
     * Remove files older than X days.
     * 0 or lower means no retention.
     */
    @JsonProperty(value = "retentionInDays")
    private Integer retentionInDays;

    /**
     * True if configuration is enabled, false if it is disabled and null if
     * configuration is not set.
     */
    @JsonProperty(value = "enabled")
    private Boolean enabled;

    /**
     * Get maximum size in megabytes that http log files can use.
     When reached old log files will be removed to make space for new ones.
     Value can range between 25 and 100.
     *
     * @return the retentionInMb value
     */
    public Integer retentionInMb() {
        return this.retentionInMb;
    }

    /**
     * Set maximum size in megabytes that http log files can use.
     When reached old log files will be removed to make space for new ones.
     Value can range between 25 and 100.
     *
     * @param retentionInMb the retentionInMb value to set
     * @return the FileSystemHttpLogsConfig object itself.
     */
    public FileSystemHttpLogsConfig withRetentionInMb(Integer retentionInMb) {
        this.retentionInMb = retentionInMb;
        return this;
    }

    /**
     * Get retention in days.
     Remove files older than X days.
     0 or lower means no retention.
     *
     * @return the retentionInDays value
     */
    public Integer retentionInDays() {
        return this.retentionInDays;
    }

    /**
     * Set retention in days.
     Remove files older than X days.
     0 or lower means no retention.
     *
     * @param retentionInDays the retentionInDays value to set
     * @return the FileSystemHttpLogsConfig object itself.
     */
    public FileSystemHttpLogsConfig withRetentionInDays(Integer retentionInDays) {
        this.retentionInDays = retentionInDays;
        return this;
    }

    /**
     * Get true if configuration is enabled, false if it is disabled and null if configuration is not set.
     *
     * @return the enabled value
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set true if configuration is enabled, false if it is disabled and null if configuration is not set.
     *
     * @param enabled the enabled value to set
     * @return the FileSystemHttpLogsConfig object itself.
     */
    public FileSystemHttpLogsConfig withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

}
