/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for AzureStorageType.
 */
public enum AzureStorageType {
    /** Enum value AzureFiles. */
    AZURE_FILES("AzureFiles"),

    /** Enum value AzureBlob. */
    AZURE_BLOB("AzureBlob");

    /** The actual serialized value for a AzureStorageType instance. */
    private String value;

    AzureStorageType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a AzureStorageType instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed AzureStorageType object, or null if unable to parse.
     */
    @JsonCreator
    public static AzureStorageType fromString(String value) {
        AzureStorageType[] items = AzureStorageType.values();
        for (AzureStorageType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
