/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.Address;
import com.microsoft.azure.management.appservice.AppServiceDomain;
import com.microsoft.azure.management.appservice.Contact;
import com.microsoft.azure.management.appservice.DomainContact;
import com.microsoft.azure.management.appservice.implementation.AppServiceDomainImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.CountryIsoCode;
import com.microsoft.azure.management.resources.fluentcore.arm.CountryPhoneCode;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
class DomainContactImpl
extends ChildResourceImpl<Contact, AppServiceDomainImpl, AppServiceDomain>
implements DomainContact,
DomainContact.Definition<AppServiceDomain.DefinitionStages.WithCreate> {
    DomainContactImpl(Contact inner, AppServiceDomainImpl parent) {
        super((Object)inner, (Object)parent);
        ((Contact)this.inner()).withAddressMailing(new Address());
    }

    public String name() {
        return this.firstName() + " " + this.lastName();
    }

    @Override
    public Address addressMailing() {
        return ((Contact)this.inner()).addressMailing();
    }

    @Override
    public String email() {
        return ((Contact)this.inner()).email();
    }

    @Override
    public String fax() {
        return ((Contact)this.inner()).fax();
    }

    @Override
    public String jobTitle() {
        return ((Contact)this.inner()).jobTitle();
    }

    @Override
    public String firstName() {
        return ((Contact)this.inner()).nameFirst();
    }

    @Override
    public String lastName() {
        return ((Contact)this.inner()).nameLast();
    }

    @Override
    public String middleName() {
        return ((Contact)this.inner()).nameMiddle();
    }

    @Override
    public String organization() {
        return ((Contact)this.inner()).organization();
    }

    @Override
    public String phone() {
        return ((Contact)this.inner()).phone();
    }

    public AppServiceDomainImpl attach() {
        return ((AppServiceDomainImpl)this.parent()).withRegistrantContact((Contact)this.inner());
    }

    public DomainContactImpl withFirstName(String firstName) {
        ((Contact)this.inner()).withNameFirst(firstName);
        return this;
    }

    public DomainContactImpl withMiddleName(String middleName) {
        ((Contact)this.inner()).withNameMiddle(middleName);
        return this;
    }

    public DomainContactImpl withLastName(String lastName) {
        ((Contact)this.inner()).withNameLast(lastName);
        return this;
    }

    public DomainContactImpl withEmail(String email) {
        ((Contact)this.inner()).withEmail(email);
        return this;
    }

    public DomainContactImpl withAddressLine1(String addressLine1) {
        ((Contact)this.inner()).addressMailing().withAddress1(addressLine1);
        return this;
    }

    public DomainContactImpl withAddressLine2(String addressLine2) {
        ((Contact)this.inner()).addressMailing().withAddress2(addressLine2);
        return this;
    }

    public DomainContactImpl withCity(String city) {
        ((Contact)this.inner()).addressMailing().withCity(city);
        return this;
    }

    public DomainContactImpl withStateOrProvince(String stateOrProvince) {
        ((Contact)this.inner()).addressMailing().withState(stateOrProvince);
        return this;
    }

    public DomainContactImpl withCountry(CountryIsoCode country) {
        ((Contact)this.inner()).addressMailing().withCountry(country.toString());
        return this;
    }

    public DomainContactImpl withPostalCode(String postalCode) {
        ((Contact)this.inner()).addressMailing().withPostalCode(postalCode);
        return this;
    }

    public DomainContactImpl withPhoneCountryCode(CountryPhoneCode code) {
        ((Contact)this.inner()).withPhone(code.toString() + ".");
        return this;
    }

    public DomainContactImpl withPhoneNumber(String phoneNumber) {
        ((Contact)this.inner()).withPhone(((Contact)this.inner()).phone() + phoneNumber);
        return this;
    }

    public DomainContactImpl withFaxNumber(String faxNumber) {
        ((Contact)this.inner()).withFax(faxNumber);
        return this;
    }

    public DomainContactImpl withOrganization(String organziation) {
        ((Contact)this.inner()).withOrganization(organziation);
        return this;
    }

    public DomainContactImpl withJobTitle(String jobTitle) {
        ((Contact)this.inner()).withJobTitle(jobTitle);
        return this;
    }

    @Override
    public Contact build() {
        return (Contact)this.inner();
    }
}

