/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.management.appservice.WebApps;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.SiteConfigResourceInner;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.management.appservice.implementation.SiteLogsConfigInner;
import com.microsoft.azure.management.appservice.implementation.WebAppImpl;
import com.microsoft.azure.management.appservice.implementation.WebAppsInner;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import java.util.Arrays;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
class WebAppsImpl
extends TopLevelModifiableResourcesImpl<WebApp, WebAppImpl, SiteInner, WebAppsInner, AppServiceManager>
implements WebApps {
    private final PagedListConverter<SiteInner, WebApp> converter = new PagedListConverter<SiteInner, WebApp>(){

        protected boolean filter(SiteInner inner) {
            return inner.kind() == null || Arrays.asList(inner.kind().split(",")).contains("app");
        }

        public Observable<WebApp> typeConvertAsync(final SiteInner siteInner) {
            return Observable.zip(((WebSiteManagementClientImpl)((Object)((AppServiceManager)WebAppsImpl.this.manager()).inner())).webApps().getConfigurationAsync(siteInner.resourceGroup(), siteInner.name()), ((WebSiteManagementClientImpl)((Object)((AppServiceManager)WebAppsImpl.this.manager()).inner())).webApps().getDiagnosticLogsConfigurationAsync(siteInner.resourceGroup(), siteInner.name()), (Func2)new Func2<SiteConfigResourceInner, SiteLogsConfigInner, WebApp>(){

                public WebApp call(SiteConfigResourceInner siteConfigResourceInner, SiteLogsConfigInner logsConfigInner) {
                    return WebAppsImpl.this.wrapModel(siteInner, siteConfigResourceInner, logsConfigInner);
                }
            });
        }
    };

    WebAppsImpl(AppServiceManager manager) {
        super((InnerSupportsListing)((WebSiteManagementClientImpl)((Object)manager.inner())).webApps(), (ManagerBase)manager);
    }

    public Observable<WebApp> getByResourceGroupAsync(final String groupName, final String name) {
        final WebAppsImpl self = this;
        return ((WebAppsInner)this.inner()).getByResourceGroupAsync(groupName, name).flatMap((Func1)new Func1<SiteInner, Observable<WebApp>>(){

            public Observable<WebApp> call(final SiteInner siteInner) {
                if (siteInner == null) {
                    return null;
                }
                return Observable.zip(((WebAppsInner)self.inner()).getConfigurationAsync(groupName, name), ((WebAppsInner)self.inner()).getDiagnosticLogsConfigurationAsync(groupName, name), (Func2)new Func2<SiteConfigResourceInner, SiteLogsConfigInner, WebApp>(){

                    public WebApp call(SiteConfigResourceInner siteConfigResourceInner, SiteLogsConfigInner logsConfigInner) {
                        return WebAppsImpl.this.wrapModel(siteInner, siteConfigResourceInner, logsConfigInner);
                    }
                });
            }
        });
    }

    protected WebAppImpl wrapModel(String name) {
        return new WebAppImpl(name, new SiteInner().withKind("app"), null, null, (AppServiceManager)this.manager());
    }

    protected WebAppImpl wrapModel(SiteInner inner, SiteConfigResourceInner siteConfig, SiteLogsConfigInner logConfig) {
        if (inner == null) {
            return null;
        }
        return new WebAppImpl(inner.name(), inner, siteConfig, logConfig, (AppServiceManager)this.manager());
    }

    protected WebAppImpl wrapModel(SiteInner inner) {
        return this.wrapModel(inner, null, null);
    }

    protected PagedList<WebApp> wrapList(PagedList<SiteInner> pagedList) {
        return this.converter.convert(pagedList);
    }

    public WebAppImpl define(String name) {
        return this.wrapModel(name);
    }
}

