/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.appservice.DefaultErrorResponseException;
import com.microsoft.azure.management.appservice.implementation.PageImpl;
import com.microsoft.azure.management.appservice.implementation.RecommendationInner;
import com.microsoft.azure.management.appservice.implementation.RecommendationRuleInner;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class RecommendationsInner {
    private RecommendationsService service;
    private WebSiteManagementClientImpl client;

    public RecommendationsInner(Retrofit retrofit, WebSiteManagementClientImpl client) {
        this.service = (RecommendationsService)retrofit.create(RecommendationsService.class);
        this.client = client;
    }

    public PagedList<RecommendationInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<RecommendationInner>((Page)response.body()){

            public Page<RecommendationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RecommendationsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RecommendationInner>> listAsync(ListOperationCallback<RecommendationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(String nextPageLink) {
                return RecommendationsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RecommendationInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Page<RecommendationInner>>(){

            public Page<RecommendationInner> call(ServiceResponse<Page<RecommendationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(ServiceResponse<Page<RecommendationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RecommendationsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Boolean featured = null;
        String filter = null;
        return this.service.list(this.client.subscriptionId(), featured, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecommendationsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<RecommendationInner> list(Boolean featured, String filter) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(featured, filter).toBlocking().single();
        return new PagedList<RecommendationInner>((Page)response.body()){

            public Page<RecommendationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RecommendationsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RecommendationInner>> listAsync(Boolean featured, String filter, ListOperationCallback<RecommendationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(featured, filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(String nextPageLink) {
                return RecommendationsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RecommendationInner>> listAsync(Boolean featured, String filter) {
        return this.listWithServiceResponseAsync(featured, filter).map((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Page<RecommendationInner>>(){

            public Page<RecommendationInner> call(ServiceResponse<Page<RecommendationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listWithServiceResponseAsync(Boolean featured, String filter) {
        return this.listSinglePageAsync(featured, filter).concatMap((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(ServiceResponse<Page<RecommendationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RecommendationsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listSinglePageAsync(Boolean featured, String filter) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), featured, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecommendationsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RecommendationInner>> listDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RecommendationInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public void resetAllFilters() {
        ((ServiceResponse)this.resetAllFiltersWithServiceResponseAsync().toBlocking().single()).body();
    }

    public ServiceFuture<Void> resetAllFiltersAsync(ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.resetAllFiltersWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<Void> resetAllFiltersAsync() {
        return this.resetAllFiltersWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> resetAllFiltersWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.resetAllFilters(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecommendationsInner.this.resetAllFiltersDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> resetAllFiltersDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void disableRecommendationForSubscription(String name) {
        ((ServiceResponse)this.disableRecommendationForSubscriptionWithServiceResponseAsync(name).toBlocking().single()).body();
    }

    public ServiceFuture<Void> disableRecommendationForSubscriptionAsync(String name, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.disableRecommendationForSubscriptionWithServiceResponseAsync(name), serviceCallback);
    }

    public Observable<Void> disableRecommendationForSubscriptionAsync(String name) {
        return this.disableRecommendationForSubscriptionWithServiceResponseAsync(name).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> disableRecommendationForSubscriptionWithServiceResponseAsync(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.disableRecommendationForSubscription(name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecommendationsInner.this.disableRecommendationForSubscriptionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> disableRecommendationForSubscriptionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RecommendationInner> listHistoryForHostingEnvironment(String resourceGroupName, String hostingEnvironmentName) {
        ServiceResponse response = (ServiceResponse)this.listHistoryForHostingEnvironmentSinglePageAsync(resourceGroupName, hostingEnvironmentName).toBlocking().single();
        return new PagedList<RecommendationInner>((Page)response.body()){

            public Page<RecommendationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RecommendationsInner.this.listHistoryForHostingEnvironmentNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RecommendationInner>> listHistoryForHostingEnvironmentAsync(String resourceGroupName, String hostingEnvironmentName, ListOperationCallback<RecommendationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listHistoryForHostingEnvironmentSinglePageAsync(resourceGroupName, hostingEnvironmentName), (Func1)new Func1<String, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(String nextPageLink) {
                return RecommendationsInner.this.listHistoryForHostingEnvironmentNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RecommendationInner>> listHistoryForHostingEnvironmentAsync(String resourceGroupName, String hostingEnvironmentName) {
        return this.listHistoryForHostingEnvironmentWithServiceResponseAsync(resourceGroupName, hostingEnvironmentName).map((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Page<RecommendationInner>>(){

            public Page<RecommendationInner> call(ServiceResponse<Page<RecommendationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listHistoryForHostingEnvironmentWithServiceResponseAsync(String resourceGroupName, String hostingEnvironmentName) {
        return this.listHistoryForHostingEnvironmentSinglePageAsync(resourceGroupName, hostingEnvironmentName).concatMap((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(ServiceResponse<Page<RecommendationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RecommendationsInner.this.listHistoryForHostingEnvironmentNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listHistoryForHostingEnvironmentSinglePageAsync(String resourceGroupName, String hostingEnvironmentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostingEnvironmentName == null) {
            throw new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Boolean expiredOnly = null;
        String filter = null;
        return this.service.listHistoryForHostingEnvironment(resourceGroupName, hostingEnvironmentName, this.client.subscriptionId(), expiredOnly, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecommendationsInner.this.listHistoryForHostingEnvironmentDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<RecommendationInner> listHistoryForHostingEnvironment(String resourceGroupName, String hostingEnvironmentName, Boolean expiredOnly, String filter) {
        ServiceResponse response = (ServiceResponse)this.listHistoryForHostingEnvironmentSinglePageAsync(resourceGroupName, hostingEnvironmentName, expiredOnly, filter).toBlocking().single();
        return new PagedList<RecommendationInner>((Page)response.body()){

            public Page<RecommendationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RecommendationsInner.this.listHistoryForHostingEnvironmentNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RecommendationInner>> listHistoryForHostingEnvironmentAsync(String resourceGroupName, String hostingEnvironmentName, Boolean expiredOnly, String filter, ListOperationCallback<RecommendationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listHistoryForHostingEnvironmentSinglePageAsync(resourceGroupName, hostingEnvironmentName, expiredOnly, filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(String nextPageLink) {
                return RecommendationsInner.this.listHistoryForHostingEnvironmentNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RecommendationInner>> listHistoryForHostingEnvironmentAsync(String resourceGroupName, String hostingEnvironmentName, Boolean expiredOnly, String filter) {
        return this.listHistoryForHostingEnvironmentWithServiceResponseAsync(resourceGroupName, hostingEnvironmentName, expiredOnly, filter).map((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Page<RecommendationInner>>(){

            public Page<RecommendationInner> call(ServiceResponse<Page<RecommendationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listHistoryForHostingEnvironmentWithServiceResponseAsync(String resourceGroupName, String hostingEnvironmentName, Boolean expiredOnly, String filter) {
        return this.listHistoryForHostingEnvironmentSinglePageAsync(resourceGroupName, hostingEnvironmentName, expiredOnly, filter).concatMap((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(ServiceResponse<Page<RecommendationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RecommendationsInner.this.listHistoryForHostingEnvironmentNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listHistoryForHostingEnvironmentSinglePageAsync(String resourceGroupName, String hostingEnvironmentName, Boolean expiredOnly, String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostingEnvironmentName == null) {
            throw new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listHistoryForHostingEnvironment(resourceGroupName, hostingEnvironmentName, this.client.subscriptionId(), expiredOnly, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecommendationsInner.this.listHistoryForHostingEnvironmentDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RecommendationInner>> listHistoryForHostingEnvironmentDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RecommendationInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<RecommendationInner> listRecommendedRulesForHostingEnvironment(String resourceGroupName, String hostingEnvironmentName) {
        ServiceResponse response = (ServiceResponse)this.listRecommendedRulesForHostingEnvironmentSinglePageAsync(resourceGroupName, hostingEnvironmentName).toBlocking().single();
        return new PagedList<RecommendationInner>((Page)response.body()){

            public Page<RecommendationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RecommendationsInner.this.listRecommendedRulesForHostingEnvironmentNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RecommendationInner>> listRecommendedRulesForHostingEnvironmentAsync(String resourceGroupName, String hostingEnvironmentName, ListOperationCallback<RecommendationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listRecommendedRulesForHostingEnvironmentSinglePageAsync(resourceGroupName, hostingEnvironmentName), (Func1)new Func1<String, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(String nextPageLink) {
                return RecommendationsInner.this.listRecommendedRulesForHostingEnvironmentNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RecommendationInner>> listRecommendedRulesForHostingEnvironmentAsync(String resourceGroupName, String hostingEnvironmentName) {
        return this.listRecommendedRulesForHostingEnvironmentWithServiceResponseAsync(resourceGroupName, hostingEnvironmentName).map((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Page<RecommendationInner>>(){

            public Page<RecommendationInner> call(ServiceResponse<Page<RecommendationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listRecommendedRulesForHostingEnvironmentWithServiceResponseAsync(String resourceGroupName, String hostingEnvironmentName) {
        return this.listRecommendedRulesForHostingEnvironmentSinglePageAsync(resourceGroupName, hostingEnvironmentName).concatMap((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(ServiceResponse<Page<RecommendationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RecommendationsInner.this.listRecommendedRulesForHostingEnvironmentNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listRecommendedRulesForHostingEnvironmentSinglePageAsync(String resourceGroupName, String hostingEnvironmentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostingEnvironmentName == null) {
            throw new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Boolean featured = null;
        String filter = null;
        return this.service.listRecommendedRulesForHostingEnvironment(resourceGroupName, hostingEnvironmentName, this.client.subscriptionId(), featured, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecommendationsInner.this.listRecommendedRulesForHostingEnvironmentDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<RecommendationInner> listRecommendedRulesForHostingEnvironment(String resourceGroupName, String hostingEnvironmentName, Boolean featured, String filter) {
        ServiceResponse response = (ServiceResponse)this.listRecommendedRulesForHostingEnvironmentSinglePageAsync(resourceGroupName, hostingEnvironmentName, featured, filter).toBlocking().single();
        return new PagedList<RecommendationInner>((Page)response.body()){

            public Page<RecommendationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RecommendationsInner.this.listRecommendedRulesForHostingEnvironmentNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RecommendationInner>> listRecommendedRulesForHostingEnvironmentAsync(String resourceGroupName, String hostingEnvironmentName, Boolean featured, String filter, ListOperationCallback<RecommendationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listRecommendedRulesForHostingEnvironmentSinglePageAsync(resourceGroupName, hostingEnvironmentName, featured, filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(String nextPageLink) {
                return RecommendationsInner.this.listRecommendedRulesForHostingEnvironmentNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RecommendationInner>> listRecommendedRulesForHostingEnvironmentAsync(String resourceGroupName, String hostingEnvironmentName, Boolean featured, String filter) {
        return this.listRecommendedRulesForHostingEnvironmentWithServiceResponseAsync(resourceGroupName, hostingEnvironmentName, featured, filter).map((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Page<RecommendationInner>>(){

            public Page<RecommendationInner> call(ServiceResponse<Page<RecommendationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listRecommendedRulesForHostingEnvironmentWithServiceResponseAsync(String resourceGroupName, String hostingEnvironmentName, Boolean featured, String filter) {
        return this.listRecommendedRulesForHostingEnvironmentSinglePageAsync(resourceGroupName, hostingEnvironmentName, featured, filter).concatMap((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(ServiceResponse<Page<RecommendationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RecommendationsInner.this.listRecommendedRulesForHostingEnvironmentNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listRecommendedRulesForHostingEnvironmentSinglePageAsync(String resourceGroupName, String hostingEnvironmentName, Boolean featured, String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostingEnvironmentName == null) {
            throw new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listRecommendedRulesForHostingEnvironment(resourceGroupName, hostingEnvironmentName, this.client.subscriptionId(), featured, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecommendationsInner.this.listRecommendedRulesForHostingEnvironmentDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RecommendationInner>> listRecommendedRulesForHostingEnvironmentDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RecommendationInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public void disableAllForHostingEnvironment(String resourceGroupName, String hostingEnvironmentName, String environmentName) {
        ((ServiceResponse)this.disableAllForHostingEnvironmentWithServiceResponseAsync(resourceGroupName, hostingEnvironmentName, environmentName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> disableAllForHostingEnvironmentAsync(String resourceGroupName, String hostingEnvironmentName, String environmentName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.disableAllForHostingEnvironmentWithServiceResponseAsync(resourceGroupName, hostingEnvironmentName, environmentName), serviceCallback);
    }

    public Observable<Void> disableAllForHostingEnvironmentAsync(String resourceGroupName, String hostingEnvironmentName, String environmentName) {
        return this.disableAllForHostingEnvironmentWithServiceResponseAsync(resourceGroupName, hostingEnvironmentName, environmentName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> disableAllForHostingEnvironmentWithServiceResponseAsync(String resourceGroupName, String hostingEnvironmentName, String environmentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostingEnvironmentName == null) {
            throw new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (environmentName == null) {
            throw new IllegalArgumentException("Parameter environmentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.disableAllForHostingEnvironment(resourceGroupName, hostingEnvironmentName, this.client.subscriptionId(), environmentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecommendationsInner.this.disableAllForHostingEnvironmentDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> disableAllForHostingEnvironmentDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void resetAllFiltersForHostingEnvironment(String resourceGroupName, String hostingEnvironmentName, String environmentName) {
        ((ServiceResponse)this.resetAllFiltersForHostingEnvironmentWithServiceResponseAsync(resourceGroupName, hostingEnvironmentName, environmentName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> resetAllFiltersForHostingEnvironmentAsync(String resourceGroupName, String hostingEnvironmentName, String environmentName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.resetAllFiltersForHostingEnvironmentWithServiceResponseAsync(resourceGroupName, hostingEnvironmentName, environmentName), serviceCallback);
    }

    public Observable<Void> resetAllFiltersForHostingEnvironmentAsync(String resourceGroupName, String hostingEnvironmentName, String environmentName) {
        return this.resetAllFiltersForHostingEnvironmentWithServiceResponseAsync(resourceGroupName, hostingEnvironmentName, environmentName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> resetAllFiltersForHostingEnvironmentWithServiceResponseAsync(String resourceGroupName, String hostingEnvironmentName, String environmentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostingEnvironmentName == null) {
            throw new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (environmentName == null) {
            throw new IllegalArgumentException("Parameter environmentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.resetAllFiltersForHostingEnvironment(resourceGroupName, hostingEnvironmentName, this.client.subscriptionId(), environmentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecommendationsInner.this.resetAllFiltersForHostingEnvironmentDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> resetAllFiltersForHostingEnvironmentDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RecommendationRuleInner getRuleDetailsByHostingEnvironment(String resourceGroupName, String hostingEnvironmentName, String name) {
        return (RecommendationRuleInner)((Object)((ServiceResponse)this.getRuleDetailsByHostingEnvironmentWithServiceResponseAsync(resourceGroupName, hostingEnvironmentName, name).toBlocking().single()).body());
    }

    public ServiceFuture<RecommendationRuleInner> getRuleDetailsByHostingEnvironmentAsync(String resourceGroupName, String hostingEnvironmentName, String name, ServiceCallback<RecommendationRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getRuleDetailsByHostingEnvironmentWithServiceResponseAsync(resourceGroupName, hostingEnvironmentName, name), serviceCallback);
    }

    public Observable<RecommendationRuleInner> getRuleDetailsByHostingEnvironmentAsync(String resourceGroupName, String hostingEnvironmentName, String name) {
        return this.getRuleDetailsByHostingEnvironmentWithServiceResponseAsync(resourceGroupName, hostingEnvironmentName, name).map((Func1)new Func1<ServiceResponse<RecommendationRuleInner>, RecommendationRuleInner>(){

            public RecommendationRuleInner call(ServiceResponse<RecommendationRuleInner> response) {
                return (RecommendationRuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RecommendationRuleInner>> getRuleDetailsByHostingEnvironmentWithServiceResponseAsync(String resourceGroupName, String hostingEnvironmentName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostingEnvironmentName == null) {
            throw new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Boolean updateSeen = null;
        String recommendationId = null;
        return this.service.getRuleDetailsByHostingEnvironment(resourceGroupName, hostingEnvironmentName, name, this.client.subscriptionId(), updateSeen, recommendationId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RecommendationRuleInner>>>(){

            public Observable<ServiceResponse<RecommendationRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecommendationsInner.this.getRuleDetailsByHostingEnvironmentDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public RecommendationRuleInner getRuleDetailsByHostingEnvironment(String resourceGroupName, String hostingEnvironmentName, String name, Boolean updateSeen, String recommendationId) {
        return (RecommendationRuleInner)((Object)((ServiceResponse)this.getRuleDetailsByHostingEnvironmentWithServiceResponseAsync(resourceGroupName, hostingEnvironmentName, name, updateSeen, recommendationId).toBlocking().single()).body());
    }

    public ServiceFuture<RecommendationRuleInner> getRuleDetailsByHostingEnvironmentAsync(String resourceGroupName, String hostingEnvironmentName, String name, Boolean updateSeen, String recommendationId, ServiceCallback<RecommendationRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getRuleDetailsByHostingEnvironmentWithServiceResponseAsync(resourceGroupName, hostingEnvironmentName, name, updateSeen, recommendationId), serviceCallback);
    }

    public Observable<RecommendationRuleInner> getRuleDetailsByHostingEnvironmentAsync(String resourceGroupName, String hostingEnvironmentName, String name, Boolean updateSeen, String recommendationId) {
        return this.getRuleDetailsByHostingEnvironmentWithServiceResponseAsync(resourceGroupName, hostingEnvironmentName, name, updateSeen, recommendationId).map((Func1)new Func1<ServiceResponse<RecommendationRuleInner>, RecommendationRuleInner>(){

            public RecommendationRuleInner call(ServiceResponse<RecommendationRuleInner> response) {
                return (RecommendationRuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RecommendationRuleInner>> getRuleDetailsByHostingEnvironmentWithServiceResponseAsync(String resourceGroupName, String hostingEnvironmentName, String name, Boolean updateSeen, String recommendationId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostingEnvironmentName == null) {
            throw new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getRuleDetailsByHostingEnvironment(resourceGroupName, hostingEnvironmentName, name, this.client.subscriptionId(), updateSeen, recommendationId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RecommendationRuleInner>>>(){

            public Observable<ServiceResponse<RecommendationRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecommendationsInner.this.getRuleDetailsByHostingEnvironmentDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RecommendationRuleInner> getRuleDetailsByHostingEnvironmentDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RecommendationRuleInner>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public void disableRecommendationForHostingEnvironment(String resourceGroupName, String name, String hostingEnvironmentName, String environmentName) {
        ((ServiceResponse)this.disableRecommendationForHostingEnvironmentWithServiceResponseAsync(resourceGroupName, name, hostingEnvironmentName, environmentName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> disableRecommendationForHostingEnvironmentAsync(String resourceGroupName, String name, String hostingEnvironmentName, String environmentName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.disableRecommendationForHostingEnvironmentWithServiceResponseAsync(resourceGroupName, name, hostingEnvironmentName, environmentName), serviceCallback);
    }

    public Observable<Void> disableRecommendationForHostingEnvironmentAsync(String resourceGroupName, String name, String hostingEnvironmentName, String environmentName) {
        return this.disableRecommendationForHostingEnvironmentWithServiceResponseAsync(resourceGroupName, name, hostingEnvironmentName, environmentName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> disableRecommendationForHostingEnvironmentWithServiceResponseAsync(String resourceGroupName, String name, String hostingEnvironmentName, String environmentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (hostingEnvironmentName == null) {
            throw new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (environmentName == null) {
            throw new IllegalArgumentException("Parameter environmentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.disableRecommendationForHostingEnvironment(resourceGroupName, name, hostingEnvironmentName, this.client.subscriptionId(), environmentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecommendationsInner.this.disableRecommendationForHostingEnvironmentDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> disableRecommendationForHostingEnvironmentDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RecommendationInner> listHistoryForWebApp(String resourceGroupName, String siteName) {
        ServiceResponse response = (ServiceResponse)this.listHistoryForWebAppSinglePageAsync(resourceGroupName, siteName).toBlocking().single();
        return new PagedList<RecommendationInner>((Page)response.body()){

            public Page<RecommendationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RecommendationsInner.this.listHistoryForWebAppNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RecommendationInner>> listHistoryForWebAppAsync(String resourceGroupName, String siteName, ListOperationCallback<RecommendationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listHistoryForWebAppSinglePageAsync(resourceGroupName, siteName), (Func1)new Func1<String, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(String nextPageLink) {
                return RecommendationsInner.this.listHistoryForWebAppNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RecommendationInner>> listHistoryForWebAppAsync(String resourceGroupName, String siteName) {
        return this.listHistoryForWebAppWithServiceResponseAsync(resourceGroupName, siteName).map((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Page<RecommendationInner>>(){

            public Page<RecommendationInner> call(ServiceResponse<Page<RecommendationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listHistoryForWebAppWithServiceResponseAsync(String resourceGroupName, String siteName) {
        return this.listHistoryForWebAppSinglePageAsync(resourceGroupName, siteName).concatMap((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(ServiceResponse<Page<RecommendationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RecommendationsInner.this.listHistoryForWebAppNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listHistoryForWebAppSinglePageAsync(String resourceGroupName, String siteName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Boolean expiredOnly = null;
        String filter = null;
        return this.service.listHistoryForWebApp(resourceGroupName, siteName, this.client.subscriptionId(), expiredOnly, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecommendationsInner.this.listHistoryForWebAppDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<RecommendationInner> listHistoryForWebApp(String resourceGroupName, String siteName, Boolean expiredOnly, String filter) {
        ServiceResponse response = (ServiceResponse)this.listHistoryForWebAppSinglePageAsync(resourceGroupName, siteName, expiredOnly, filter).toBlocking().single();
        return new PagedList<RecommendationInner>((Page)response.body()){

            public Page<RecommendationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RecommendationsInner.this.listHistoryForWebAppNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RecommendationInner>> listHistoryForWebAppAsync(String resourceGroupName, String siteName, Boolean expiredOnly, String filter, ListOperationCallback<RecommendationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listHistoryForWebAppSinglePageAsync(resourceGroupName, siteName, expiredOnly, filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(String nextPageLink) {
                return RecommendationsInner.this.listHistoryForWebAppNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RecommendationInner>> listHistoryForWebAppAsync(String resourceGroupName, String siteName, Boolean expiredOnly, String filter) {
        return this.listHistoryForWebAppWithServiceResponseAsync(resourceGroupName, siteName, expiredOnly, filter).map((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Page<RecommendationInner>>(){

            public Page<RecommendationInner> call(ServiceResponse<Page<RecommendationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listHistoryForWebAppWithServiceResponseAsync(String resourceGroupName, String siteName, Boolean expiredOnly, String filter) {
        return this.listHistoryForWebAppSinglePageAsync(resourceGroupName, siteName, expiredOnly, filter).concatMap((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(ServiceResponse<Page<RecommendationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RecommendationsInner.this.listHistoryForWebAppNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listHistoryForWebAppSinglePageAsync(String resourceGroupName, String siteName, Boolean expiredOnly, String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listHistoryForWebApp(resourceGroupName, siteName, this.client.subscriptionId(), expiredOnly, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecommendationsInner.this.listHistoryForWebAppDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RecommendationInner>> listHistoryForWebAppDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RecommendationInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<RecommendationInner> listRecommendedRulesForWebApp(String resourceGroupName, String siteName) {
        ServiceResponse response = (ServiceResponse)this.listRecommendedRulesForWebAppSinglePageAsync(resourceGroupName, siteName).toBlocking().single();
        return new PagedList<RecommendationInner>((Page)response.body()){

            public Page<RecommendationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RecommendationsInner.this.listRecommendedRulesForWebAppNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RecommendationInner>> listRecommendedRulesForWebAppAsync(String resourceGroupName, String siteName, ListOperationCallback<RecommendationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listRecommendedRulesForWebAppSinglePageAsync(resourceGroupName, siteName), (Func1)new Func1<String, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(String nextPageLink) {
                return RecommendationsInner.this.listRecommendedRulesForWebAppNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RecommendationInner>> listRecommendedRulesForWebAppAsync(String resourceGroupName, String siteName) {
        return this.listRecommendedRulesForWebAppWithServiceResponseAsync(resourceGroupName, siteName).map((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Page<RecommendationInner>>(){

            public Page<RecommendationInner> call(ServiceResponse<Page<RecommendationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listRecommendedRulesForWebAppWithServiceResponseAsync(String resourceGroupName, String siteName) {
        return this.listRecommendedRulesForWebAppSinglePageAsync(resourceGroupName, siteName).concatMap((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(ServiceResponse<Page<RecommendationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RecommendationsInner.this.listRecommendedRulesForWebAppNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listRecommendedRulesForWebAppSinglePageAsync(String resourceGroupName, String siteName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Boolean featured = null;
        String filter = null;
        return this.service.listRecommendedRulesForWebApp(resourceGroupName, siteName, this.client.subscriptionId(), featured, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecommendationsInner.this.listRecommendedRulesForWebAppDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<RecommendationInner> listRecommendedRulesForWebApp(String resourceGroupName, String siteName, Boolean featured, String filter) {
        ServiceResponse response = (ServiceResponse)this.listRecommendedRulesForWebAppSinglePageAsync(resourceGroupName, siteName, featured, filter).toBlocking().single();
        return new PagedList<RecommendationInner>((Page)response.body()){

            public Page<RecommendationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RecommendationsInner.this.listRecommendedRulesForWebAppNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RecommendationInner>> listRecommendedRulesForWebAppAsync(String resourceGroupName, String siteName, Boolean featured, String filter, ListOperationCallback<RecommendationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listRecommendedRulesForWebAppSinglePageAsync(resourceGroupName, siteName, featured, filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(String nextPageLink) {
                return RecommendationsInner.this.listRecommendedRulesForWebAppNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RecommendationInner>> listRecommendedRulesForWebAppAsync(String resourceGroupName, String siteName, Boolean featured, String filter) {
        return this.listRecommendedRulesForWebAppWithServiceResponseAsync(resourceGroupName, siteName, featured, filter).map((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Page<RecommendationInner>>(){

            public Page<RecommendationInner> call(ServiceResponse<Page<RecommendationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listRecommendedRulesForWebAppWithServiceResponseAsync(String resourceGroupName, String siteName, Boolean featured, String filter) {
        return this.listRecommendedRulesForWebAppSinglePageAsync(resourceGroupName, siteName, featured, filter).concatMap((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(ServiceResponse<Page<RecommendationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RecommendationsInner.this.listRecommendedRulesForWebAppNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listRecommendedRulesForWebAppSinglePageAsync(String resourceGroupName, String siteName, Boolean featured, String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listRecommendedRulesForWebApp(resourceGroupName, siteName, this.client.subscriptionId(), featured, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecommendationsInner.this.listRecommendedRulesForWebAppDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RecommendationInner>> listRecommendedRulesForWebAppDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RecommendationInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public void disableAllForWebApp(String resourceGroupName, String siteName) {
        ((ServiceResponse)this.disableAllForWebAppWithServiceResponseAsync(resourceGroupName, siteName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> disableAllForWebAppAsync(String resourceGroupName, String siteName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.disableAllForWebAppWithServiceResponseAsync(resourceGroupName, siteName), serviceCallback);
    }

    public Observable<Void> disableAllForWebAppAsync(String resourceGroupName, String siteName) {
        return this.disableAllForWebAppWithServiceResponseAsync(resourceGroupName, siteName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> disableAllForWebAppWithServiceResponseAsync(String resourceGroupName, String siteName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.disableAllForWebApp(resourceGroupName, siteName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecommendationsInner.this.disableAllForWebAppDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> disableAllForWebAppDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void resetAllFiltersForWebApp(String resourceGroupName, String siteName) {
        ((ServiceResponse)this.resetAllFiltersForWebAppWithServiceResponseAsync(resourceGroupName, siteName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> resetAllFiltersForWebAppAsync(String resourceGroupName, String siteName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.resetAllFiltersForWebAppWithServiceResponseAsync(resourceGroupName, siteName), serviceCallback);
    }

    public Observable<Void> resetAllFiltersForWebAppAsync(String resourceGroupName, String siteName) {
        return this.resetAllFiltersForWebAppWithServiceResponseAsync(resourceGroupName, siteName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> resetAllFiltersForWebAppWithServiceResponseAsync(String resourceGroupName, String siteName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.resetAllFiltersForWebApp(resourceGroupName, siteName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecommendationsInner.this.resetAllFiltersForWebAppDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> resetAllFiltersForWebAppDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RecommendationRuleInner getRuleDetailsByWebApp(String resourceGroupName, String siteName, String name) {
        return (RecommendationRuleInner)((Object)((ServiceResponse)this.getRuleDetailsByWebAppWithServiceResponseAsync(resourceGroupName, siteName, name).toBlocking().single()).body());
    }

    public ServiceFuture<RecommendationRuleInner> getRuleDetailsByWebAppAsync(String resourceGroupName, String siteName, String name, ServiceCallback<RecommendationRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getRuleDetailsByWebAppWithServiceResponseAsync(resourceGroupName, siteName, name), serviceCallback);
    }

    public Observable<RecommendationRuleInner> getRuleDetailsByWebAppAsync(String resourceGroupName, String siteName, String name) {
        return this.getRuleDetailsByWebAppWithServiceResponseAsync(resourceGroupName, siteName, name).map((Func1)new Func1<ServiceResponse<RecommendationRuleInner>, RecommendationRuleInner>(){

            public RecommendationRuleInner call(ServiceResponse<RecommendationRuleInner> response) {
                return (RecommendationRuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RecommendationRuleInner>> getRuleDetailsByWebAppWithServiceResponseAsync(String resourceGroupName, String siteName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Boolean updateSeen = null;
        String recommendationId = null;
        return this.service.getRuleDetailsByWebApp(resourceGroupName, siteName, name, this.client.subscriptionId(), updateSeen, recommendationId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RecommendationRuleInner>>>(){

            public Observable<ServiceResponse<RecommendationRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecommendationsInner.this.getRuleDetailsByWebAppDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public RecommendationRuleInner getRuleDetailsByWebApp(String resourceGroupName, String siteName, String name, Boolean updateSeen, String recommendationId) {
        return (RecommendationRuleInner)((Object)((ServiceResponse)this.getRuleDetailsByWebAppWithServiceResponseAsync(resourceGroupName, siteName, name, updateSeen, recommendationId).toBlocking().single()).body());
    }

    public ServiceFuture<RecommendationRuleInner> getRuleDetailsByWebAppAsync(String resourceGroupName, String siteName, String name, Boolean updateSeen, String recommendationId, ServiceCallback<RecommendationRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getRuleDetailsByWebAppWithServiceResponseAsync(resourceGroupName, siteName, name, updateSeen, recommendationId), serviceCallback);
    }

    public Observable<RecommendationRuleInner> getRuleDetailsByWebAppAsync(String resourceGroupName, String siteName, String name, Boolean updateSeen, String recommendationId) {
        return this.getRuleDetailsByWebAppWithServiceResponseAsync(resourceGroupName, siteName, name, updateSeen, recommendationId).map((Func1)new Func1<ServiceResponse<RecommendationRuleInner>, RecommendationRuleInner>(){

            public RecommendationRuleInner call(ServiceResponse<RecommendationRuleInner> response) {
                return (RecommendationRuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RecommendationRuleInner>> getRuleDetailsByWebAppWithServiceResponseAsync(String resourceGroupName, String siteName, String name, Boolean updateSeen, String recommendationId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getRuleDetailsByWebApp(resourceGroupName, siteName, name, this.client.subscriptionId(), updateSeen, recommendationId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RecommendationRuleInner>>>(){

            public Observable<ServiceResponse<RecommendationRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecommendationsInner.this.getRuleDetailsByWebAppDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RecommendationRuleInner> getRuleDetailsByWebAppDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RecommendationRuleInner>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public void disableRecommendationForSite(String resourceGroupName, String siteName, String name) {
        ((ServiceResponse)this.disableRecommendationForSiteWithServiceResponseAsync(resourceGroupName, siteName, name).toBlocking().single()).body();
    }

    public ServiceFuture<Void> disableRecommendationForSiteAsync(String resourceGroupName, String siteName, String name, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.disableRecommendationForSiteWithServiceResponseAsync(resourceGroupName, siteName, name), serviceCallback);
    }

    public Observable<Void> disableRecommendationForSiteAsync(String resourceGroupName, String siteName, String name) {
        return this.disableRecommendationForSiteWithServiceResponseAsync(resourceGroupName, siteName, name).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> disableRecommendationForSiteWithServiceResponseAsync(String resourceGroupName, String siteName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.disableRecommendationForSite(resourceGroupName, siteName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecommendationsInner.this.disableRecommendationForSiteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> disableRecommendationForSiteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RecommendationInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RecommendationInner>((Page)response.body()){

            public Page<RecommendationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RecommendationsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RecommendationInner>> listNextAsync(String nextPageLink, ServiceFuture<List<RecommendationInner>> serviceFuture, ListOperationCallback<RecommendationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(String nextPageLink) {
                return RecommendationsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RecommendationInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Page<RecommendationInner>>(){

            public Page<RecommendationInner> call(ServiceResponse<Page<RecommendationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(ServiceResponse<Page<RecommendationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RecommendationsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecommendationsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RecommendationInner>> listNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RecommendationInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<RecommendationInner> listHistoryForHostingEnvironmentNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listHistoryForHostingEnvironmentNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RecommendationInner>((Page)response.body()){

            public Page<RecommendationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RecommendationsInner.this.listHistoryForHostingEnvironmentNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RecommendationInner>> listHistoryForHostingEnvironmentNextAsync(String nextPageLink, ServiceFuture<List<RecommendationInner>> serviceFuture, ListOperationCallback<RecommendationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listHistoryForHostingEnvironmentNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(String nextPageLink) {
                return RecommendationsInner.this.listHistoryForHostingEnvironmentNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RecommendationInner>> listHistoryForHostingEnvironmentNextAsync(String nextPageLink) {
        return this.listHistoryForHostingEnvironmentNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Page<RecommendationInner>>(){

            public Page<RecommendationInner> call(ServiceResponse<Page<RecommendationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listHistoryForHostingEnvironmentNextWithServiceResponseAsync(String nextPageLink) {
        return this.listHistoryForHostingEnvironmentNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(ServiceResponse<Page<RecommendationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RecommendationsInner.this.listHistoryForHostingEnvironmentNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listHistoryForHostingEnvironmentNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listHistoryForHostingEnvironmentNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecommendationsInner.this.listHistoryForHostingEnvironmentNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RecommendationInner>> listHistoryForHostingEnvironmentNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RecommendationInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<RecommendationInner> listRecommendedRulesForHostingEnvironmentNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listRecommendedRulesForHostingEnvironmentNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RecommendationInner>((Page)response.body()){

            public Page<RecommendationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RecommendationsInner.this.listRecommendedRulesForHostingEnvironmentNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RecommendationInner>> listRecommendedRulesForHostingEnvironmentNextAsync(String nextPageLink, ServiceFuture<List<RecommendationInner>> serviceFuture, ListOperationCallback<RecommendationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listRecommendedRulesForHostingEnvironmentNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(String nextPageLink) {
                return RecommendationsInner.this.listRecommendedRulesForHostingEnvironmentNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RecommendationInner>> listRecommendedRulesForHostingEnvironmentNextAsync(String nextPageLink) {
        return this.listRecommendedRulesForHostingEnvironmentNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Page<RecommendationInner>>(){

            public Page<RecommendationInner> call(ServiceResponse<Page<RecommendationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listRecommendedRulesForHostingEnvironmentNextWithServiceResponseAsync(String nextPageLink) {
        return this.listRecommendedRulesForHostingEnvironmentNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(ServiceResponse<Page<RecommendationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RecommendationsInner.this.listRecommendedRulesForHostingEnvironmentNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listRecommendedRulesForHostingEnvironmentNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listRecommendedRulesForHostingEnvironmentNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecommendationsInner.this.listRecommendedRulesForHostingEnvironmentNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RecommendationInner>> listRecommendedRulesForHostingEnvironmentNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RecommendationInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<RecommendationInner> listHistoryForWebAppNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listHistoryForWebAppNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RecommendationInner>((Page)response.body()){

            public Page<RecommendationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RecommendationsInner.this.listHistoryForWebAppNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RecommendationInner>> listHistoryForWebAppNextAsync(String nextPageLink, ServiceFuture<List<RecommendationInner>> serviceFuture, ListOperationCallback<RecommendationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listHistoryForWebAppNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(String nextPageLink) {
                return RecommendationsInner.this.listHistoryForWebAppNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RecommendationInner>> listHistoryForWebAppNextAsync(String nextPageLink) {
        return this.listHistoryForWebAppNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Page<RecommendationInner>>(){

            public Page<RecommendationInner> call(ServiceResponse<Page<RecommendationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listHistoryForWebAppNextWithServiceResponseAsync(String nextPageLink) {
        return this.listHistoryForWebAppNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(ServiceResponse<Page<RecommendationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RecommendationsInner.this.listHistoryForWebAppNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listHistoryForWebAppNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listHistoryForWebAppNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecommendationsInner.this.listHistoryForWebAppNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RecommendationInner>> listHistoryForWebAppNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RecommendationInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<RecommendationInner> listRecommendedRulesForWebAppNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listRecommendedRulesForWebAppNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RecommendationInner>((Page)response.body()){

            public Page<RecommendationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RecommendationsInner.this.listRecommendedRulesForWebAppNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RecommendationInner>> listRecommendedRulesForWebAppNextAsync(String nextPageLink, ServiceFuture<List<RecommendationInner>> serviceFuture, ListOperationCallback<RecommendationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listRecommendedRulesForWebAppNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(String nextPageLink) {
                return RecommendationsInner.this.listRecommendedRulesForWebAppNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RecommendationInner>> listRecommendedRulesForWebAppNextAsync(String nextPageLink) {
        return this.listRecommendedRulesForWebAppNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Page<RecommendationInner>>(){

            public Page<RecommendationInner> call(ServiceResponse<Page<RecommendationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listRecommendedRulesForWebAppNextWithServiceResponseAsync(String nextPageLink) {
        return this.listRecommendedRulesForWebAppNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RecommendationInner>>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(ServiceResponse<Page<RecommendationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RecommendationsInner.this.listRecommendedRulesForWebAppNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RecommendationInner>>> listRecommendedRulesForWebAppNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listRecommendedRulesForWebAppNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecommendationInner>>>>(){

            public Observable<ServiceResponse<Page<RecommendationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecommendationsInner.this.listRecommendedRulesForWebAppNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RecommendationInner>> listRecommendedRulesForWebAppNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RecommendationInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    static interface RecommendationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Web/recommendations")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="featured") Boolean var2, @Query(value="$filter", encoded=true) String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations resetAllFilters"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Web/recommendations/reset")
        public Observable<Response<ResponseBody>> resetAllFilters(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations disableRecommendationForSubscription"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Web/recommendations/{name}/disable")
        public Observable<Response<ResponseBody>> disableRecommendationForSubscription(@Path(value="name") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations listHistoryForHostingEnvironment"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendationHistory")
        public Observable<Response<ResponseBody>> listHistoryForHostingEnvironment(@Path(value="resourceGroupName") String var1, @Path(value="hostingEnvironmentName") String var2, @Path(value="subscriptionId") String var3, @Query(value="expiredOnly") Boolean var4, @Query(value="$filter", encoded=true) String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations listRecommendedRulesForHostingEnvironment"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendations")
        public Observable<Response<ResponseBody>> listRecommendedRulesForHostingEnvironment(@Path(value="resourceGroupName") String var1, @Path(value="hostingEnvironmentName") String var2, @Path(value="subscriptionId") String var3, @Query(value="featured") Boolean var4, @Query(value="$filter", encoded=true) String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations disableAllForHostingEnvironment"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendations/disable")
        public Observable<Response<ResponseBody>> disableAllForHostingEnvironment(@Path(value="resourceGroupName") String var1, @Path(value="hostingEnvironmentName") String var2, @Path(value="subscriptionId") String var3, @Query(value="environmentName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations resetAllFiltersForHostingEnvironment"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendations/reset")
        public Observable<Response<ResponseBody>> resetAllFiltersForHostingEnvironment(@Path(value="resourceGroupName") String var1, @Path(value="hostingEnvironmentName") String var2, @Path(value="subscriptionId") String var3, @Query(value="environmentName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations getRuleDetailsByHostingEnvironment"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendations/{name}")
        public Observable<Response<ResponseBody>> getRuleDetailsByHostingEnvironment(@Path(value="resourceGroupName") String var1, @Path(value="hostingEnvironmentName") String var2, @Path(value="name") String var3, @Path(value="subscriptionId") String var4, @Query(value="updateSeen") Boolean var5, @Query(value="recommendationId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations disableRecommendationForHostingEnvironment"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendations/{name}/disable")
        public Observable<Response<ResponseBody>> disableRecommendationForHostingEnvironment(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="hostingEnvironmentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="environmentName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations listHistoryForWebApp"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendationHistory")
        public Observable<Response<ResponseBody>> listHistoryForWebApp(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="subscriptionId") String var3, @Query(value="expiredOnly") Boolean var4, @Query(value="$filter", encoded=true) String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations listRecommendedRulesForWebApp"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations")
        public Observable<Response<ResponseBody>> listRecommendedRulesForWebApp(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="subscriptionId") String var3, @Query(value="featured") Boolean var4, @Query(value="$filter", encoded=true) String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations disableAllForWebApp"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/disable")
        public Observable<Response<ResponseBody>> disableAllForWebApp(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations resetAllFiltersForWebApp"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/reset")
        public Observable<Response<ResponseBody>> resetAllFiltersForWebApp(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations getRuleDetailsByWebApp"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/{name}")
        public Observable<Response<ResponseBody>> getRuleDetailsByWebApp(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="name") String var3, @Path(value="subscriptionId") String var4, @Query(value="updateSeen") Boolean var5, @Query(value="recommendationId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations disableRecommendationForSite"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/{name}/disable")
        public Observable<Response<ResponseBody>> disableRecommendationForSite(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="name") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations listHistoryForHostingEnvironmentNext"})
        @GET
        public Observable<Response<ResponseBody>> listHistoryForHostingEnvironmentNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations listRecommendedRulesForHostingEnvironmentNext"})
        @GET
        public Observable<Response<ResponseBody>> listRecommendedRulesForHostingEnvironmentNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations listHistoryForWebAppNext"})
        @GET
        public Observable<Response<ResponseBody>> listHistoryForWebAppNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations listRecommendedRulesForWebAppNext"})
        @GET
        public Observable<Response<ResponseBody>> listRecommendedRulesForWebAppNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

