/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.microsoft.azure.Page;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.AppSetting;
import com.microsoft.azure.management.appservice.ConnectionString;
import com.microsoft.azure.management.appservice.CsmSlotEntity;
import com.microsoft.azure.management.appservice.HostNameBinding;
import com.microsoft.azure.management.appservice.MSDeploy;
import com.microsoft.azure.management.appservice.PublishingProfile;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.management.appservice.WebAppSourceControl;
import com.microsoft.azure.management.appservice.implementation.AppServiceBaseImpl;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.ConnectionStringDictionaryInner;
import com.microsoft.azure.management.appservice.implementation.HostNameBindingImpl;
import com.microsoft.azure.management.appservice.implementation.HostNameBindingInner;
import com.microsoft.azure.management.appservice.implementation.IdentifierInner;
import com.microsoft.azure.management.appservice.implementation.MSDeployStatusInner;
import com.microsoft.azure.management.appservice.implementation.PublishingProfileImpl;
import com.microsoft.azure.management.appservice.implementation.SiteAuthSettingsInner;
import com.microsoft.azure.management.appservice.implementation.SiteConfigResourceInner;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.management.appservice.implementation.SiteLogsConfigInner;
import com.microsoft.azure.management.appservice.implementation.SiteSourceControlInner;
import com.microsoft.azure.management.appservice.implementation.SlotConfigNamesResourceInner;
import com.microsoft.azure.management.appservice.implementation.StringDictionaryInner;
import com.microsoft.azure.management.appservice.implementation.WebAppBaseImpl;
import com.microsoft.azure.management.appservice.implementation.WebAppSourceControlImpl;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import rx.Completable;
import rx.Observable;
import rx.exceptions.Exceptions;
import rx.functions.Func1;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
abstract class DeploymentSlotBaseImpl<FluentT extends WebAppBase, FluentImplT extends DeploymentSlotBaseImpl<FluentT, FluentImplT, ParentImplT, FluentWithCreateT, FluentUpdateT>, ParentImplT extends AppServiceBaseImpl<?, ?, ?, ?>, FluentWithCreateT, FluentUpdateT>
extends WebAppBaseImpl<FluentT, FluentImplT> {
    private final ParentImplT parent;
    private final String name;
    WebAppBase configurationSource;

    DeploymentSlotBaseImpl(String name, SiteInner innerObject, SiteConfigResourceInner siteConfig, SiteLogsConfigInner logConfig, ParentImplT parent) {
        super(name.replaceAll(".*/", ""), innerObject, siteConfig, logConfig, (AppServiceManager)parent.manager());
        this.name = name.replaceAll(".*/", "");
        this.parent = parent;
        ((SiteInner)((Object)this.inner())).withServerFarmId(((WebAppBaseImpl)parent).appServicePlanId());
        ((SiteInner)((Object)this.inner())).withLocation(this.regionName());
    }

    public String name() {
        return this.name;
    }

    @Override
    public Map<String, HostNameBinding> getHostNameBindings() {
        return (Map)this.getHostNameBindingsAsync().toBlocking().single();
    }

    @Override
    public Observable<Map<String, HostNameBinding>> getHostNameBindingsAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().listHostNameBindingsSlotAsync(this.resourceGroupName(), this.parent().name(), this.name()).flatMap((Func1)new Func1<Page<HostNameBindingInner>, Observable<HostNameBindingInner>>(){

            public Observable<HostNameBindingInner> call(Page<HostNameBindingInner> hostNameBindingInnerPage) {
                return Observable.from((Iterable)hostNameBindingInnerPage.items());
            }
        }).map((Func1)new Func1<HostNameBindingInner, HostNameBinding>(){

            public HostNameBinding call(HostNameBindingInner hostNameBindingInner) {
                return new HostNameBindingImpl(hostNameBindingInner, DeploymentSlotBaseImpl.this);
            }
        }).toList().map((Func1)new Func1<List<HostNameBinding>, Map<String, HostNameBinding>>(){

            public Map<String, HostNameBinding> call(List<HostNameBinding> hostNameBindings) {
                return Collections.unmodifiableMap(Maps.uniqueIndex(hostNameBindings, (Function)new Function<HostNameBinding, String>(){

                    public String apply(HostNameBinding input) {
                        return input.name().replace(DeploymentSlotBaseImpl.this.name() + "/", "");
                    }
                }));
            }
        });
    }

    @Override
    public PublishingProfile getPublishingProfile() {
        return (PublishingProfile)this.getPublishingProfileAsync().toBlocking().single();
    }

    @Override
    public Observable<PublishingProfile> getPublishingProfileAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().listPublishingProfileXmlWithSecretsSlotAsync(this.resourceGroupName(), this.parent().name(), this.name()).map((Func1)new Func1<InputStream, PublishingProfile>(){

            public PublishingProfile call(InputStream stream) {
                try {
                    String xml = CharStreams.toString((Readable)new InputStreamReader(stream));
                    return new PublishingProfileImpl(xml, DeploymentSlotBaseImpl.this);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public void start() {
        this.startAsync().toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable startAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().startSlotAsync(this.resourceGroupName(), this.parent().name(), this.name()).flatMap(new Func1<Void, Observable<?>>(){

            public Observable<?> call(Void aVoid) {
                return DeploymentSlotBaseImpl.this.refreshAsync();
            }
        }).toCompletable();
    }

    @Override
    public void stop() {
        this.stopAsync().toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable stopAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().stopSlotAsync(this.resourceGroupName(), this.parent().name(), this.name()).flatMap(new Func1<Void, Observable<?>>(){

            public Observable<?> call(Void aVoid) {
                return DeploymentSlotBaseImpl.this.refreshAsync();
            }
        }).toCompletable();
    }

    @Override
    public void restart() {
        this.restartAsync().toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable restartAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().restartSlotAsync(this.resourceGroupName(), this.parent().name(), this.name()).flatMap(new Func1<Void, Observable<?>>(){

            public Observable<?> call(Void aVoid) {
                return DeploymentSlotBaseImpl.this.refreshAsync();
            }
        }).toCompletable();
    }

    public FluentImplT withBrandNewConfiguration() {
        this.siteConfig = null;
        return (FluentImplT)this;
    }

    public FluentImplT withConfigurationFromDeploymentSlot(FluentT slot) {
        this.siteConfig = ((WebAppBaseImpl)slot).siteConfig;
        this.configurationSource = slot;
        return (FluentImplT)this;
    }

    @Override
    Observable<Indexable> submitAppSettings() {
        return Observable.just((Object)this.configurationSource).flatMap((Func1)new Func1<WebAppBase, Observable<Indexable>>(){

            public Observable<Indexable> call(WebAppBase webAppBase) {
                if (webAppBase == null || !DeploymentSlotBaseImpl.this.isInCreateMode()) {
                    return DeploymentSlotBaseImpl.super.submitAppSettings();
                }
                return webAppBase.getAppSettingsAsync().flatMap((Func1)new Func1<Map<String, AppSetting>, Observable<Indexable>>(){

                    public Observable<Indexable> call(Map<String, AppSetting> stringAppSettingMap) {
                        for (AppSetting appSetting : stringAppSettingMap.values()) {
                            if (appSetting.sticky()) {
                                DeploymentSlotBaseImpl.this.withStickyAppSetting(appSetting.key(), appSetting.value());
                                continue;
                            }
                            DeploymentSlotBaseImpl.this.withAppSetting(appSetting.key(), appSetting.value());
                        }
                        return DeploymentSlotBaseImpl.super.submitAppSettings();
                    }
                });
            }
        });
    }

    @Override
    Observable<Indexable> submitConnectionStrings() {
        return Observable.just((Object)this.configurationSource).flatMap((Func1)new Func1<WebAppBase, Observable<Indexable>>(){

            public Observable<Indexable> call(WebAppBase webAppBase) {
                if (webAppBase == null || !DeploymentSlotBaseImpl.this.isInCreateMode()) {
                    return DeploymentSlotBaseImpl.super.submitConnectionStrings();
                }
                return webAppBase.getConnectionStringsAsync().flatMap((Func1)new Func1<Map<String, ConnectionString>, Observable<Indexable>>(){

                    public Observable<Indexable> call(Map<String, ConnectionString> stringConnectionStringMap) {
                        for (ConnectionString connectionString : stringConnectionStringMap.values()) {
                            if (connectionString.sticky()) {
                                DeploymentSlotBaseImpl.this.withStickyConnectionString(connectionString.name(), connectionString.value(), connectionString.type());
                                continue;
                            }
                            DeploymentSlotBaseImpl.this.withConnectionString(connectionString.name(), connectionString.value(), connectionString.type());
                        }
                        return DeploymentSlotBaseImpl.super.submitConnectionStrings();
                    }
                });
            }
        });
    }

    public ParentImplT parent() {
        return this.parent;
    }

    @Override
    Observable<SiteInner> createOrUpdateInner(SiteInner site) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().createOrUpdateSlotAsync(this.resourceGroupName(), this.parent().name(), this.name(), site);
    }

    @Override
    Observable<SiteInner> getInner() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().getSlotAsync(this.resourceGroupName(), this.parent().name(), this.name());
    }

    @Override
    Observable<SiteConfigResourceInner> getConfigInner() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().getConfigurationSlotAsync(this.resourceGroupName(), this.parent().name(), this.name());
    }

    @Override
    Observable<SiteConfigResourceInner> createOrUpdateSiteConfig(SiteConfigResourceInner siteConfig) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().createOrUpdateConfigurationSlotAsync(this.resourceGroupName(), this.parent().name(), this.name(), siteConfig);
    }

    @Override
    Observable<Void> deleteHostNameBinding(String hostname) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().deleteHostNameBindingSlotAsync(this.resourceGroupName(), this.parent().name(), this.name(), hostname);
    }

    @Override
    Observable<StringDictionaryInner> listAppSettings() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().listApplicationSettingsSlotAsync(this.resourceGroupName(), this.parent().name(), this.name());
    }

    @Override
    Observable<StringDictionaryInner> updateAppSettings(StringDictionaryInner inner) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().updateApplicationSettingsSlotAsync(this.resourceGroupName(), this.parent().name(), this.name(), inner);
    }

    @Override
    Observable<ConnectionStringDictionaryInner> listConnectionStrings() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().listConnectionStringsSlotAsync(this.resourceGroupName(), this.parent().name(), this.name());
    }

    @Override
    Observable<ConnectionStringDictionaryInner> updateConnectionStrings(ConnectionStringDictionaryInner inner) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().updateConnectionStringsSlotAsync(this.resourceGroupName(), this.parent().name(), this.name(), inner);
    }

    @Override
    Observable<SlotConfigNamesResourceInner> listSlotConfigurations() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().listSlotConfigurationNamesAsync(this.resourceGroupName(), this.parent().name());
    }

    @Override
    Observable<SlotConfigNamesResourceInner> updateSlotConfigurations(SlotConfigNamesResourceInner inner) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().updateSlotConfigurationNamesAsync(this.resourceGroupName(), this.parent().name(), inner);
    }

    @Override
    Observable<SiteSourceControlInner> createOrUpdateSourceControl(SiteSourceControlInner inner) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().createOrUpdateSourceControlSlotAsync(this.resourceGroupName(), this.parent().name(), this.name(), inner);
    }

    @Override
    public void swap(String slotName) {
        this.swapAsync(slotName).toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable swapAsync(String slotName) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().swapSlotSlotAsync(this.resourceGroupName(), this.parent().name(), this.name(), new CsmSlotEntity().withTargetSlot(slotName)).flatMap(new Func1<Void, Observable<?>>(){

            public Observable<?> call(Void aVoid) {
                return DeploymentSlotBaseImpl.this.refreshAsync();
            }
        }).toCompletable();
    }

    @Override
    public void applySlotConfigurations(String slotName) {
        this.applySlotConfigurationsAsync(slotName).toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable applySlotConfigurationsAsync(String slotName) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().applySlotConfigurationSlotAsync(this.resourceGroupName(), this.parent().name(), this.name(), new CsmSlotEntity().withTargetSlot(slotName)).flatMap(new Func1<Void, Observable<?>>(){

            public Observable<?> call(Void aVoid) {
                return DeploymentSlotBaseImpl.this.refreshAsync();
            }
        }).toCompletable();
    }

    @Override
    public void resetSlotConfigurations() {
        this.resetSlotConfigurationsAsync().toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable resetSlotConfigurationsAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().resetSlotConfigurationSlotAsync(this.resourceGroupName(), this.parent().name(), this.name()).flatMap(new Func1<Void, Observable<?>>(){

            public Observable<?> call(Void aVoid) {
                return DeploymentSlotBaseImpl.this.refreshAsync();
            }
        }).toCompletable();
    }

    @Override
    Observable<Void> deleteSourceControl() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().deleteSourceControlSlotAsync(this.resourceGroupName(), this.parent().name(), this.name()).map((Func1)new Func1<Object, Void>(){

            public Void call(Object o) {
                return null;
            }
        });
    }

    @Override
    Observable<SiteAuthSettingsInner> updateAuthentication(SiteAuthSettingsInner inner) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().updateAuthSettingsSlotAsync(this.resourceGroupName(), this.parent().name(), this.name(), inner);
    }

    @Override
    Observable<SiteAuthSettingsInner> getAuthentication() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().getAuthSettingsSlotAsync(this.resourceGroupName(), this.parent().name(), this.name());
    }

    @Override
    Observable<MSDeployStatusInner> createMSDeploy(MSDeploy msDeployInner) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.parent().manager()).inner())).webApps().createMSDeployOperationAsync(this.parent().resourceGroupName(), this.parent().name(), msDeployInner);
    }

    @Override
    public WebAppSourceControl getSourceControl() {
        return (WebAppSourceControl)this.getSourceControlAsync().toBlocking().single();
    }

    @Override
    public Observable<WebAppSourceControl> getSourceControlAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().getSourceControlSlotAsync(this.resourceGroupName(), this.parent().name(), this.name()).map((Func1)new Func1<SiteSourceControlInner, WebAppSourceControl>(){

            public WebAppSourceControl call(SiteSourceControlInner siteSourceControlInner) {
                return new WebAppSourceControlImpl(siteSourceControlInner, DeploymentSlotBaseImpl.this);
            }
        });
    }

    @Override
    public byte[] getContainerLogs() {
        return (byte[])this.getContainerLogsAsync().toBlocking().single();
    }

    @Override
    public Observable<byte[]> getContainerLogsAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().getWebSiteContainerLogsSlotAsync(this.resourceGroupName(), this.parent().name(), this.name()).map((Func1)new Func1<InputStream, byte[]>(){

            public byte[] call(InputStream inputStream) {
                try {
                    return ByteStreams.toByteArray((InputStream)inputStream);
                }
                catch (IOException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        });
    }

    @Override
    public byte[] getContainerLogsZip() {
        return (byte[])this.getContainerLogsZipAsync().toBlocking().single();
    }

    @Override
    public Observable<byte[]> getContainerLogsZipAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().getContainerLogsZipSlotAsync(this.resourceGroupName(), this.parent().name(), this.name()).map((Func1)new Func1<InputStream, byte[]>(){

            public byte[] call(InputStream inputStream) {
                try {
                    return ByteStreams.toByteArray((InputStream)inputStream);
                }
                catch (IOException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        });
    }

    @Override
    Observable<SiteLogsConfigInner> updateDiagnosticLogsConfig(SiteLogsConfigInner siteLogsConfigInner) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().updateDiagnosticLogsConfigSlotAsync(this.resourceGroupName(), this.parent().name(), this.name(), siteLogsConfigInner);
    }

    @Override
    public void verifyDomainOwnership(String certificateOrderName, String domainVerificationToken) {
        this.verifyDomainOwnershipAsync(certificateOrderName, domainVerificationToken).toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable verifyDomainOwnershipAsync(String certificateOrderName, String domainVerificationToken) {
        IdentifierInner identifierInner = new IdentifierInner().withIdentifierId(domainVerificationToken);
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().createOrUpdateDomainOwnershipIdentifierSlotAsync(this.resourceGroupName(), this.parent().name(), this.name(), certificateOrderName, identifierInner).map((Func1)new Func1<IdentifierInner, Void>(){

            public Void call(IdentifierInner identifierInner) {
                return null;
            }
        }).toCompletable();
    }
}

