/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.requests;

import com.microsoft.azure.keyvault.models.AdministratorDetails;
import com.microsoft.azure.keyvault.models.IssuerAttributes;
import com.microsoft.azure.keyvault.models.IssuerCredentials;
import com.microsoft.azure.keyvault.models.OrganizationDetails;
import java.util.ArrayList;

public final class UpdateCertificateIssuerRequest {
    private final String vaultBaseUrl;
    private final String issuerName;
    private final String provider;
    private final IssuerCredentials credentials;
    private final OrganizationDetails organizationDetails;
    private final IssuerAttributes attributes;

    private UpdateCertificateIssuerRequest(Builder builder) {
        this.vaultBaseUrl = builder.vaultBaseUrl;
        this.issuerName = builder.issuerName;
        this.provider = builder.provider;
        this.organizationDetails = builder.organizationDetails != null ? new OrganizationDetails().withId(builder.organizationDetails.id()).withAdminDetails(new ArrayList<AdministratorDetails>(builder.organizationDetails.adminDetails())) : null;
        this.credentials = builder.credentials != null ? new IssuerCredentials().withAccountId(builder.credentials.accountId()).withPassword(builder.credentials.password()) : null;
        this.attributes = builder.attributes != null ? new IssuerAttributes().withEnabled(builder.attributes.enabled()) : null;
    }

    public String vaultBaseUrl() {
        return this.vaultBaseUrl;
    }

    public String issuerName() {
        return this.issuerName;
    }

    public String provider() {
        return this.provider;
    }

    public IssuerCredentials credentials() {
        return this.credentials;
    }

    public OrganizationDetails organizationDetails() {
        return this.organizationDetails;
    }

    public IssuerAttributes attributes() {
        return this.attributes;
    }

    public static class Builder {
        private final String vaultBaseUrl;
        private final String issuerName;
        private String provider;
        private IssuerCredentials credentials;
        private OrganizationDetails organizationDetails;
        private IssuerAttributes attributes;

        public Builder(String vaultBaseUrl, String issuerName) {
            this.vaultBaseUrl = vaultBaseUrl;
            this.issuerName = issuerName;
        }

        public Builder withProvider(String provider) {
            this.provider = provider;
            return this;
        }

        public Builder withCredentials(IssuerCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public Builder withOrganizationDetails(OrganizationDetails organizationDetails) {
            this.organizationDetails = organizationDetails;
            return this;
        }

        public Builder withAttributes(IssuerAttributes attributes) {
            this.attributes = attributes;
            return this;
        }

        public UpdateCertificateIssuerRequest build() {
            return new UpdateCertificateIssuerRequest(this);
        }
    }
}

