/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.keyvault.SecretIdentifier;
import com.microsoft.azure.keyvault.models.SecretAttributes;
import java.io.IOException;
import java.util.Map;

public class SecretBundle {
    @JsonProperty(value="value")
    private String value;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="contentType")
    private String contentType;
    @JsonProperty(value="attributes")
    private SecretAttributes attributes;
    @JsonProperty(value="tags")
    private Map<String, String> tags;
    @JsonProperty(value="kid", access=JsonProperty.Access.WRITE_ONLY)
    private String kid;
    @JsonProperty(value="managed", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean managed;

    public String value() {
        return this.value;
    }

    public SecretBundle withValue(String value) {
        this.value = value;
        return this;
    }

    public String id() {
        return this.id;
    }

    public SecretBundle withId(String id) {
        this.id = id;
        return this;
    }

    public String contentType() {
        return this.contentType;
    }

    public SecretBundle withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public SecretAttributes attributes() {
        return this.attributes;
    }

    public SecretBundle withAttributes(SecretAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public SecretBundle withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String kid() {
        return this.kid;
    }

    public Boolean managed() {
        return this.managed;
    }

    public SecretIdentifier secretIdentifier() {
        if (this.id() == null || this.id().length() == 0) {
            return null;
        }
        return new SecretIdentifier(this.id());
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonGenerationException e) {
            throw new IllegalStateException(e);
        }
        catch (JsonMappingException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

