/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.ProxyConfiguration;
import com.microsoft.azure.eventhubs.impl.AmqpConnection;
import com.microsoft.azure.eventhubs.impl.AmqpErrorCode;
import com.microsoft.azure.eventhubs.impl.StringUtil;
import com.microsoft.azure.eventhubs.impl.WebSocketConnectionHandler;
import com.microsoft.azure.proton.transport.proxy.ProxyAuthenticationType;
import com.microsoft.azure.proton.transport.proxy.ProxyHandler;
import com.microsoft.azure.proton.transport.proxy.impl.ProxyHandlerImpl;
import com.microsoft.azure.proton.transport.proxy.impl.ProxyImpl;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import org.apache.qpid.proton.amqp.transport.ConnectionError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.TransportInternal;
import org.apache.qpid.proton.engine.impl.TransportLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketProxyConnectionHandler
extends WebSocketConnectionHandler {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(WebSocketProxyConnectionHandler.class);
    private static final String PROXY_SELECTOR_HAS_BEEN_MODIFIED = "ProxySelector has been modified.";
    private final ProxyConfiguration proxyConfiguration;

    public static Boolean shouldUseProxy(String hostName) {
        Objects.requireNonNull(hostName);
        URI uri = WebSocketProxyConnectionHandler.createURIFromHostNamePort(hostName, 443);
        ProxySelector proxySelector = ProxySelector.getDefault();
        if (proxySelector == null) {
            return false;
        }
        List<Proxy> proxies = proxySelector.select(uri);
        return WebSocketProxyConnectionHandler.isProxyAddressLegal(proxies);
    }

    public WebSocketProxyConnectionHandler(AmqpConnection amqpConnection, ProxyConfiguration proxyConfiguration) {
        super(amqpConnection);
        this.proxyConfiguration = proxyConfiguration;
    }

    @Override
    protected void addTransportLayers(Event event, TransportInternal transport) {
        super.addTransportLayers(event, transport);
        ProxyImpl proxy = this.proxyConfiguration != null ? new ProxyImpl(WebSocketProxyConnectionHandler.getProtonConfiguration(this.proxyConfiguration)) : new ProxyImpl();
        String hostName = event.getConnection().getHostname();
        ProxyHandlerImpl proxyHandler = new ProxyHandlerImpl();
        proxy.configure(hostName, null, (ProxyHandler)proxyHandler, (Transport)transport);
        transport.addTransportLayer((TransportLayer)proxy);
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info("addProxyHandshake: hostname[" + hostName + "]");
        }
    }

    @Override
    protected void notifyTransportErrors(Event event) {
        int port;
        boolean isProxyConfigured;
        Transport transport = event.getTransport();
        Connection connection = event.getConnection();
        if (connection == null || transport == null) {
            return;
        }
        ErrorCondition errorCondition = transport.getCondition();
        String hostName = event.getReactor().getConnectionAddress(connection);
        ProxySelector proxySelector = ProxySelector.getDefault();
        boolean bl = isProxyConfigured = proxySelector != null || this.proxyConfiguration != null && this.proxyConfiguration.isProxyAddressConfigured();
        if (errorCondition == null || !errorCondition.getCondition().equals(ConnectionError.FRAMING_ERROR) && !errorCondition.getCondition().equals(AmqpErrorCode.PROTON_IO_ERROR) || !isProxyConfigured || StringUtil.isNullOrEmpty(hostName)) {
            return;
        }
        String[] hostNameParts = hostName.split(":");
        if (hostNameParts.length != 2) {
            return;
        }
        try {
            port = Integer.parseInt(hostNameParts[1]);
        }
        catch (NumberFormatException ignore) {
            return;
        }
        IOException ioException = WebSocketProxyConnectionHandler.reconstructIOException(errorCondition);
        URI url = WebSocketProxyConnectionHandler.createURIFromHostNamePort(this.getAmqpConnection().getHostName(), this.getProtocolPort());
        InetSocketAddress address = new InetSocketAddress(hostNameParts[0], port);
        if (TRACE_LOGGER.isErrorEnabled()) {
            TRACE_LOGGER.error(String.format("Failed to connect to url: '%s', proxy host: '%s'", url.toString(), address.getHostString()), (Throwable)ioException);
        }
        if (proxySelector != null) {
            proxySelector.connectFailed(url, address, ioException);
        }
    }

    @Override
    public String getRemoteHostName() {
        InetSocketAddress socketAddress = this.getProxyAddress();
        return socketAddress.getHostString();
    }

    @Override
    public int getRemotePort() {
        InetSocketAddress socketAddress = this.getProxyAddress();
        return socketAddress.getPort();
    }

    private InetSocketAddress getProxyAddress() {
        if (this.proxyConfiguration != null && this.proxyConfiguration.isProxyAddressConfigured()) {
            return (InetSocketAddress)this.proxyConfiguration.proxyAddress().address();
        }
        URI serviceUri = WebSocketProxyConnectionHandler.createURIFromHostNamePort(this.getAmqpConnection().getHostName(), this.getProtocolPort());
        ProxySelector proxySelector = ProxySelector.getDefault();
        if (proxySelector == null) {
            throw new IllegalStateException(PROXY_SELECTOR_HAS_BEEN_MODIFIED);
        }
        List<Proxy> proxies = proxySelector.select(serviceUri);
        if (!WebSocketProxyConnectionHandler.isProxyAddressLegal(proxies)) {
            throw new IllegalStateException(PROXY_SELECTOR_HAS_BEEN_MODIFIED);
        }
        Proxy proxy = proxies.get(0);
        return (InetSocketAddress)proxy.address();
    }

    private static URI createURIFromHostNamePort(String hostName, int port) {
        return URI.create(String.format("https://%s:%s", hostName, port));
    }

    private static boolean isProxyAddressLegal(List<Proxy> proxies) {
        return proxies != null && !proxies.isEmpty() && proxies.get(0).type() == Proxy.Type.HTTP && proxies.get(0).address() != null && proxies.get(0).address() instanceof InetSocketAddress;
    }

    private static IOException reconstructIOException(ErrorCondition errorCondition) {
        return new IOException(errorCondition.getDescription());
    }

    private static com.microsoft.azure.proton.transport.proxy.ProxyConfiguration getProtonConfiguration(ProxyConfiguration configuration) {
        ProxyAuthenticationType type = WebSocketProxyConnectionHandler.getProtonAuthenticationType(configuration.authentication());
        String username = configuration.hasUserDefinedCredentials() ? configuration.credentials().getUserName() : null;
        String password = configuration.hasUserDefinedCredentials() ? new String(configuration.credentials().getPassword()) : null;
        return new com.microsoft.azure.proton.transport.proxy.ProxyConfiguration(type, configuration.proxyAddress(), username, password);
    }

    private static ProxyAuthenticationType getProtonAuthenticationType(ProxyConfiguration.ProxyAuthenticationType type) {
        switch (type) {
            case DIGEST: {
                return ProxyAuthenticationType.DIGEST;
            }
            case BASIC: {
                return ProxyAuthenticationType.BASIC;
            }
            case NONE: {
                return ProxyAuthenticationType.NONE;
            }
        }
        throw new IllegalArgumentException("This authentication type is unknown:" + type.name());
    }
}

