/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.query.executioncomponent;

import com.microsoft.azure.documentdb.Document;
import com.microsoft.azure.documentdb.Undefined;
import com.microsoft.azure.documentdb.internal.query.QueryExecutionContext;
import com.microsoft.azure.documentdb.internal.query.QueryItem;
import com.microsoft.azure.documentdb.internal.query.aggregation.AggregateOperator;
import com.microsoft.azure.documentdb.internal.query.aggregation.Aggregator;
import com.microsoft.azure.documentdb.internal.query.aggregation.AverageAggregator;
import com.microsoft.azure.documentdb.internal.query.aggregation.CountAggregator;
import com.microsoft.azure.documentdb.internal.query.aggregation.MaxAggregator;
import com.microsoft.azure.documentdb.internal.query.aggregation.MinAggregator;
import com.microsoft.azure.documentdb.internal.query.aggregation.SumAggregator;
import com.microsoft.azure.documentdb.internal.query.executioncomponent.QueryExecutionComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateQueryExecutionComponent
extends QueryExecutionComponent {
    private static Logger LOGGER = LoggerFactory.getLogger(AggregateQueryExecutionComponent.class);
    private final Aggregator[] aggregators;
    private List<Document> aggregateResults;

    public AggregateQueryExecutionComponent(QueryExecutionContext<Document> source, Collection<AggregateOperator> aggregateOperators) {
        super(source);
        this.aggregators = new Aggregator[aggregateOperators.size()];
        int index = 0;
        block7: for (AggregateOperator aggregateOperator : aggregateOperators) {
            switch (aggregateOperator) {
                case Average: {
                    this.aggregators[index] = new AverageAggregator();
                    continue block7;
                }
                case Count: {
                    this.aggregators[index] = new CountAggregator();
                    continue block7;
                }
                case Max: {
                    this.aggregators[index] = new MaxAggregator();
                    continue block7;
                }
                case Min: {
                    this.aggregators[index] = new MinAggregator();
                    continue block7;
                }
                case Sum: {
                    this.aggregators[index] = new SumAggregator();
                    continue block7;
                }
            }
            throw new IllegalStateException("Unexpected value: " + aggregateOperator.toString());
        }
    }

    @Override
    public Map<String, String> getResponseHeaders() {
        return null;
    }

    @Override
    protected Document next(Document document) {
        return document;
    }

    private void processAggregateResults() {
        this.aggregateResults = new ArrayList<Document>(this.aggregators.length);
        while (this.source.hasNext()) {
            Document doc = (Document)this.source.next();
            QueryItem queryItem = new QueryItem(doc.toString());
            for (Aggregator aggregator : this.aggregators) {
                aggregator.aggregate(queryItem.getItem());
            }
        }
        if (this.aggregators[0].getResult() == null || !this.aggregators[0].getResult().equals(Undefined.Value())) {
            Document aggregateDocument = new Document();
            aggregateDocument.set("_aggregate", this.aggregators[0].getResult());
            this.aggregateResults.add(aggregateDocument);
        }
    }

    @Override
    public Document next() {
        if (this.aggregateResults == null) {
            this.processAggregateResults();
        }
        if (this.aggregateResults.size() == 0) {
            throw new IllegalStateException("Aggregation result is empty");
        }
        return this.aggregateResults.remove(0);
    }

    @Override
    public boolean hasNext() {
        if (this.aggregateResults == null) {
            this.processAggregateResults();
        }
        return this.aggregateResults.size() > 0;
    }
}

