/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.query;

import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchScheduler {
    private final Logger logger = LoggerFactory.getLogger(FetchScheduler.class);
    private final Object lock = new Object();
    private final ExecutorCompletionService<Void> ex;
    private final LinkedList<Callable<Void>> waitList;
    private final AtomicInteger concurrencyPermit;
    private final int maxDegreeOfParallelism;
    private boolean stopped = false;

    public FetchScheduler(Executor executor, int maxDegreeOfParallelism) {
        this.maxDegreeOfParallelism = maxDegreeOfParallelism;
        LinkedBlockingQueue<Future<Void>> completedQueue = new LinkedBlockingQueue<Future<Void>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean add(Future<Void> e) {
                FetchScheduler.this.logger.trace("task Completed!");
                Object object = FetchScheduler.this.lock;
                synchronized (object) {
                    FetchScheduler.this.concurrencyPermit.incrementAndGet();
                    FetchScheduler.this.tryInvokeNext();
                }
                return super.add(e);
            }
        };
        this.ex = new ExecutorCompletionService<Void>(executor, completedQueue);
        this.waitList = new LinkedList();
        this.concurrencyPermit = new AtomicInteger(maxDegreeOfParallelism);
    }

    private boolean tryInvokeNext() {
        if (this.waitList.isEmpty() || this.stopped) {
            return false;
        }
        this.logger.trace("task invoked");
        this.ex.submit(this.waitList.removeFirst());
        this.concurrencyPermit.decrementAndGet();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Callable<Void> callable) {
        this.logger.trace("scheduling");
        Object object = this.lock;
        synchronized (object) {
            if (this.stopped) {
                this.logger.debug("already stopped won't schedule!");
                return;
            }
            this.logger.trace("number of available permits {}", (Object)this.concurrencyPermit.get());
            this.waitList.add(callable);
            if (this.concurrencyPermit.get() > 0) {
                this.tryInvokeNext();
            }
        }
    }

    public int getMaxDegreeOfParallelism() {
        return this.maxDegreeOfParallelism;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.waitList.clear();
            this.stopped = true;
        }
    }
}

