/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.DocumentClientException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class VersionUtility {
    public static boolean isLaterThan(String compareVersion, String baseVersion) throws DocumentClientException {
        Date baseVersionDate;
        Date compareVersionDate;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        try {
            compareVersionDate = formatter.parse(compareVersion);
        }
        catch (ParseException e) {
            throw new DocumentClientException(400, String.format("Invalid version format for compareVersionDate. Input Version %s", compareVersion));
        }
        try {
            baseVersionDate = formatter.parse(baseVersion);
        }
        catch (ParseException e) {
            throw new DocumentClientException(400, String.format("Invalid version format for baseVersionDate. Input Version %s", baseVersion));
        }
        return compareVersionDate.compareTo(baseVersionDate) >= 0;
    }
}

