/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.internal.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ResourceThrottleRetryPolicy
implements RetryPolicy {
    private static final long defaultRetryInSeconds = 5L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceThrottleRetryPolicy.class);
    private final int maxAttemptCount;
    private final int maxWaitTimeInMilliseconds;
    private volatile long retryAfterInMilliseconds = 0L;
    private volatile int currentAttemptCount = 0;
    private volatile int cumulativeWaitTime = 0;

    public ResourceThrottleRetryPolicy(int maxAttemptCount, int maxWaitTimeInSeconds) {
        if (maxWaitTimeInSeconds > 2147483) {
            throw new IllegalArgumentException("maxWaitTimeInSeconds must be less than 2147483");
        }
        this.maxAttemptCount = maxAttemptCount;
        this.maxWaitTimeInMilliseconds = 1000 * maxWaitTimeInSeconds;
    }

    @Override
    public long getRetryAfterInMilliseconds() {
        return this.retryAfterInMilliseconds;
    }

    @Override
    public boolean shouldRetry(DocumentClientException exception) {
        this.retryAfterInMilliseconds = 0L;
        if (this.currentAttemptCount >= this.maxAttemptCount) {
            return false;
        }
        this.retryAfterInMilliseconds = exception.getRetryAfterInMilliseconds();
        if (this.retryAfterInMilliseconds == 0L) {
            this.retryAfterInMilliseconds = 5000L;
        }
        this.cumulativeWaitTime = (int)((long)this.cumulativeWaitTime + this.retryAfterInMilliseconds);
        if (this.cumulativeWaitTime >= this.maxWaitTimeInMilliseconds) {
            return false;
        }
        LOGGER.debug("Operation will be retried after {} milliseconds. Exception: {}", (Object)this.retryAfterInMilliseconds, (Object)exception.getMessage());
        ++this.currentAttemptCount;
        return true;
    }
}

