/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.internal.ResourceThrottleRetryPolicy;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ReadTimeoutRetryPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceThrottleRetryPolicy.class);
    private final int maxAttemptCount;
    private final int maxWaitTimeInMilliseconds;
    private volatile long retryAfterInMilliseconds = 0L;
    private volatile int currentAttemptCount = 0;
    private volatile int cumulativeWaitTime = 0;

    public ReadTimeoutRetryPolicy(int maxAttemptCount, int maxWaitTimeInSeconds) {
        if (maxWaitTimeInSeconds > 2147483) {
            throw new IllegalArgumentException("maxWaitTimeInSeconds must be less than 2147483");
        }
        this.maxAttemptCount = maxAttemptCount;
        this.maxWaitTimeInMilliseconds = 1000 * maxWaitTimeInSeconds;
    }

    public long getRetryAfterInMilliseconds() {
        return this.retryAfterInMilliseconds;
    }

    public boolean shouldRetry(IllegalStateException exception) {
        this.retryAfterInMilliseconds = 0L;
        if (this.currentAttemptCount >= this.maxAttemptCount) {
            LOGGER.warn("Operation will not retried because current attempt count of {} exceeded the max attempt count of {}", new Object[]{this.currentAttemptCount, this.maxAttemptCount, exception});
            return false;
        }
        long maxRetryAfterInMilliseconds = this.currentAttemptCount * 100;
        if (maxRetryAfterInMilliseconds > 0L) {
            this.retryAfterInMilliseconds = ThreadLocalRandom.current().nextLong(maxRetryAfterInMilliseconds);
        }
        this.cumulativeWaitTime = (int)((long)this.cumulativeWaitTime + this.retryAfterInMilliseconds);
        if (this.cumulativeWaitTime >= this.maxWaitTimeInMilliseconds) {
            LOGGER.warn("Operation will not retried because current wait time of {} milliseconds exceeded the max wait time of {} milliseonds", new Object[]{this.cumulativeWaitTime, this.maxWaitTimeInMilliseconds, exception});
            return false;
        }
        LOGGER.debug("Operation will be retried after {} milliseconds. Exception: {}", (Object)this.retryAfterInMilliseconds, (Object)exception.getMessage());
        ++this.currentAttemptCount;
        return true;
    }
}

