/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.internal.AsyncLazy;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncCache<TKey, TValue> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncCache.class);
    private final ConcurrentHashMap<TKey, AsyncLazy<TValue>> values = new ConcurrentHashMap();
    private final ExecutorService executorService;

    public AsyncCache(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public Set<TKey> getKeys() {
        return this.values.keySet();
    }

    public AsyncLazy<TValue> put(TKey key, final TValue value) {
        return this.values.put(key, new AsyncLazy(new Callable<TValue>(){

            @Override
            public TValue call() throws Exception {
                return value;
            }
        }, this.executorService));
    }

    public Future<TValue> get(TKey key, TValue obsoleteValue, Callable<TValue> callable) {
        AsyncLazy<TValue> actualAsyncLazy;
        AsyncLazy<TValue> initialAsyncLazy = this.values.get(key);
        if (initialAsyncLazy != null && !initialAsyncLazy.isCancelled()) {
            try {
                if (!initialAsyncLazy.isDone() || !this.areEqual(initialAsyncLazy.getValue().get(), obsoleteValue)) {
                    LOGGER.debug("Use cache[{}], obsoleteValue: {}", key, obsoleteValue);
                    return initialAsyncLazy.getValue();
                }
            }
            catch (InterruptedException | CancellationException | ExecutionException e) {
                LOGGER.debug("Cache[{}] encountered an exception during evaluation", key, (Object)e);
            }
        }
        AsyncLazy<TValue> newAsyncLazy = new AsyncLazy<TValue>(callable, this.executorService);
        if (initialAsyncLazy == null) {
            actualAsyncLazy = this.values.putIfAbsent(key, newAsyncLazy);
            if (actualAsyncLazy == null) {
                LOGGER.debug("Add cache [{}], obsoleteValue: {}", key, obsoleteValue);
                actualAsyncLazy = newAsyncLazy;
            }
        } else if (this.values.replace(key, initialAsyncLazy, newAsyncLazy)) {
            LOGGER.debug("Replace cache [{}], obsoleteValue: {}", key, obsoleteValue);
            actualAsyncLazy = newAsyncLazy;
        } else {
            LOGGER.debug("Use cache in the end [{}], obsoleteValue: {}", key, obsoleteValue);
            actualAsyncLazy = this.values.get(key);
        }
        return actualAsyncLazy.getValue();
    }

    public AsyncLazy<TValue> remove(TKey key) {
        return this.values.remove(key);
    }

    public void clear() {
        this.values.clear();
    }

    public void refresh(TKey key, Callable<TValue> callable) {
        AsyncLazy<TValue> newAsyncLazy;
        AsyncLazy<TValue> initialAsyncLazy = this.values.get(key);
        if (initialAsyncLazy != null && initialAsyncLazy.isDone() && this.values.replace(key, initialAsyncLazy, newAsyncLazy = new AsyncLazy<TValue>(callable, this.executorService))) {
            newAsyncLazy.getValue();
        }
    }

    private boolean areEqual(TValue value1, TValue value2) {
        if (value1 == value2) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.equals(value2);
    }
}

