/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.query.executioncomponent;

import com.microsoft.azure.documentdb.Document;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.internal.query.QueryExecutionContext;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class QueryExecutionComponent
implements QueryExecutionContext<Document> {
    protected final QueryExecutionContext<Document> source;

    protected QueryExecutionComponent(QueryExecutionContext<Document> source) {
        this.source = source;
    }

    @Override
    public List<Document> fetchNextBlock() throws DocumentClientException {
        throw new UnsupportedOperationException("fetchNextBlock");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public Document next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("next");
        }
        Document document = (Document)this.source.next();
        return document == null ? document : this.next(document);
    }

    @Override
    public void onNotifyStop() {
        this.source.onNotifyStop();
    }

    protected abstract Document next(Document var1);
}

