/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.query;

import com.microsoft.azure.documentdb.Document;
import com.microsoft.azure.documentdb.DocumentQueryClientInternal;
import com.microsoft.azure.documentdb.FeedOptions;
import com.microsoft.azure.documentdb.PartitionKeyRange;
import com.microsoft.azure.documentdb.SqlQuerySpec;
import com.microsoft.azure.documentdb.internal.query.DocumentProducer;
import com.microsoft.azure.documentdb.internal.query.ExceptionHelper;
import com.microsoft.azure.documentdb.internal.query.ParallelDocumentQueryExecutionContextBase;
import com.microsoft.azure.documentdb.internal.query.PartitionedQueryExecutionInfo;
import com.microsoft.azure.documentdb.internal.query.funcs.Func1;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;

class ParallelDocumentQueryExecutionContext
extends ParallelDocumentQueryExecutionContextBase<Document> {
    private int currentDocumentProducerIndex;

    protected static ParallelDocumentQueryExecutionContext create(DocumentQueryClientInternal client, String collectionSelfLink, SqlQuerySpec querySpec, FeedOptions options, String resourceLink, PartitionedQueryExecutionInfo partitionedQueryExecutionInfo, int initialPageSize) {
        try {
            ParallelDocumentQueryExecutionContext context = new ParallelDocumentQueryExecutionContext(client, collectionSelfLink, querySpec, options, resourceLink, partitionedQueryExecutionInfo);
            Collection<PartitionKeyRange> ranges = context.getTargetPartitionKeyRanges(partitionedQueryExecutionInfo.getQueryRanges());
            context.initializationFuture = context.initializeAsync(partitionedQueryExecutionInfo, initialPageSize, Document.class, ranges, options);
            return context;
        }
        catch (Exception e) {
            throw ExceptionHelper.toRuntimeException(ExceptionHelper.unwrap(e));
        }
    }

    private ParallelDocumentQueryExecutionContext(DocumentQueryClientInternal client, String collectionSelfLink, SqlQuerySpec querySpec, FeedOptions options, String resourceLink, PartitionedQueryExecutionInfo partitionedQueryExecutionInfo) {
        super(client, collectionSelfLink, querySpec, options, resourceLink, partitionedQueryExecutionInfo, Document.class);
    }

    private boolean tryMoveNextProducer(DocumentProducer<Document> producer) throws Exception {
        final ParallelDocumentQueryExecutionContext that = this;
        return this.tryMoveNextProducer(producer, new Func1<DocumentProducer<Document>, DocumentProducer<Document>>(){

            @Override
            public DocumentProducer<Document> apply(DocumentProducer<Document> currentProducer) {
                return that.repairParallelContext(currentProducer);
            }
        });
    }

    private DocumentProducer<Document> repairParallelContext(DocumentProducer<Document> producer) {
        List<PartitionKeyRange> replacementRanges = this.getReplacementRanges(producer.getTargetRange(), this.collectionSelfLink);
        super.repairContext(this.collectionSelfLink, this.currentDocumentProducerIndex, this.defaultComparator, replacementRanges, this.querySpec);
        if (this.shouldPrefetch) {
            for (int rangeIndex = 0; rangeIndex < replacementRanges.size(); ++rangeIndex) {
                ((DocumentProducer)this.documentProducers.get(rangeIndex + this.currentDocumentProducerIndex)).tryScheduleFetch();
            }
        }
        return (DocumentProducer)this.documentProducers.get(this.currentDocumentProducerIndex);
    }

    @Override
    public Document nextInternal() throws Exception {
        Document result = null;
        while (!this.isDone()) {
            DocumentProducer currentDocumentProducer = (DocumentProducer)this.documentProducers.get(this.currentDocumentProducerIndex);
            if (result != null) break;
            if (currentDocumentProducer.peek() != null) {
                result = currentDocumentProducer.peek();
            }
            if (this.tryMoveNextProducer(currentDocumentProducer)) continue;
            ++this.currentDocumentProducerIndex;
        }
        if (this.isDone()) {
            super.onFinish();
        }
        if (this.isDone() && result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    protected boolean hasNextInternal() {
        return !this.isDone();
    }

    protected boolean isDone() {
        return this.currentDocumentProducerIndex >= this.documentProducers.size();
    }
}

