/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.DocumentClientException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorSessionToken {
    private static final Logger logger = LoggerFactory.getLogger(VectorSessionToken.class);
    private static final String SEGMENT_SEPARATOR = "#";
    private static final String REGION_PROGRESS_SEPARATOR = "=";
    private String sessionToken;
    private long version;
    private long globalLsn;
    private Map<Integer, Long> localLsnByRegion;

    public VectorSessionToken(long version, long globalLsn, Map<Integer, Long> localLsnByRegion) {
        this(version, globalLsn, localLsnByRegion, null);
    }

    public VectorSessionToken(long version, long globalLsn, Map<Integer, Long> localLsnByRegion, String sessionToken) {
        this.version = version;
        this.globalLsn = globalLsn;
        this.localLsnByRegion = localLsnByRegion;
        this.sessionToken = sessionToken;
        if (this.sessionToken == null) {
            ArrayList<String> regionAndLocalLsn = new ArrayList<String>();
            for (Map.Entry<Integer, Long> kvp : localLsnByRegion.entrySet()) {
                regionAndLocalLsn.add(kvp.getKey() + REGION_PROGRESS_SEPARATOR + kvp.getValue());
            }
            String regionProgress = String.join((CharSequence)SEGMENT_SEPARATOR, regionAndLocalLsn);
            this.sessionToken = StringUtils.isEmpty((CharSequence)regionProgress) ? String.format("%s%s%s", this.version, SEGMENT_SEPARATOR, this.globalLsn) : String.format("%s%s%s%s%s", this.version, SEGMENT_SEPARATOR, this.globalLsn, SEGMENT_SEPARATOR, regionProgress);
        }
    }

    public static VectorSessionToken create(String sessionToken) {
        Long version = null;
        Long globalLsn = null;
        if (StringUtils.isEmpty((CharSequence)sessionToken)) {
            logger.trace("Session token is empty");
            return null;
        }
        String[] segments = sessionToken.split(SEGMENT_SEPARATOR);
        if (segments.length < 2) {
            return null;
        }
        try {
            version = Long.parseLong(segments[0]);
        }
        catch (NumberFormatException e) {
            logger.trace("Unexpected session token version number '{}'", (Object)segments[0]);
            return null;
        }
        try {
            globalLsn = Long.parseLong(segments[1]);
        }
        catch (NumberFormatException e) {
            logger.trace("Unexpected global lsn '{}'", (Object)segments[1]);
            return null;
        }
        HashMap<Integer, Long> lsnByRegion = new HashMap<Integer, Long>();
        for (int i = 2; i < segments.length; ++i) {
            String regionSegment = segments[i];
            String[] regionIdWithLsn = regionSegment.split(REGION_PROGRESS_SEPARATOR);
            if (regionIdWithLsn.length != 2) {
                logger.trace("Unexpected region progress segment length '{}' in session token.", (Object)regionIdWithLsn.length);
                return null;
            }
            Integer regionId = null;
            Long localLsn = null;
            try {
                regionId = Integer.parseInt(regionIdWithLsn[0]);
                localLsn = Long.parseLong(regionIdWithLsn[1]);
            }
            catch (NumberFormatException e) {
                logger.trace("Unexpected region progress '{}' for region '{}' in session token.", (Object)regionIdWithLsn[0], (Object)regionIdWithLsn[1]);
                return null;
            }
            lsnByRegion.put(regionId, localLsn);
        }
        return new VectorSessionToken(version, globalLsn, lsnByRegion, sessionToken);
    }

    public boolean equals(VectorSessionToken other) {
        return other == null ? false : this.version == other.version && this.globalLsn == other.globalLsn && this.areRegionProgressEqual(other.localLsnByRegion);
    }

    public boolean isValid(VectorSessionToken other) throws DocumentClientException {
        if (other == null) {
            throw new IllegalArgumentException("Invalid Session Token (should not be null).");
        }
        if (other.version < this.version || other.globalLsn < this.globalLsn) {
            return false;
        }
        if (other.version == this.version && other.localLsnByRegion.size() != this.localLsnByRegion.size()) {
            throw new DocumentClientException(500, String.format("Compared session tokens '{}' and '{}' has unexpected regions.", this.sessionToken, other.sessionToken));
        }
        for (Map.Entry<Integer, Long> kvp : other.localLsnByRegion.entrySet()) {
            Integer regionId = kvp.getKey();
            long otherLocalLsn = kvp.getValue();
            Long localLsn = this.localLsnByRegion.get(regionId);
            if (localLsn == null) {
                if (this.version != other.version) continue;
                throw new DocumentClientException(500, String.format("Compared session tokens '{}' and '{}' has unexpected regions.", this.sessionToken, other.sessionToken));
            }
            if (otherLocalLsn >= localLsn) continue;
            return false;
        }
        return true;
    }

    public VectorSessionToken merge(VectorSessionToken other) throws DocumentClientException {
        VectorSessionToken sessionTokenWithHigherVersion;
        VectorSessionToken sessionTokenWithLowerVersion;
        if (other == null) {
            throw new IllegalArgumentException("Invalid Session Token (should not be null).");
        }
        if (this.version == other.version && this.localLsnByRegion.size() != other.localLsnByRegion.size()) {
            throw new DocumentClientException(500, String.format("Compared session tokens '{}' and '{}' has unexpected regions.", this.sessionToken, other.sessionToken));
        }
        if (this.version < other.version) {
            sessionTokenWithLowerVersion = this;
            sessionTokenWithHigherVersion = other;
        } else {
            sessionTokenWithLowerVersion = other;
            sessionTokenWithHigherVersion = this;
        }
        HashMap<Integer, Long> highestLocalLsnByRegion = new HashMap<Integer, Long>();
        for (Map.Entry<Integer, Long> kvp : sessionTokenWithHigherVersion.localLsnByRegion.entrySet()) {
            int regionId = kvp.getKey();
            long localLsn1 = kvp.getValue();
            Long localLsn2 = sessionTokenWithLowerVersion.localLsnByRegion.get(regionId);
            if (localLsn2 != null) {
                highestLocalLsnByRegion.put(regionId, Math.max(localLsn1, localLsn2));
                continue;
            }
            if (this.version == other.version) {
                throw new DocumentClientException(500, String.format("Compared session tokens '{}' and '{}' has unexpected regions.", this.sessionToken, other.sessionToken));
            }
            highestLocalLsnByRegion.put(regionId, localLsn1);
        }
        return new VectorSessionToken(Math.max(this.version, other.version), Math.max(this.globalLsn, other.globalLsn), highestLocalLsnByRegion);
    }

    public String convertToString() {
        return this.sessionToken;
    }

    private boolean areRegionProgressEqual(Map<Integer, Long> other) {
        if (this.localLsnByRegion.size() != other.size()) {
            return false;
        }
        for (Map.Entry<Integer, Long> kvp : this.localLsnByRegion.entrySet()) {
            int regionId = kvp.getKey();
            long localLsn1 = kvp.getValue();
            Long localLsn2 = other.get(regionId);
            if (localLsn2 == null || localLsn1 == localLsn2) continue;
            return false;
        }
        return true;
    }
}

