/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.OperationType;
import com.microsoft.azure.documentdb.internal.ResourceType;
import com.microsoft.azure.documentdb.internal.Utils;
import com.microsoft.azure.documentdb.internal.directconnectivity.StoreReadResult;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class ClientSideRequestStatistics {
    private static final int MAX_SUPPLEMENTAL_REQUESTS_FOR_TO_STRING = 10;
    private static final DateTimeFormatter responseTimeFormatter = DateTimeFormat.forPattern((String)"dd MMM yyyy HH:mm:ss.SSS").withLocale(Locale.US);
    private DateTime requestStartTimeUTC = DateTime.now((DateTimeZone)DateTimeZone.UTC);
    private DateTime requestEndTimeUTC = DateTime.now((DateTimeZone)DateTimeZone.UTC);
    private List<StoreResponseStatistics> responseStatisticsList = new ArrayList<StoreResponseStatistics>();
    private List<StoreResponseStatistics> supplementalResponseStatisticsList = new ArrayList<StoreResponseStatistics>();
    private Map<String, AddressResolutionStatistics> addressResolutionStatistics = new HashMap<String, AddressResolutionStatistics>();
    private List<URI> contactedReplicas = new ArrayList<URI>();
    private Set<URI> failedReplicas = new HashSet<URI>();
    private Set<URI> regionsContacted = new HashSet<URI>();

    public Period getRequestLatency() {
        return new Period((ReadableInstant)this.requestStartTimeUTC, (ReadableInstant)this.requestEndTimeUTC);
    }

    private boolean isCPUOverloaded() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordResponse(DocumentServiceRequest documentServiceRequest, StoreReadResult storeReadResult, DateTime requestStartTime) {
        DateTime responseTime = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        StoreResponseStatistics storeResponseStatistics = new StoreResponseStatistics();
        storeResponseStatistics.requestStartTimeUTC = requestStartTime;
        storeResponseStatistics.requestResponseTimeUTC = responseTime;
        storeResponseStatistics.storeReadResult = storeReadResult;
        storeResponseStatistics.requestOperationType = documentServiceRequest.getOperationType();
        storeResponseStatistics.requestResourceType = documentServiceRequest.getResourceType();
        URI locationEndPoint = documentServiceRequest.getLocationEndpointToRoute();
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            if (responseTime.isAfter((ReadableInstant)this.requestEndTimeUTC)) {
                this.requestEndTimeUTC = responseTime;
            }
            if (locationEndPoint != null) {
                this.regionsContacted.add(locationEndPoint);
            }
            if (storeResponseStatistics.requestOperationType == OperationType.Head || storeResponseStatistics.requestOperationType == OperationType.HeadFeed) {
                this.supplementalResponseStatisticsList.add(storeResponseStatistics);
            } else {
                this.responseStatisticsList.add(storeResponseStatistics);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String recordAddressResolutionStart(URI targetEndpoint) {
        String identifier = Utils.getTimeBasedRandomUUID().toString();
        AddressResolutionStatistics resolutionStatistics = new AddressResolutionStatistics();
        resolutionStatistics.startTimeUTC = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        resolutionStatistics.endTimeUTC = new DateTime(Long.MAX_VALUE);
        resolutionStatistics.targetEndpoint = targetEndpoint == null ? "<NULL>" : targetEndpoint.toString();
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            this.addressResolutionStatistics.put(identifier, resolutionStatistics);
        }
        return identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordAddressResolutionEnd(String identifier) {
        if (StringUtils.isEmpty((CharSequence)identifier)) {
            return;
        }
        DateTime responseTime = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            if (!this.addressResolutionStatistics.containsKey(identifier)) {
                throw new IllegalArgumentException("Identifier " + identifier + " does not exist. Please call start before calling end");
            }
            if (responseTime.isAfter((ReadableInstant)this.requestEndTimeUTC)) {
                this.requestEndTimeUTC = responseTime;
            }
            AddressResolutionStatistics resolutionStatistics = this.addressResolutionStatistics.get(identifier);
            resolutionStatistics.endTimeUTC = responseTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            stringBuilder.append("RequestStartTimeUTC: ").append("\"").append(this.requestStartTimeUTC.toString(responseTimeFormatter)).append("\"").append(", ").append("RequestEndTimeUTC: ").append("\"").append(this.requestEndTimeUTC.toString(responseTimeFormatter)).append("\"").append(", ").append("Number of regions attempted: ").append(this.regionsContacted.isEmpty() ? 1 : this.regionsContacted.size()).append(System.lineSeparator());
            for (StoreResponseStatistics storeResponseStatistics : this.responseStatisticsList) {
                stringBuilder.append(storeResponseStatistics.toString()).append(System.lineSeparator());
            }
            for (AddressResolutionStatistics value : this.addressResolutionStatistics.values()) {
                stringBuilder.append(value.toString()).append(System.lineSeparator());
            }
            int supplementalResponseStatisticsListCount = this.supplementalResponseStatisticsList.size();
            int initialIndex = Math.max(supplementalResponseStatisticsListCount - 10, 0);
            if (initialIndex != 0) {
                stringBuilder.append("  -- Displaying only the last ").append(10).append(" head/headfeed requests. Total head/headfeed requests: ").append(supplementalResponseStatisticsListCount);
            }
            for (int i = initialIndex; i < supplementalResponseStatisticsListCount; ++i) {
                stringBuilder.append(this.supplementalResponseStatisticsList.get(i).toString()).append(System.lineSeparator());
            }
        }
        String requestStatsString = stringBuilder.toString();
        if (!requestStatsString.isEmpty()) {
            return System.lineSeparator() + requestStatsString;
        }
        return "";
    }

    public List<URI> getContactedReplicas() {
        return this.contactedReplicas;
    }

    public void setContactedReplicas(List<URI> contactedReplicas) {
        this.contactedReplicas = contactedReplicas;
    }

    public Set<URI> getFailedReplicas() {
        return this.failedReplicas;
    }

    public void setFailedReplicas(Set<URI> failedReplicas) {
        this.failedReplicas = failedReplicas;
    }

    public Set<URI> getRegionsContacted() {
        return this.regionsContacted;
    }

    public void setRegionsContacted(Set<URI> regionsContacted) {
        this.regionsContacted = regionsContacted;
    }

    private static String formatDateTime(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.toString(responseTimeFormatter);
    }

    private class AddressResolutionStatistics {
        private DateTime startTimeUTC;
        private DateTime endTimeUTC;
        private String targetEndpoint;

        AddressResolutionStatistics() {
        }

        public String toString() {
            return "AddressResolutionStatistics{startTimeUTC=\"" + ClientSideRequestStatistics.formatDateTime(this.startTimeUTC) + "\", endTimeUTC=\"" + ClientSideRequestStatistics.formatDateTime(this.endTimeUTC) + "\", targetEndpoint='" + this.targetEndpoint + '\'' + '}';
        }
    }

    private class StoreResponseStatistics {
        private DateTime requestStartTimeUTC;
        private DateTime requestResponseTimeUTC;
        private StoreReadResult storeReadResult;
        private ResourceType requestResourceType;
        private OperationType requestOperationType;

        private StoreResponseStatistics() {
        }

        public String toString() {
            return "StoreResponseStatistics{requestStartTimeUTC=\"" + ClientSideRequestStatistics.formatDateTime(this.requestStartTimeUTC) + "\", requestResponseTimeUTC=\"" + ClientSideRequestStatistics.formatDateTime(this.requestResponseTimeUTC) + "\", storeReadResult=" + this.storeReadResult + ", requestResourceType=" + (Object)((Object)this.requestResourceType) + ", requestOperationType=" + (Object)((Object)this.requestOperationType) + '}';
        }
    }
}

