package com.microsoft.azure.documentdb.internal.query.executioncomponent;

import java.util.Map;

import com.microsoft.azure.documentdb.*;
import com.microsoft.azure.documentdb.internal.query.QueryExecutionContext;
import com.microsoft.azure.documentdb.internal.query.orderbyquery.OrderByQueryResult;

public final class OrderByQueryExecutionComponent extends QueryExecutionComponent {
    public OrderByQueryExecutionComponent(QueryExecutionContext source) {
        super(source);
    }

    @Override
    public Map<String, String> getResponseHeaders() {
        return super.source.getResponseHeaders();
    }

    @Override
    public boolean hasNext() {
        return super.source.hasNext();
    }

    @Override
    protected Document next(Document document) {
        return ((OrderByQueryResult) document).getPayload();
    }
}
