package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.ConsistencyLevel;
import com.microsoft.azure.documentdb.DocumentClientException;

/**
 * Defines an interface to work with database account configuration in the Azure Cosmos DB database service.
 */
public interface DatabaseAccountConfigurationProvider {
    ConsistencyLevel getStoreConsistencyPolicy() throws DocumentClientException;

    int getMaxReplicaSetSize() throws DocumentClientException;

    String getQueryEngineConfiguration();
}
