package com.microsoft.azure.documentdb;

/**
 * Last writer wins conflict resolution mode
 * <p>
 * These are the operation types resulted in a version conflict on a resource. 
 * When a version conflict occurs during an async operation, retrieving the {@link Conflict} instance will allow you 
 * to determine which resource and operation caused the conflict.
 */
public enum OperationKind {

  /*
   * An invalid operation.
   */
  invalid,

  /*
   * A create operation.
   */
  create,

  /*
   * An replace operation.
   */
  replace,

  /*
   * A delete operation.
   */
  delete,

  /*
   * This operation does not apply to Conflict.
   */
  read
}

