/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.datalake.store;

public class ADLStoreOptions {
    private String userAgentSuffix = null;
    private boolean insecureTransport = false;
    private boolean enableRemoteExceptions = false;
    private String pathPrefix = null;
    private int readAheadQueueDepth = -1;
    private int defaultTimeout = -1;

    public ADLStoreOptions setUserAgentSuffix(String userAgentSuffix) {
        this.userAgentSuffix = userAgentSuffix;
        return this;
    }

    String getUserAgentSuffix() {
        return this.userAgentSuffix;
    }

    public ADLStoreOptions setInsecureTransport() {
        this.insecureTransport = true;
        return this;
    }

    boolean isUsingInsecureTransport() {
        return this.insecureTransport;
    }

    public ADLStoreOptions enableThrowingRemoteExceptions() {
        this.enableRemoteExceptions = true;
        return this;
    }

    boolean isThrowingRemoteExceptionsEnabled() {
        return this.enableRemoteExceptions;
    }

    public ADLStoreOptions setFilePathPrefix(String prefix) {
        this.pathPrefix = prefix;
        return this;
    }

    String getFilePathPrefix() {
        return this.pathPrefix;
    }

    public ADLStoreOptions setReadAheadQueueDepth(int queueDepth) {
        if (queueDepth < 0) {
            throw new IllegalArgumentException("Queue depth has to be 0 or more");
        }
        this.readAheadQueueDepth = queueDepth;
        return this;
    }

    int getReadAheadQueueDepth() {
        return this.readAheadQueueDepth;
    }

    public ADLStoreOptions setDefaultTimeout(int defaultTimeoutInMillis) {
        this.defaultTimeout = defaultTimeoutInMillis;
        return this;
    }

    int getDefaultTimeout() {
        return this.defaultTimeout;
    }
}

