/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.azure.CloudError;
import com.microsoft.azure.CloudException;
import com.microsoft.rest.protocol.SerializerAdapter;
import java.io.IOException;
import java.lang.reflect.Type;
import okhttp3.ResponseBody;
import retrofit2.Response;

final class PollingState<T> {
    private Response<ResponseBody> response;
    private String status;
    private String azureAsyncOperationHeaderLink;
    private String locationHeaderLink;
    private Integer retryTimeout;
    private T resource;
    private Type resourceType;
    private CloudError error;
    private SerializerAdapter<?> serializerAdapter;

    PollingState(Response<ResponseBody> response, Integer retryTimeout, Type resourceType, SerializerAdapter<?> serializerAdapter) throws IOException {
        this.retryTimeout = retryTimeout;
        this.withResponse(response);
        this.resourceType = resourceType;
        this.serializerAdapter = serializerAdapter;
        String responseContent = null;
        PollingResource resource = null;
        if (response.body() != null) {
            responseContent = ((ResponseBody)response.body()).string();
            ((ResponseBody)response.body()).close();
        }
        if (responseContent != null && !responseContent.isEmpty()) {
            this.resource = serializerAdapter.deserialize(responseContent, resourceType);
            resource = (PollingResource)serializerAdapter.deserialize(responseContent, PollingResource.class);
        }
        if (resource != null && resource.properties != null && resource.properties.provisioningState != null) {
            this.withStatus(resource.properties.provisioningState);
        } else {
            switch (this.response.code()) {
                case 202: {
                    this.withStatus("InProgress");
                    break;
                }
                case 200: 
                case 201: 
                case 204: {
                    this.withStatus("Succeeded");
                    break;
                }
                default: {
                    this.withStatus("Failed");
                }
            }
        }
    }

    void updateFromResponseOnPutPatch(Response<ResponseBody> response) throws CloudException, IOException {
        String responseContent = null;
        if (response.body() != null) {
            responseContent = ((ResponseBody)response.body()).string();
            ((ResponseBody)response.body()).close();
        }
        if (responseContent == null || responseContent.isEmpty()) {
            throw new CloudException("polling response does not contain a valid body", response);
        }
        PollingResource resource = (PollingResource)this.serializerAdapter.deserialize(responseContent, PollingResource.class);
        if (resource != null && resource.properties != null && resource.properties.provisioningState != null) {
            this.withStatus(resource.properties.provisioningState);
        } else {
            this.withStatus("Succeeded");
        }
        CloudError error = new CloudError();
        this.withErrorBody(error);
        error.withCode(this.status());
        error.withMessage("Long running operation failed");
        this.withResponse(response);
        this.withResource(this.serializerAdapter.deserialize(responseContent, this.resourceType));
    }

    void updateFromResponseOnDeletePost(Response<ResponseBody> response) throws IOException {
        this.withResponse(response);
        String responseContent = null;
        if (response.body() != null) {
            responseContent = ((ResponseBody)response.body()).string();
            ((ResponseBody)response.body()).close();
        }
        this.withResource(this.serializerAdapter.deserialize(responseContent, this.resourceType));
        this.withStatus("Succeeded");
    }

    int delayInMilliseconds() {
        if (this.retryTimeout != null) {
            return this.retryTimeout * 1000;
        }
        if (this.response != null && this.response.headers().get("Retry-After") != null) {
            return Integer.parseInt(this.response.headers().get("Retry-After")) * 1000;
        }
        return 30000;
    }

    String status() {
        return this.status;
    }

    Type resourceType() {
        return this.resourceType;
    }

    PollingState<T> withStatus(String status) throws IllegalArgumentException {
        if (status == null) {
            throw new IllegalArgumentException("Status is null.");
        }
        this.status = status;
        return this;
    }

    Response<ResponseBody> response() {
        return this.response;
    }

    PollingState<T> withResponse(Response<ResponseBody> response) {
        this.response = response;
        if (response != null) {
            String asyncHeader = response.headers().get("Azure-AsyncOperation");
            String locationHeader = response.headers().get("Location");
            if (asyncHeader != null) {
                this.azureAsyncOperationHeaderLink = asyncHeader;
            }
            if (locationHeader != null) {
                this.locationHeaderLink = locationHeader;
            }
        }
        return this;
    }

    String azureAsyncOperationHeaderLink() {
        return this.azureAsyncOperationHeaderLink;
    }

    String locationHeaderLink() {
        return this.locationHeaderLink;
    }

    T resource() {
        return this.resource;
    }

    PollingState<T> withResource(T resource) {
        this.resource = resource;
        return this;
    }

    CloudError errorBody() {
        return this.error;
    }

    private PollingState<T> withErrorBody(CloudError error) {
        this.error = error;
        return this;
    }

    private static class PollingResource {
        @JsonProperty(value="properties")
        private Properties properties;

        private PollingResource() {
        }

        private static class Properties {
            @JsonProperty(value="provisioningState")
            private String provisioningState;

            private Properties() {
            }
        }
    }
}

